/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */
 
/**
 * PReP Version 1.0
 *
 * PRePTag: (abstract) consists of a tagName and two compile_methods, such as
 *         - compile(stream, tagList, user)
 *         - compile(stream)
 *
 *         a PRePTag constists of a name and a value  
 *
 * History: - Creation nh
 *
 * @author nh
 * @version 1.0
 * @see PRePMain, TagList
 */
package com.delec.prep;
import java.io.*;

abstract public class PRePTag 
{
	/**
	 * Tag name
	 */
	String sTagName;
	String sTagValue;

	public PRePTag()
	{
	}

	/**
	 * Constructor
	 * @param String name of the tag
	 */

	public PRePTag(String sTagName)
	{
		this.sTagName = sTagName.trim();
	}

	/**
	 * compile
	 * @param Session 
	 */
	public void compile(Session session)
	{
	}

	/** compile the tag to a given print writer
	  @param Session the session
	  @param PrintWriter the printwriter to compile the tag to
	**/
	public void compile(Session session, PrintWriter pw)
	{
		PrintWriter pwOld = session.getPrintWriter();
		session.setPrintWriter(pw);
		compile(session);
		session.setPrintWriter(pwOld);
	}

	/**
	 * getValue: gets one line of the value of a tag and returns it as a String
	 * @return the first line of the value
	 */
	public String getValue()
	{
		return "";
	}

	/**
	 * getAllValue: gets the whole value and returns it as a String
	 * @return all values
	 */
	public String getAllValue()
	{
		return sTagValue;
	}

	/**
	 * setValue: sets the specified object as value in the tag
	 * @param Object the value
	 */
	public void setValue(Object obj)
	{
	}

	public void setName(String strName)
	{
		sTagName = strName.trim();
	}

	/**
	 * debugOutput: helps to find some exceptions
	 * @return the tag name between a star and a newline
	 */
	public String debugOutput()
	{
		return("*"+sTagName+"\n");    
	}

	/** 
	 * getName: returns the name of this tag as a String 
	 * @return the name of the tag
	 */
	public String getName()
	{
		return sTagName;
	}

	public String toString()
	{
		return "*"+sTagName+"\r\n"+getAllValue()+"\r\n";
	}


	protected int getArgCount(Session session)
	{
		PRePTagCount prepTagCount = (PRePTagCount)session.getTagList().find("ARG0");

		if ( prepTagCount != null )
		{
			return prepTagCount.getIntValue();
		}
		else
		{
			return 0;
		}
	}

	protected int getArgCount(TagList tagList)
	{
		PRePTagCount ptArgCount = (PRePTagCount) getArg(tagList, 0);
		if ( ptArgCount != null )
		{
			return ptArgCount.getIntValue();
		}
		return 0;
	}

	protected PRePTag getArg(Session session, int i)
	{
		return getArg(session.getTagList(), i);
	}

	protected PRePTag getArg(TagList tagList, int i)
	{
		return getTag(tagList, "ARG"+i);
	}

	protected PRePTag getTag(Session session, String strTagName)
	{
		return getTag(session.getTagList(), strTagName);
	}

	protected PRePTag getTag(TagList tagList, String strTagName)
	{
		return tagList.find(strTagName);
	}

	protected void exception(Session session, Exception e, String strMsg)
	{
		session.getExceptionList().addElement(new PRePException(this, strMsg+" "+e));
	}

	protected void exception(Session session, String strMsg)
	{
	    session.getExceptionList().addElement(new PRePException(this, strMsg));
	}

}
