/*
 * Decompiled with CFR 0.152.
 */
package com.kashif.utils;

import com.kashif.utils.ArgumentParser;
import com.kashif.utils.BadArgumentsException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

class CheckPath {
    private static ArgumentParser parser = null;
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    public static final int MAX_ARGS_LENGTH = 5;
    public static final int MIN_ARGS_LENGTH = 1;
    public static final String ARG_HELP = "-h";
    public static final String ARG_CLASSPATH = "-cp";
    public static final String ARG_FILE_LIST = "-f";
    public static final String ARG_TOKENIZER = "-sep";
    public static final String ARG_CHECK_DUPLICATES = "-dup";
    public final int MODE_UNDETERMINED = 0;
    public final int MODE_HELP = 1;
    public final int MODE_CLASSPATH = 16;
    public final int MODE_FILE = 256;
    public final int MODE_FILE_LIST = 4096;
    public final int MODE_TOKENIZER = 65536;
    public final int MODE_CHECK_DUPLICATES = 0x100000;
    private int mode = 0;
    private Vector fileList = new Vector();

    private boolean doFilesExist() {
        boolean bAllFilesExist = true;
        Enumeration e = this.fileList.elements();
        while (e.hasMoreElements()) {
            String fileName = (String)e.nextElement();
            if (this.doesFileExist(fileName)) continue;
            bAllFilesExist = false;
        }
        return bAllFilesExist;
    }

    private static void usage() {
        System.out.println("Usage --> java com.kashif.utils.CheckPath [-h] [fileName] [[-cp <no arg>] [-f <file of filenames> -sep <path tokenizer: (default \\n)>]] [-dup <noargs>]");
        CheckPath.exit();
    }

    private void parseFileLine(String fileLine, String tokenizer) {
        StringTokenizer strTokenizer = new StringTokenizer(fileLine, tokenizer);
        while (strTokenizer.hasMoreElements()) {
            String fileName = (String)strTokenizer.nextElement();
            this.fileList.addElement(fileName);
        }
    }

    private static void exit() {
        System.exit(1);
    }

    CheckPath() {
    }

    private void setMode(int i) {
        this.mode = i;
    }

    private int getMode() {
        return this.mode;
    }

    private static void help() {
        System.out.println();
        System.out.println("CheckPath allows you to verify that your classpath does not contain absent or duplicate files. You can also use it to check if any delimited list of files has absent or duplicate entries.");
        System.out.println("Examples:");
        System.out.println("CheckPath -h");
        System.out.println("CheckPath -cp");
        System.out.println("CheckPath -dup");
        System.out.println("CheckPath -cp -dup");
        System.out.println("CheckPath c:\\boot.ini");
        System.out.println("CheckPath -f fileList.txt -dup");
        System.out.println("CheckPath -f fileList.txt -sep \";\" -dup");
        System.out.println();
        CheckPath.usage();
    }

    private void startProcessing() {
        String classPath;
        int mode = this.getMode();
        if ((mode & 1) > 0) {
            CheckPath.help();
        }
        if ((mode & 0x10) > 0) {
            classPath = System.getProperty("java.class.path");
            this.parseFileLine(classPath, PATH_SEPARATOR);
            if (this.doFilesExist()) {
                System.out.println("All files specified in the System classpath exists");
                System.out.println();
            }
        }
        if ((mode & 0x100) > 0) {
            String fileName = (String)parser.getAllUnpairedValues().elementAt(0);
            String ans = new CheckPath().doesFileExist(fileName) ? "exists" : "does not exist";
            System.out.println(fileName + " " + ans);
        }
        if ((mode & 0x1000) > 0) {
            String listFileName = parser.getArgValue(ARG_FILE_LIST);
            if (listFileName == null) {
                System.out.println("Please specify a file name to read list of files from");
                CheckPath.help();
            }
            String tokenizer = LINE_SEPARATOR;
            if (parser.isArgumentPresent(ARG_TOKENIZER)) {
                tokenizer = parser.getArgValue(ARG_TOKENIZER);
            }
            this.readListFile(listFileName, tokenizer);
            if (this.doFilesExist()) {
                System.out.println("All files specified in " + listFileName + " exist");
            }
        }
        if ((mode & 0x100000) > 0) {
            System.out.println();
            System.out.println("Checking for duplicates in file list ... ");
            if (!parser.isArgumentPresent(ARG_FILE_LIST) && !parser.isArgumentPresent(ARG_CLASSPATH)) {
                classPath = System.getProperty("java.class.path");
                this.parseFileLine(classPath, PATH_SEPARATOR);
                System.out.println("Using System classpath as file list ... ");
            }
            if (this.fileList.isEmpty()) {
                System.out.println("Empty file list. Cannot check for duplicates.");
                return;
            }
            boolean bDuplicatesFound = false;
            Hashtable<String, String> fileTable = new Hashtable<String, String>();
            Enumeration e = this.fileList.elements();
            while (e.hasMoreElements()) {
                String fileName = (String)e.nextElement();
                if (fileTable.get(fileName) == null) {
                    fileTable.put(fileName, fileName);
                    continue;
                }
                bDuplicatesFound = true;
                System.out.println(fileName + " is a duplicate");
            }
            if (!bDuplicatesFound) {
                System.out.println("There were no duplicates found in the filelist");
            }
        }
        if (mode == 0) {
            System.out.println("Bad arguments");
            CheckPath.help();
        }
    }

    private void readListFile(String listFileName, String sep) {
        try {
            BufferedReader r = new BufferedReader(new FileReader(listFileName));
            String line = null;
            boolean bFound = true;
            while ((line = r.readLine()) != null) {
                this.parseFileLine(line, sep);
            }
        }
        catch (FileNotFoundException e1) {
            System.out.println("Unable to find file: " + e1.getMessage());
            CheckPath.exit();
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
    }

    public void verifyClassPathAndCheckDuplicates() {
        this.setMode(0x100010);
        this.startProcessing();
    }

    public static void main(String[] args) {
        Vector<String> possibleArgs = new Vector<String>();
        possibleArgs.addElement(ARG_CHECK_DUPLICATES);
        possibleArgs.addElement(ARG_CLASSPATH);
        possibleArgs.addElement(ARG_FILE_LIST);
        possibleArgs.addElement(ARG_HELP);
        possibleArgs.addElement(ARG_TOKENIZER);
        parser = new ArgumentParser("-", possibleArgs, 1, 5);
        try {
            parser.parseArgs(args);
        }
        catch (BadArgumentsException e) {
            System.out.println("\n");
            System.out.println(e.getMessage());
            CheckPath.help();
        }
        CheckPath pathChecker = new CheckPath();
        pathChecker.handleArguments(parser);
        pathChecker.startProcessing();
    }

    public boolean doesFileExist(String fileName) {
        if (new File(fileName).exists()) {
            return true;
        }
        System.out.println(fileName + " " + "does not exist");
        return false;
    }

    private void handleArguments(ArgumentParser parser) {
        Vector v = parser.getAllUnpairedArgs();
        if (v != null && v.size() > 0) {
            if (parser.isArgumentPresent(ARG_HELP)) {
                this.setMode(this.getMode() | 1);
                return;
            }
            if (parser.isArgumentPresent(ARG_CHECK_DUPLICATES)) {
                this.setMode(this.getMode() | 0x100000);
            }
            if (parser.isArgumentPresent(ARG_CLASSPATH)) {
                this.setMode(this.getMode() | 0x10);
                return;
            }
        }
        if ((v = parser.getAllUnpairedValues()) != null && v.size() == 1) {
            this.setMode(this.getMode() | 0x100);
        }
        if (parser.isArgumentPresent(ARG_FILE_LIST)) {
            this.setMode(this.getMode() | 0x1000);
            if (parser.isArgumentPresent(ARG_TOKENIZER)) {
                this.setMode(this.getMode() | 0x10000);
            }
        }
    }

    public static void run(String[] args) {
        parser = new ArgumentParser("-", null, 1, 5);
        try {
            parser.parseArgs(args);
        }
        catch (BadArgumentsException e) {
            System.out.println("\n");
            System.out.println(e.getMessage());
            CheckPath.help();
        }
        CheckPath pathChecker = new CheckPath();
        pathChecker.handleArguments(parser);
        pathChecker.startProcessing();
    }
}

