/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.win32.ui.controls.SelectFolderField;

import javax.swing.*;
import java.awt.*;

/**
 * @author Serge Piletsky
 */
class ChooseFolderSample extends LazyPanel
{
    private JLabel lblAdvisoryText;
    private JLabel lblSelectedFolderCaption;
    private SelectFolderField _selectFolderField;
    private JLabel lblSelectedPrinterCaption;
    private SelectFolderField _selectPrinterField;
    private JLabel lblSelectedComputerCaption;
    private SelectFolderField _selectComputerField;

    public ChooseFolderSample(Window parent)
    {
        super(parent);
    }

    public void initialize() throws Exception
    {
        lblAdvisoryText = new HTMLText("This page demonstrates different variants of system Choose Folder dialog.");
        lblSelectedFolderCaption = new JLabel("Select Folder:");
        _selectFolderField = new SelectFolderField();
        lblSelectedPrinterCaption = new JLabel("Select Printer:");
        _selectPrinterField = new SelectFolderField(SelectFolderField.MODE_SELECT_PRINTER);
        lblSelectedComputerCaption = new JLabel("Select Computer:");
        _selectComputerField = new SelectFolderField(SelectFolderField.MODE_SELECT_COMPUTER);

        setLayout(new GridBagLayout());

        add(lblAdvisoryText, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(10, 10, 10, 10), 0, 0));

        add(lblSelectedFolderCaption, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 10, 0, 0), 0, 0));

        add(_selectFolderField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 10, 0, 0), 0, 0));

        add(lblSelectedPrinterCaption, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 10, 0, 0), 0, 0));

        add(_selectPrinterField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 10, 0, 0), 0, 0));

        add(lblSelectedComputerCaption, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 10, 0, 0), 0, 0));

        add(_selectComputerField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 10, 0, 0), 0, 0));

        add(new JPanel(), new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0
                , GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

        super.initialize();
    }
}

