/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.DefaultLibraryLoader;
import com.jniwrapper.win32.Rect;
import com.jniwrapper.win32.gdi.Icon;
import com.jniwrapper.win32.gdi.SystemColor;
import com.jniwrapper.win32.samples.demo.HeaderPanel;
import com.jniwrapper.win32.samples.demo.LazyPanel;
import com.jniwrapper.win32.samples.demo.MenuTreeModel;
import com.jniwrapper.win32.samples.demo.TreeCellRenderer;
import com.jniwrapper.win32.ui.AWTWindowDecorator;
import com.jniwrapper.win32.ui.DesktopWindow;
import com.jniwrapper.win32.ui.Wnd;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class WinPackSet
extends JFrame {
    private JTree _menuTree;

    public WinPackSet() throws HeadlessException {
        super("WinPack Demo");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        final JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        final HeaderPanel headerPanel = new HeaderPanel();
        Dimension headerSize = new Dimension(390, 30);
        headerPanel.setPreferredSize(headerSize);
        headerPanel.setMinimumSize(headerSize);
        headerPanel.setVisible(false);
        contentPanel.add(headerPanel, "North", 0);
        JSplitPane splitter = new JSplitPane(1, true);
        splitter.setBorder(null);
        splitter.setDividerSize(2);
        splitter.setDividerLocation(200);
        this._menuTree = new JTree();
        this._menuTree.setVisible(false);
        this._menuTree.setEditable(false);
        BasicTreeUI basicTreeUI = (BasicTreeUI)this._menuTree.getUI();
        basicTreeUI.setCollapsedIcon(new ImageIcon(this.getClass().getResource("res/Closed.gif")));
        basicTreeUI.setExpandedIcon(new ImageIcon(this.getClass().getResource("res/Opened.gif")));
        this._menuTree.setCellRenderer(new TreeCellRenderer());
        this._menuTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getPath();
                Component component = null;
                try {
                    component = contentPanel.getComponent(1);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (component instanceof LazyPanel) {
                    LazyPanel panel = (LazyPanel)component;
                    panel.deactivate();
                }
                if (component != null) {
                    contentPanel.remove(component);
                }
                DefaultMutableTreeNode pathComponent = (DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 1);
                Object userObject = pathComponent.getUserObject();
                String title = pathComponent.toString();
                if (userObject instanceof JPanel) {
                    JPanel panel = (JPanel)userObject;
                    contentPanel.add(panel, "Center", 1);
                    if (userObject instanceof LazyPanel) {
                        headerPanel.setVisible(true);
                        LazyPanel lazyPanel = (LazyPanel)userObject;
                        try {
                            lazyPanel.activate();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    } else {
                        headerPanel.setVisible(false);
                    }
                }
                headerPanel.setTitle(title);
                contentPanel.updateUI();
            }
        });
        JScrollPane menuPanel = new JScrollPane(this._menuTree);
        splitter.add((Component)menuPanel, "left");
        splitter.add((Component)contentPanel, "right");
        contentPane.add((Component)splitter, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                WinPackSet.this._menuTree.setModel(new MenuTreeModel(WinPackSet.this));
                int i = 0;
                while (i < WinPackSet.this._menuTree.getRowCount()) {
                    WinPackSet.this._menuTree.expandRow(i);
                    ++i;
                }
                WinPackSet.this._menuTree.setSelectionRow(0);
                WinPackSet.this._menuTree.setVisible(true);
                WinPackSet.this._menuTree.putClientProperty("JTree.lineStyle", "None");
                AWTWindowDecorator decorator = new AWTWindowDecorator((Window)WinPackSet.this);
                Icon smallIcon = new Icon();
                smallIcon.loadFromFile("jniwrapper.ico");
                Icon bigIcon = new Icon(1);
                bigIcon.loadFromFile("jniwrapper.ico");
                decorator.setWindowIcon(smallIcon);
                decorator.setWindowIcon(bigIcon);
            }
        });
    }

    private static void setupLF() {
        UIDefaults defaults = UIManager.getDefaults();
        Font tahoma = new Font("Tahoma", 0, 11);
        Color btnFaceFolor = SystemColor.BTNFACE.getColor();
        Color highlight = SystemColor.HIGHLIGHT.getColor();
        Color highlightText = SystemColor.HIGHLIGHTTEXT.getColor();
        Color scrollBar = SystemColor.SCROLLBAR.getColor();
        defaults.put("Button.font", tahoma);
        defaults.put("Button.background", btnFaceFolor);
        defaults.put("ToggleButton.font", tahoma);
        defaults.put("RadioButton.font", tahoma);
        defaults.put("CheckBox.font", tahoma);
        defaults.put("CheckBox.background", btnFaceFolor);
        defaults.put("Slider.font", tahoma);
        defaults.put("Slider.background", btnFaceFolor);
        defaults.put("Slider.foreground", scrollBar);
        defaults.put("ComboBox.font", tahoma);
        defaults.put("Label.font", tahoma);
        defaults.put("Label.foreground", Color.black);
        defaults.put("List.font", tahoma);
        defaults.put("List.selectionBackground", highlight);
        defaults.put("List.selectionForeground", highlightText);
        defaults.put("Panel.font", tahoma);
        defaults.put("Panel.background", btnFaceFolor);
        defaults.put("ScrollPane.font", tahoma);
        defaults.put("ScrollBar.background", scrollBar);
        defaults.put("ScrollBar.foreground", btnFaceFolor);
        defaults.put("ScrollBar.thumb", btnFaceFolor);
        defaults.put("ScrollBar.thumbHighlight", btnFaceFolor);
        defaults.put("Viewport.font", tahoma);
        defaults.put("Viewport.background", Color.white);
        defaults.put("Table.font", tahoma);
        defaults.put("Table.selectionBackground", highlight);
        defaults.put("Table.selectionForeground", highlightText);
        defaults.put("TableHeader.font", tahoma);
        defaults.put("TableHeader.background", btnFaceFolor);
        defaults.put("TextField.font", tahoma);
        defaults.put("TextField.selectionBackground", highlight);
        defaults.put("TextField.selectionForeground", highlightText);
        defaults.put("Tree.font", tahoma);
        defaults.put("Tree.selectionBackground", highlight);
        defaults.put("Tree.selectionForeground", highlightText);
        defaults.put("Table.focusCellHighlightBorder", new EmptyBorder(1, 1, 1, 1));
        defaults.put("SplitPaneDivider.border", new EmptyBorder(0, 0, 0, 0));
    }

    private static void centerWindow(Window window) {
        DesktopWindow desktop = DesktopWindow.getInstance();
        Rect desktopRect = new Rect();
        Wnd.getWindowRect((Wnd)desktop, (Rect)desktopRect);
        int width = window.getWidth();
        int height = window.getHeight();
        int x = (int)(desktopRect.getRight() - (long)width) / 2;
        int y = (int)(desktopRect.getBottom() - (long)height) / 2;
        window.setLocation(x, y);
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        DefaultLibraryLoader.getInstance().addPath("bin");
        WinPackSet.setupLF();
        WinPackSet window = new WinPackSet();
        window.setSize(600, 400);
        window.setBackground(SystemColor.BTNFACE.getColor());
        WinPackSet.centerWindow(window);
        window.setVisible(true);
    }
}

