/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ui;

import com.jniwrapper.win32.ui.WindowDecorator;
import com.jniwrapper.win32.ui.WindowTools;
import com.jniwrapper.win32.ui.Wnd;
import java.awt.Dimension;
import java.awt.Window;

public class AWTWindowDecorator
extends WindowDecorator {
    private Window _window;

    public AWTWindowDecorator() {
        String value = System.getProperty("sun.java2d.noddraw");
        if (value == null || value.length() == 0) {
            throw new IllegalStateException("System property sun.java2d.noddraw required");
        }
    }

    public AWTWindowDecorator(Window component) {
        this();
        this.setWindow(component);
    }

    public Window getWindow() {
        return this._window;
    }

    public void setWindow(Window window) {
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this._window = window;
        Wnd hWnd = new Wnd(WindowTools.getWindowHandle(window));
        this.setWindowHandle(hWnd);
    }

    public void setTransparent(boolean transparent) {
        super.setTransparent(transparent);
        this.forceWindowRepaint();
    }

    private void forceWindowRepaint() {
        Dimension size = this.getWindow().getSize();
        this.getWindow().setSize(0, 0);
        this.getWindow().setSize(size);
    }
}

