package com.tolstoy.imagemeister;

import com.jconfig.*;
import java.io.*;
import java.awt.*;
import java.util.*;

/**
A DiskFilter implementation which gets a list of the files shown when the 'Show all files' checkbox is *not*
selected.

To use:

<UL>
<LI>create an object of this class, passing a Vector containing a list of PluginI objects to the constructor.
<LI>Then, call a DiskObject's iterate() method with this object.
<LI>The DiskObject will call this object's visit() method with each DiskObject contained within the former DiskObject.
<LI>If the DiskObject passed to visit() is a folder, it's added to the 'items' vector.
<LI>If the DiskObject passed to visit() is a file, the canCreateImageViewer() method of each of the PluginI objects
in 'plugins' is called, and if that method returns true, it is added to the 'items' vector.
<LI>Finally, after the DiskObject's iterate() method returns, call the 'getArray()' method to get the list
of DiskObjects compiled by the visit() method.
</UL>

See the PluginManager's runDiskFilter() for an example.

Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.
*/

class PIMDiskFilter implements DiskFilter {
	private static final String copyrightString = "JConfig Copyright (c) 1997-2002 Samizdat Productions. All Rights Reserved.";
	private Vector				items, plugins;
	private int					count, maxToReturn, numPlugins;

	PIMDiskFilter( int max, Vector plgs ) {
		maxToReturn = max;
		plugins = plgs;
		numPlugins = plugins.size();
		items = new Vector( max, 5 );
		count = 0;
	}

	DiskObject[] getArray() {
		DiskObject			retArray[];

		if ( count < 1 )
			return null;
			
		retArray = new DiskObject[ count ];
		items.copyInto( retArray );

		return retArray;
	}

	private boolean passesTest( DiskObject diskObj ) {
		PluginI				plug;
		FileSpecifier		spec;
		FileExtension		ext;
		FinderInfo			finfo;
		String				name;
		int					i, finfoArray[];

		if ( ( diskObj instanceof DiskVolume ) )
			return true;

		if ( ( diskObj instanceof DiskAlias ) )
			return false;

		if ( !( diskObj instanceof DiskFile ) )
			return false;

		if ( ( diskObj.getFlags() & DiskFile.FILE_DIR ) != 0 )
			return true;
		
		//	if we get here, it's a disk file
		try {
			spec = IMUtils.makeFileSpecifier( diskObj );
		}
		catch ( Exception e ) {
			return false;
		}

		for ( i = 0; i < numPlugins; i++ ) {
			plug = (PluginI) plugins.elementAt( i );
			if ( plug.canCreateImageViewer( spec ) )
				return true;
		}

		return false;
	}

	public boolean visit( DiskObject diskObj ) {
		if ( count >= maxToReturn )
			return false;

		if ( passesTest( diskObj ) ) {
			items.addElement( diskObj );
			++count;
		}
	
		return true;
	}
}

