package com.tolstoy.imagemeister;

import java.io.*;
import com.jconfig.Trace;

/**
@author Copyright (c) 1997,1998,1999,2000 Samizdat Productions. All Rights Reserved.
*/

class DDSink {
	private static boolean		bInited = false;
	private static String		path = null;

	public static final void init( String pth ) {
		PrintStream		ps;

		if ( bInited )
			return;

		if ( pth == null )
			return;

		path = pth;

		Trace.println( "DDSink.init: path=" + path );

		try {
			ps = new PrintStream( new FileOutputStream( path ) );
			ps.close();
			bInited = true;
		}
		catch ( Exception e ) {}

		Trace.println( "DDSink bInited=" + bInited );
	}

	private DDSink() {
	}

	public static final boolean isInited() {
		return bInited;
	}

	public static final void writeCommand( String command ) {
		RandomAccessFile		realFile;

		if ( !bInited || path == null )
			return;

		try {
			realFile = new RandomAccessFile( path, "rw" );
			realFile.seek( realFile.length() );
			realFile.writeBytes( command + "\n" );
			realFile.close();

			Trace.println( "DDSink: cmd=" + command );
		}
		catch ( Exception e ) {
		}
	}
}

