/*
Author: Pramod S. Jaiswal
April 20, 2001

This programs depicts how to use the DatePickerBean as CellEditor in a JTable
Although its looks a little complicated but its really simple if you carefully understand the flow.

PLEASE ADD DatePicker.jar to your classpath and then do Javac

*/


import java.awt.event.*;//for window adapter
import java.awt.*;//for Window class

import javax.swing.*;
import javax.swing.table.TableCellEditor;
import javax.swing.table.DefaultTableCellRenderer;

import javax.swing.event.*;
import java.util.*;
import javax.swing.table.DefaultTableModel;
import DatePickerBean.*;


class WinMonitor extends WindowAdapter{

	public void windowClosing(WindowEvent we){
		Window w=we.getWindow();
		w.setVisible(false);
		w.dispose();
		System.exit(0);
	}
}

public class MyJTable
{
	public MyJTable()
	{
		// Create application frame.
		 MainFrame frame = new MainFrame();
				
		frame.show();
	}
	public static void main(String[] args)
	{
		// Create application frame.
		 new MyJTable();
	}
}

class MainFrame extends JFrame
{
	JTable jt;
	
	public MainFrame()
	{
		super("Custom JTable trial.  CLICK ON Dates (DOB)");
		

		addWindowListener(new WinMonitor());

		
		Toolkit tk=Toolkit.getDefaultToolkit();
 		Dimension sd = tk.getScreenSize();	
		setSize((int)sd.getWidth(),(int)sd.getHeight());

	
		MyTableModel mtm=new MyTableModel();

		jt=new JTable(mtm);

		
		DefaultTableCellRenderer dc2=new DefaultTableCellRenderer();
			dc2.setHorizontalAlignment(SwingConstants.CENTER);
		jt.setDefaultRenderer(MyDate.class,dc2);
			
		myDatePickerEditor mdpe=new myDatePickerEditor();
		try{
			mdpe.setDateFormat(DatePicker.mmmm_dd_yyyy);
			mdpe.setMinDate(1800,1,1);
			mdpe.setMaxDate(2050,12,31);
		}
		catch(DatePickerException e)
		{
			System.out.println(e);
		}
		jt.setDefaultEditor(MyDate.class,mdpe);
		
		jt.setRowHeight(25);
		JScrollPane jsp=new JScrollPane(jt);
		getContentPane().add(jsp);

	}



}

class MyTableModel extends DefaultTableModel
{
	public MyTableModel()
	{
		super();
		setDataVector(getJTValues(),getJTCols());
	}

	Vector getJTValues()
	{
		Vector mainV=new Vector();
		Vector subV;
		
		subV=new Vector();
			subV.addElement("Pramod S. Jaiswal");
			subV.addElement("24");
			subV.addElement("THANE Mumbai");
			subV.addElement(new MyDate(1977,4,21));
			subV.addElement(new Boolean(false));
		mainV.addElement(subV);
		
		subV=null;
	        subV=new Vector();
			subV.addElement("Shailesh K. Ashar");
			subV.addElement("24");
			subV.addElement("THANE Mumbai");
			subV.addElement(new MyDate(1977,5,12));
			subV.addElement(new Boolean(false));
		mainV.addElement(subV);


		
		return mainV;
	}

	Vector getJTCols()
	{
		Vector cols =new Vector();
		cols.addElement("NAME");
		cols.addElement("AGE");
		cols.addElement("ADDRESS");
		cols.addElement("DOB");
		cols.addElement("MARRIED");
		return cols;

	}

	public boolean isCellEditable(int row,int column)
	{
		if(column==1)//Age
			return false;
		else
			return true;
	}
	public Class getColumnClass(int columnIndex)
	{
		
		if(columnIndex==3)//dob
		{
			return MyDate.class;
		}
		else if(columnIndex==4)//married
			return Boolean.class;
		else
			return String.class;//super.getColumnClass(columnIndex);
	}

	


}


class MyDate
{
	int yyyy,mm,dd;
	DatePicker dp=new DatePicker();
	public MyDate()
	{
		yyyy=0;
		mm=0;
		dd=0;

	}
	public MyDate(int y,int m,int d)
	{
		yyyy=y;
		mm=m;
		dd=d;
	}

	public int getYear()
	{
		return yyyy;
	}
	public int getMonth()
	{
		return mm;
	}
	public int getDay()
	{
		return dd;
	}
	public String toString()
	{
		return dp.getFormattedDate(new java.util.GregorianCalendar(yyyy,mm-1,dd),dp.mmmm_dd_yyyy );
	}
}

class myDatePickerEditor extends DatePicker implements TableCellEditor
{
	protected transient int xyyyy,xmm,xdd;
	protected transient Vector listeners;

	public myDatePickerEditor()
	{
		super();
		listeners=new Vector();
	}
	
	//TableCellEditor mehtod
	public Component getTableCellEditorComponent(JTable table,Object value,boolean isSelected,int row,int column)
	{
		if(value == null)
			return this;


		if(value instanceof MyDate)
		{
			int yyyy,mm,dd;

			yyyy=((MyDate)value).getYear();
			mm=((MyDate)value).getMonth();
			dd=((MyDate)value).getDay();
			
			try{
				setDate(yyyy,mm,dd);
				
			}
			catch(DatePickerException e)
			{
				System.out.println(e);
			}
		}
		
		table.setRowSelectionInterval(row,row);
		table.setColumnSelectionInterval(column,column);
		
		xyyyy=getYear();
		xmm=getMonth();
		xdd=getDay();

		return this;
		
	}

	//CellEditor methods 
	public Object getCellEditorValue()//imp
	{
		
		return 	new MyDate(getYear(),getMonth(),getDay());
	}

	public void cancelCellEditing() 
	{
		fireEditingCanceled();
	}
	public boolean isCellEditable(EventObject eo)
	{
		return true;
	}
	public boolean shouldSelectCell(EventObject eo)
	{
		return true;
	}
	public boolean stopCellEditing()
	{
		fireEditingStopped();
		return true;
	}

	public void addCellEditorListener(CellEditorListener cell)
	{
		listeners.addElement(cell);
	}
	public void removeCellEditorListener(CellEditorListener cell)
	{
		listeners.removeElement(cell);
	}

	protected void fireEditingCanceled()
	{
			try{
				setDate(xyyyy,xmm,xdd);
			}
			catch(DatePickerException e)
			{
				System.out.println(e);
			}
		
		ChangeEvent ce=new ChangeEvent(this);
		for(int i=listeners.size() ; i >= 0 ; i--)
		{
			((CellEditorListener)listeners.elementAt(i)).editingCanceled(ce);
		}
	}

	protected void fireEditingStopped()
	{
		ChangeEvent ce=new ChangeEvent(this);
		for(int i=listeners.size()-1 ; i >= 0 ; i--)
		{
			((CellEditorListener)listeners.elementAt(i)).editingStopped(ce);
		}
	}

}

