/*Data Access Library. v. 1.1.
 *Table descriptor. Support class for code generation.
 *AUTHOR:  Alexander Jaremenko <jarem@altavista.net>
 *RELEASE DATE: 
 */

package JProjects.eab.data.wizzard;

class TableDescriptor {
    private String[] _tbls;
    private String[] _aliases;
    private String _sql;
    private boolean[] _isOuter;

    String[] getTableNames() {
	return _tbls;
    }

    String getFromClause(String indent) {
	String res = indent+"\" from "+_tbls[0]+(_aliases!=null?" "+_aliases[0]:"");
	for (int i=1;i<_tbls.length;i++) 
	    res+=","+(_isOuter[i]?"outer ":"")+_tbls[i]+(_aliases!=null?" "+_aliases[i]:"");
	return (res+"\"");
    }

    String getWhereClause(String indent) {
	if (_sql==null)
	    return "";
	return indent+"\" where "+_sql+"\"";
    }

    boolean hasAliases() {
	return _aliases != null;
    }

    String getAlias(int idx) {
	if (hasAliases())
	    return _aliases[idx];
	return _tbls[idx];
    }


    String getQualifier(int idx) {
	if (idx > _tbls.length-1)
	    return null;
	String t = _tbls[idx];
	if (t.indexOf('.')>0)
	    return t.substring(0,t.indexOf('.'));
	return "";
    }

    int getNumberTbls() {
	return _tbls.length;
    }

    String[] getTableAliases() {
	if (_aliases == null)
	    return _tbls;
	return _aliases;
    }

    String getLinkSQLSeg() {
	return _sql;
    }

    TableDescriptor(String[] tbls,String[] aliases,String links) {
	_tbls = tbls; 
	if (aliases!=null) {
	    _aliases = new String[aliases.length];
	    _isOuter = new boolean[aliases.length];
	    for (int i=0;i<aliases.length;i++) {
		String s = aliases[i];
		if (s.indexOf('.')>=0) {
		    _isOuter[i]=true;
		    _aliases[i] = s.substring(s.indexOf('.')+1);
		} else {
		    _isOuter[i]=false;
		    _aliases[i] = s;
		}
	    }
	}
	_sql = (links==null||links.trim().length()==0?null:links);
    }


}

