/*Data Access Library. v. 1.1.
 *Property Support. 
 *AUTHOR:  Alexander Jaremenko <jarem@altavista.net>
 *RELEASE DATE: 
 */

package JProjects.eab.data;
import java.beans.*;

/**It is support class for PropertyChangeEvent.
 *@author Alexander Jaremenko  <address><a href="mailto:jarem@altavista.net">&lt jarem@altavista.net &gt</a></address>
*/
public synchronized class DAPropertySupport implements java.io.Serializable {
    private transient PropertyChangeListener _listeners[];
    private Object source;

    public DAPropertySupport(Object src) {
	source = src;
	_listeners = new PropertyChangeListener[10];
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
	int pos=0;
	for (;pos<_listeners.length && _listeners[pos]!=null;pos++) ;
	if (pos==_listeners.length) {
	    PropertyChangeListener ta[] = new PropertyChangeListener[_listeners.length+10];
	    System.arraycopy(_listeners,0,ta,0,_listeners.length);
	    _listeners = ta;
	}
	_listeners[pos] = l;
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
	int pos=0;
	for(;pos < _listeners.length && _listeners[pos]!= l;pos++);
	if (pos<_listeners.length) {
	    for(;pos < _listeners.length-1;pos++)
		_listeners[pos] = _listeners[pos+1];
	    _listeners[_listeners.length-1] = null;
	}
    }

    public void firePropertyChange(String propN, Object oldV, Object newV) {
	PropertyChangeEvent ev = new PropertyChangeEvent(source,propN,oldV,newV);
	for (int i=0;i<_listeners.length && _listeners[i]!=null; i++)
	    _listeners[i].propertyChange(ev);
    }

    private void writeObject(java.io.ObjectOutputStream os) throws java.io.IOException {
	os.writeObject(source);
    }

    private void readObject(java.io.ObjectInputStream is) throws java.io.IOException,ClassNotFoundException {
	try {
	    source = is.readObject();
	} catch (java.io.OptionalDataException ex) {}
	_listeners = new PropertyChangeListener[10];
    }
}
