/*
 * Decompiled with CFR 0.152.
 */
package jms.graphics;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;

public class ImageCanvas
extends Panel {
    private Image img;

    public ImageCanvas() {
    }

    public ImageCanvas(Image i) {
        this.initImage(i);
    }

    public synchronized void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.img != null) {
            g.drawImage(this.img, 0, 0, this);
        }
    }

    public boolean initImage(Image i) {
        if (i == null) {
            return false;
        }
        try {
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(i, 0);
            tracker.waitForID(0);
            tracker = null;
            this.img = i;
            return true;
        }
        catch (InterruptedException interruptedException) {
            this.img = null;
            return false;
        }
    }

    public boolean setImage(Image i) {
        if (!this.initImage(i)) {
            return false;
        }
        this.setSize(this.img.getWidth(this), this.img.getHeight(this));
        if (this.isShowing()) {
            this.repaint();
        }
        return true;
    }

    public Dimension getPreferredSize() {
        if (this.img != null) {
            return new Dimension(this.img.getWidth(this), this.img.getHeight(this));
        }
        return new Dimension(0, 0);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

