/*
 * Decompiled with CFR 0.152.
 */
package jms.de;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import jms.de.AddressPanel;
import jms.de.FileFilterPanel;
import jms.de.FileFormatPanel;
import jms.de.FilesLoader;
import jms.de.FilesLoaderObserver;
import jms.de.FilesPanel;
import jms.de.GetFile;
import jms.de.GetFileObserver;
import jms.de.KeyDialog;
import jms.de.OptionsDialog;
import jms.de.OptionsPanel;
import jms.de.RequestParameters;
import jms.graphics.AdminDialog;
import jms.graphics.GenericThumbnail;
import jms.graphics.IconBar;
import jms.graphics.IconCanvas;
import jms.graphics.ImageThumbnail;
import jms.graphics.MessageBox;
import jms.graphics.Separator;

public class DownloadExpertPanel
extends Panel
implements GetFileObserver,
Runnable,
FilenameFilter,
ActionListener,
FilesLoaderObserver {
    private static String PROGRAM_NAME = "DownloadExpert";
    private static String VERSION = "1.0";
    private static String FILE_EXT = ".dex";
    public static String IMAGES_PATH = "img/";
    private static long DEMO_VERSION_DURATION = 2592000000L;
    private static int MAX_THREAD_NUMBER = 5;
    private static final String CONFIG_FILE = new String("de.cfg");
    private static final String COPY_ID_FILE = new String("CopyId.txt");
    private static final String PROPERTIES_FILE = new String("default" + FILE_EXT);
    private static final int SUB_BOX_OFFSET = 50;
    private MenuBar menuBar;
    private MenuItem newItem;
    private MenuItem openItem;
    private MenuItem saveItem;
    private MenuItem saveAsItem;
    private MenuItem quitItem;
    private MenuItem startSessionItem;
    private MenuItem stopSessionItem;
    private MenuItem optionsSessionItem;
    private MenuItem helpContentItem;
    private MenuItem activationKeyItem;
    private MenuItem helpAboutItem;
    private MenuItem webSiteItem;
    private MenuItemListener menuItemListener;
    private long imageThumbnailMemoryUsed = -1L;
    private AddressPanel addressPanel;
    private FileFormatPanel fileFormatPanel;
    private FileFilterPanel fileFilterPanel;
    private FilesPanel filesPanel;
    private IconBar iconBar;
    private IconCanvas iconNew;
    private IconCanvas iconOpen;
    private IconCanvas iconSave;
    private IconCanvas iconStart;
    private IconCanvas iconStop;
    private OptionsPanel optionsPanel;
    private Hashtable currentOptionsValues;
    private OptionsDialog optionsDialog;
    private Vector listOfFiles;
    private Vector listOfThreads;
    private Thread thread;
    private String htmlString;
    private String fileName = PROPERTIES_FILE;
    private String configFileName = CONFIG_FILE;
    private String outputPath = "";
    private boolean shouldStop = false;
    private Properties configuration;
    private long sessionFilesSize;
    private long maxStoringSize = -1L;
    private Date startDate;
    private Vector listOfUrls;
    private int numberOfLoadedFiles;
    private int totalNumberOfFiles;
    private Frame frame;
    private String installationDir;
    private String currentDir;
    private long storedFileSize = -1L;
    private RequestParameters requestParameters;
    private boolean isInitializing = false;
    private Image offScreenImage;
    private Dimension offScreenSize;
    private Graphics offScreenGraphics;

    public DownloadExpertPanel(Frame f) {
        this.frame = f;
        this.shouldStop = false;
        this.menuItemListener = new MenuItemListener(this.frame);
        this.menuBar = new MenuBar();
        Menu menu = new Menu("File");
        this.newItem = new MenuItem("New...");
        menu.add(this.newItem);
        this.openItem = new MenuItem("Open...");
        menu.add(this.openItem);
        this.saveItem = new MenuItem("Save");
        menu.add(this.saveItem);
        this.saveAsItem = new MenuItem("Save As...");
        menu.add(this.saveAsItem);
        menu.addSeparator();
        this.quitItem = new MenuItem("Quit");
        menu.add(this.quitItem);
        this.menuBar.add(menu);
        menu = new Menu("Session");
        this.startSessionItem = new MenuItem("Start");
        menu.add(this.startSessionItem);
        this.stopSessionItem = new MenuItem("Stop");
        menu.add(this.stopSessionItem);
        menu.addSeparator();
        this.optionsSessionItem = new MenuItem("Options");
        menu.add(this.optionsSessionItem);
        this.menuBar.add(menu);
        menu = new Menu("Help");
        this.helpContentItem = new MenuItem("Contents");
        menu.add(this.helpContentItem);
        menu.addSeparator();
        this.activationKeyItem = new MenuItem("Activation Key");
        menu.add(this.activationKeyItem);
        this.helpAboutItem = new MenuItem("About " + PROGRAM_NAME + "...");
        menu.add(this.helpAboutItem);
        menu.addSeparator();
        this.webSiteItem = new MenuItem(String.valueOf(PROGRAM_NAME) + " Web site");
        menu.add(this.webSiteItem);
        this.menuBar.add(menu);
        this.frame.setMenuBar(this.menuBar);
        this.newItem.addActionListener(this.menuItemListener);
        this.openItem.addActionListener(this.menuItemListener);
        this.saveItem.addActionListener(this.menuItemListener);
        this.saveAsItem.addActionListener(this.menuItemListener);
        this.quitItem.addActionListener(this.menuItemListener);
        this.startSessionItem.addActionListener(this.menuItemListener);
        this.stopSessionItem.addActionListener(this.menuItemListener);
        this.optionsSessionItem.addActionListener(this.menuItemListener);
        this.helpContentItem.addActionListener(this.menuItemListener);
        this.activationKeyItem.addActionListener(this.menuItemListener);
        this.helpAboutItem.addActionListener(this.menuItemListener);
        this.webSiteItem.addActionListener(this.menuItemListener);
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        this.addressPanel = new AddressPanel("Address ");
        this.fileFormatPanel = new FileFormatPanel("File Type ");
        this.optionsPanel = new OptionsPanel();
        this.fileFilterPanel = new FileFilterPanel("File Name ");
        this.setBackground(Color.lightGray);
        this.initIconBar();
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(1, 1, 1, 1);
        gbl.setConstraints(this.iconBar, gbc);
        this.add(this.iconBar);
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbl.setConstraints(this.addressPanel, gbc);
        this.add(this.addressPanel);
        gbc.gridwidth = 1;
        gbl.setConstraints(this.fileFormatPanel, gbc);
        this.add(this.fileFormatPanel);
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.gridheight = 3;
        gbc.anchor = 13;
        gbl.setConstraints(this.fileFilterPanel, gbc);
        this.add(this.fileFilterPanel);
        this.filesPanel = new FilesPanel("Files");
        gbc.fill = 1;
        gbc.weighty = 0.2;
        gbc.weightx = 0.2;
        gbc.insets = new Insets(0, 0, 10, 0);
        gbl.setConstraints(this.filesPanel, gbc);
        this.add(this.filesPanel);
        this.initConfiguration();
        this.initUI(this.getLastFileName());
    }

    public Image loadImage(String image_name) {
        return Toolkit.getDefaultToolkit().getImage(image_name);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.offScreenImage == null || d.width != this.offScreenSize.width || d.height != this.offScreenSize.height) {
            this.offScreenImage = this.createImage(d.width, d.height);
            this.offScreenSize = d;
            this.offScreenGraphics = this.offScreenImage.getGraphics();
        }
        this.paint(this.offScreenGraphics);
        g.drawImage(this.offScreenImage, 0, 0, null);
    }

    public void initIconBar() {
        try {
            this.iconBar = new IconBar(this.frame);
            Image icon = this.loadImage(String.valueOf(IMAGES_PATH) + "new.gif");
            this.iconNew = new IconCanvas(icon);
            this.iconBar.addComponent(this.iconNew);
            this.iconNew.addActionListener(this);
            this.iconBar.addComponent(new Separator(1));
            icon = this.loadImage(String.valueOf(IMAGES_PATH) + "open.gif");
            this.iconOpen = new IconCanvas(icon);
            this.iconBar.addComponent(this.iconOpen);
            this.iconOpen.addActionListener(this);
            icon = this.loadImage(String.valueOf(IMAGES_PATH) + "save.gif");
            this.iconSave = new IconCanvas(icon);
            this.iconBar.addComponent(this.iconSave);
            this.iconSave.addActionListener(this);
            this.iconBar.addComponent(new Separator(1));
            icon = this.loadImage(String.valueOf(IMAGES_PATH) + "start.gif");
            this.iconStart = new IconCanvas(icon);
            this.iconBar.addComponent(this.iconStart);
            this.iconStart.addActionListener(this);
            icon = this.loadImage(String.valueOf(IMAGES_PATH) + "stop.gif");
            this.iconStop = new IconCanvas(icon);
            this.iconStop.setInactive(true);
            this.iconStop.addActionListener(this);
            this.iconBar.addComponent(this.iconStop);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFrameTitle() {
        String t = "";
        String f = this.getFileName();
        if (f != null) {
            t = String.valueOf(f) + " - ";
        }
        t = String.valueOf(t) + PROGRAM_NAME;
        this.frame.setTitle(t);
    }

    public String getFileName() {
        if (this.fileName == null) {
            return null;
        }
        int pos = -1;
        String str = new String(this.fileName);
        while ((pos = str.indexOf(File.separator)) != -1) {
            str = str.substring(pos + 1);
        }
        return str;
    }

    public void initUI(String old_fn) {
        String url = "";
        String prefix = "";
        String suffix = "";
        String digits_number = "1";
        String ext = FileFormatPanel.JPG;
        String start = "0";
        String stop = "10";
        String files = "";
        String filter = "";
        String threads_number = Integer.toString(MAX_THREAD_NUMBER);
        String link_state = "on";
        String load_embed_images = "on";
        File f = new File("");
        this.outputPath = String.valueOf(GetFile.getAbsolutePath(f.getAbsolutePath())) + "saving";
        String storing_size = "10";
        String viewer = "on";
        String reload = "on";
        this.currentDir = this.installationDir;
        File cgf = null;
        if (old_fn != null) {
            cgf = new File(old_fn);
        }
        if (old_fn != null && cgf.exists()) {
            MessageBox mg;
            Properties properties = new Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(old_fn);
                try {
                    properties.load(fis);
                    if (((Hashtable)properties).get("reloadLastSession") != null) {
                        reload = (String)((Hashtable)properties).get("reloadLastSession");
                    }
                    if (reload.equals("on")) {
                        if (((Hashtable)properties).get("address") != null) {
                            url = (String)((Hashtable)properties).get("address");
                        }
                        if (((Hashtable)properties).get("prefixName") != null) {
                            prefix = (String)((Hashtable)properties).get("prefixName");
                        }
                        if (((Hashtable)properties).get("suffixName") != null) {
                            suffix = (String)((Hashtable)properties).get("suffixName");
                        }
                        if (((Hashtable)properties).get("digitNumber") != null) {
                            digits_number = (String)((Hashtable)properties).get("digitNumber");
                        }
                        if (((Hashtable)properties).get("fileExtension") != null) {
                            ext = (String)((Hashtable)properties).get("fileExtension");
                        }
                        if (((Hashtable)properties).get("startIndex") != null) {
                            start = (String)((Hashtable)properties).get("startIndex");
                        }
                        if (((Hashtable)properties).get("stopIndex") != null) {
                            stop = (String)((Hashtable)properties).get("stopIndex");
                        }
                        if (((Hashtable)properties).get("loadEmbedImages") != null) {
                            load_embed_images = (String)((Hashtable)properties).get("loadEmbedImages");
                        }
                        if (((Hashtable)properties).get("fromLinksState") != null) {
                            link_state = (String)((Hashtable)properties).get("fromLinksState");
                        }
                        if (((Hashtable)properties).get("fileFilter") != null) {
                            filter = (String)((Hashtable)properties).get("fileFilter");
                        }
                        if (((Hashtable)properties).get("files") != null) {
                            files = (String)((Hashtable)properties).get("files");
                        }
                        if (((Hashtable)properties).get("threadsNumber") != null) {
                            threads_number = (String)((Hashtable)properties).get("threadsNumber");
                        }
                        if (((Hashtable)properties).get("outputDirectory") != null) {
                            this.outputPath = (String)((Hashtable)properties).get("outputDirectory");
                        }
                        if (((Hashtable)properties).get("maxStoringSize") != null) {
                            storing_size = (String)((Hashtable)properties).get("maxStoringSize");
                            this.maxStoringSize = 0x100000 * Integer.parseInt(storing_size);
                        }
                        if (((Hashtable)properties).get("viewerActive") != null) {
                            viewer = (String)((Hashtable)properties).get("viewerActive");
                        }
                        this.fileName = old_fn;
                        File f2 = new File(this.fileName);
                        String fn = this.getFileName();
                        this.currentDir = GetFile.getAbsolutePath(f2.getAbsolutePath());
                    } else {
                        this.fileName = String.valueOf(this.currentDir) + PROPERTIES_FILE;
                    }
                }
                catch (IOException iOException) {
                    mg = new MessageBox(this.frame, PROGRAM_NAME, "Not a valid session file! (" + old_fn + ")");
                    this.fileName = String.valueOf(this.currentDir) + PROPERTIES_FILE;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                mg = new MessageBox(this.frame, PROGRAM_NAME, "Session file not found! (" + old_fn + ")");
                this.fileName = String.valueOf(this.currentDir) + PROPERTIES_FILE;
            }
        } else {
            this.fileName = String.valueOf(this.currentDir) + PROPERTIES_FILE;
        }
        if (files != null) {
            StringTokenizer st = new StringTokenizer(files, "|");
            File fi = null;
            this.listOfFiles = new Vector();
            while (st.hasMoreTokens()) {
                fi = new File(st.nextToken());
                if (!fi.exists()) continue;
                this.listOfFiles.addElement(fi.toString());
            }
            this.listOfFiles.trimToSize();
        }
        this.addressPanel.setText(url);
        this.fileFormatPanel.setSelection(ext);
        this.optionsPanel.setValues(threads_number, this.outputPath, prefix, suffix, digits_number, start, stop, link_state, load_embed_images, viewer, reload, storing_size);
        this.fileFilterPanel.setFilter(filter);
        FileFormatPanel.ImagePath = String.valueOf(this.installationDir) + IMAGES_PATH;
        this.setFrameTitle();
    }

    public boolean accept(File dir, String name) {
        return name.endsWith(FILE_EXT);
    }

    public void update(GenericThumbnail gt) {
        if (gt == null) {
            this.writeStatus("Done.");
            this.filesPanel.reInitProgressBar(0);
            this.iconStart.setInactive(false);
            this.iconStop.setInactive(true);
            this.isInitializing = false;
            System.gc();
            return;
        }
        ++this.numberOfLoadedFiles;
        this.filesPanel.add(gt);
        this.writeStatus("File Loaded : " + gt.getFullFileName());
        this.filesPanel.reInitProgressBar(100 * this.numberOfLoadedFiles / this.totalNumberOfFiles);
        this.filesPanel.writeRate(this.numberOfLoadedFiles + "/" + this.totalNumberOfFiles);
        this.repaint();
    }

    public String getIconPath() {
        return String.valueOf(this.installationDir) + IMAGES_PATH;
    }

    public void reInit(String file_name) {
        this.save();
        this.stopSession("");
        this.filesPanel.removeAllFiles();
        this.numberOfLoadedFiles = 0;
        this.sessionFilesSize = 0L;
        this.totalNumberOfFiles = 0;
        this.requestParameters = null;
        this.listOfFiles = new Vector();
        this.thread = null;
        this.fileName = String.valueOf(this.currentDir) + PROPERTIES_FILE;
        this.outputPath = "";
        this.shouldStop = false;
        this.initUI(file_name);
        System.gc();
        this.reInitStatusBar();
        this.repaint();
    }

    public void reInitStatusBar() {
        this.filesPanel.reInitProgressBar(0);
        this.writeStatus("");
        this.filesPanel.writeLoad("");
        this.filesPanel.writeRate("");
    }

    public void initConfiguration() {
        this.configuration = new Properties();
        String filename = CONFIG_FILE;
        boolean initialized = false;
        File f = new File("");
        this.installationDir = GetFile.getAbsolutePath(f.getAbsolutePath());
        FileFormatPanel.ImagePath = String.valueOf(this.installationDir) + IMAGES_PATH;
        try {
            this.configuration.load(new FileInputStream(String.valueOf(this.installationDir) + filename));
            initialized = true;
        }
        catch (IOException i) {
            i.printStackTrace();
            MessageBox mb = new MessageBox("Sorry, bad configuration file!|Cannot Execute DownloadExpert.");
            System.exit(-1);
        }
        Object oid = ((Hashtable)this.configuration).get("oid");
        boolean first_time = true;
        if (oid == null) {
            ((Hashtable)this.configuration).put("oid", String.valueOf(System.currentTimeMillis()));
            first_time = true;
            String copy_id = Long.toString(Long.parseLong((String)((Hashtable)this.configuration).get("oid")), 36);
            Properties prop = new Properties();
            ((Hashtable)prop).put("CopyID", copy_id);
            try {
                prop.save(new FileOutputStream(String.valueOf(this.installationDir) + COPY_ID_FILE), String.valueOf(PROGRAM_NAME) + " CopyID File");
            }
            catch (IOException iOException) {}
        } else {
            first_time = false;
        }
        if (!first_time) {
            if (((Hashtable)this.configuration).get("key") == null) {
                long l1;
                long l2 = System.currentTimeMillis();
                if (l2 - (l1 = Long.parseLong((String)((Hashtable)this.configuration).get("oid"))) > DEMO_VERSION_DURATION) {
                    String key = this.enterKey("");
                    if (!this.keyIsValid(key)) {
                        MessageBox mb = new MessageBox("Sorry, Invalid Activation Key (" + key + ")!|Cannot Execute " + PROGRAM_NAME + ".");
                        System.exit(-1);
                    }
                    ((Hashtable)this.configuration).put("key", key);
                }
            } else if (!this.keyIsValid((String)((Hashtable)this.configuration).get("key"))) {
                MessageBox mb = new MessageBox("Sorry, Invalid configuration file!|Cannot Execute " + PROGRAM_NAME + ".");
                System.exit(-2);
            }
        }
    }

    public String enterKey(String default_value) {
        KeyDialog kd = new KeyDialog(this.frame, String.valueOf(PROGRAM_NAME) + " ", default_value);
        kd.pack();
        ((Component)kd).setLocation(300, 200);
        kd.show();
        return kd.getKey();
    }

    public String getKey() {
        long d = Long.parseLong((String)((Hashtable)this.configuration).get("oid"));
        return Long.toString(d, 36);
    }

    public boolean keyIsValid(String key) {
        long multi = 411L;
        try {
            long activation_key = Long.parseLong(key, 36);
            long start_date = Long.parseLong((String)((Hashtable)this.configuration).get("oid"));
            long diff = activation_key - start_date;
            return diff > 0L && diff % 411L == 0L;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public String getLastFileName() {
        if (this.configuration == null || ((Hashtable)this.configuration).get("lastFileName") == null) {
            return null;
        }
        return (String)((Hashtable)this.configuration).get("lastFileName");
    }

    public void newFile() {
        this.reInit(null);
        this.setFrameTitle();
    }

    public void openFile() {
        FileDialog fd = new FileDialog(this.frame, "Opening...", 0);
        Dimension d = new Dimension(300, 200);
        Point p = this.getSubPanelPosition(d);
        ((Component)fd).setLocation(p.x, p.y);
        fd.show();
        String fn = fd.getFile();
        if (fn != null) {
            fn = String.valueOf(fd.getDirectory()) + fn;
            if (!fn.endsWith(FILE_EXT)) {
                fn = String.valueOf(fn) + FILE_EXT;
            }
            if (!fn.endsWith(FILE_EXT)) {
                MessageBox mb = new MessageBox(this.frame, "Message", "Bad File type! (" + FILE_EXT + ")");
            } else if (!fn.equals(this.fileName)) {
                this.newFile();
                this.reInit(fn);
                this.initFiles();
                this.setFrameTitle();
                this.repaint();
            }
        }
    }

    public void save() {
        this.saveConfigFile();
        this.saveProperties();
    }

    public void saveAs() {
        FileDialog fd = new FileDialog(this.frame, "Save As...", 1);
        Point p = this.getLocationOnScreen();
        ((Component)fd).setLocation(p.x + 50, p.y + 50);
        fd.show();
        String fn = fd.getFile();
        if (fn != null) {
            this.currentDir = fd.getDirectory();
            fn = String.valueOf(this.currentDir) + fn;
            if (!fn.endsWith(FILE_EXT)) {
                fn = String.valueOf(fn) + FILE_EXT;
            }
            this.fileName = fn;
            this.save();
        }
        this.setFrameTitle();
        this.repaint();
    }

    public void saveConfigFile() {
        ((Hashtable)this.configuration).put("lastFileName", this.fileName);
        try {
            this.configuration.save(new FileOutputStream(String.valueOf(this.installationDir) + CONFIG_FILE), String.valueOf(PROGRAM_NAME) + " Configuration File");
        }
        catch (IOException iOException) {
            System.out.println("Sorry but can't save configuration file :" + CONFIG_FILE);
        }
    }

    public Point getSubPanelPosition(Dimension d) {
        Point p = this.getLocationOnScreen();
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screen = tk.getScreenSize();
        int x = p.x + 50;
        int y = p.y + 50;
        if (x + d.width > screen.width) {
            x = screen.width - d.width;
        }
        if (y + d.height > screen.height) {
            y = screen.height - d.height;
        }
        if (x < 0 || y < 0) {
            x = 50;
            y = 50;
        }
        return new Point(x, y);
    }

    public void saveProperties() {
        String filename = this.fileName;
        Hashtable h = this.optionsPanel.getValues();
        Properties properties = new Properties();
        ((Hashtable)properties).put("address", this.addressPanel.getText());
        ((Hashtable)properties).put("fileExtension", this.fileFormatPanel.getSelection());
        ((Hashtable)properties).put("prefixName", h.get("prefixName"));
        ((Hashtable)properties).put("suffixName", h.get("suffixName"));
        ((Hashtable)properties).put("digitNumber", h.get("digitNumber"));
        ((Hashtable)properties).put("startIndex", h.get("startIndex"));
        ((Hashtable)properties).put("stopIndex", h.get("stopIndex"));
        ((Hashtable)properties).put("outputDirectory", h.get("outputDirectory"));
        ((Hashtable)properties).put("maxStoringSize", h.get("maxStoringSize"));
        ((Hashtable)properties).put("viewerActive", h.get("viewerActive"));
        ((Hashtable)properties).put("reloadLastSession", h.get("reloadLastSession"));
        ((Hashtable)properties).put("fromLinksState", h.get("fromLinksState"));
        ((Hashtable)properties).put("loadEmbedImages", h.get("loadEmbedImages"));
        ((Hashtable)properties).put("threadsNumber", h.get("threadsNumber"));
        ((Hashtable)properties).put("fileFilter", this.fileFilterPanel.getFilter());
        String files = "";
        String file_name = null;
        if (this.listOfFiles != null) {
            Enumeration e = this.listOfFiles.elements();
            while (e.hasMoreElements()) {
                file_name = (String)e.nextElement();
                files = String.valueOf(files) + file_name + "|";
            }
        }
        ((Hashtable)properties).put("files", files);
        try {
            properties.save(new FileOutputStream(filename), String.valueOf(PROGRAM_NAME) + " Properties File");
        }
        catch (IOException iOException) {
            System.out.println("Sorry but can't save properties file :" + filename);
        }
    }

    public void initFiles() {
        this.isInitializing = true;
        if (this.listOfFiles.isEmpty() || !this.optionsPanel.viewerIsActive()) {
            this.reInitStatusBar();
            this.isInitializing = false;
            return;
        }
        this.numberOfLoadedFiles = 0;
        this.totalNumberOfFiles = this.listOfFiles.size();
        this.writeStatus("Loading files...");
        this.filesPanel.reInitProgressBar(0);
        this.iconStart.setInactive(true);
        this.iconStop.setInactive(true);
        FilesLoader fl = new FilesLoader(this.listOfFiles, this, this.filesPanel);
        fl.start();
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
        this.thread.setPriority(1);
        this.iconStart.setInactive(true);
        this.iconStop.setInactive(false);
        this.shouldStop = false;
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.stop();
            this.thread = null;
            this.iconStart.setInactive(false);
            this.iconStop.setInactive(true);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        cursor = Cursor.getPredefinedCursor(3);
        this.setCursor(cursor);
        this.writeStatus("Starting session...");
        this.filesPanel.writeRate("");
        this.startDate = new Date();
        gf = null;
        url = null;
        thread_number = this.optionsPanel.getThreadNumber();
        this.maxStoringSize = 0x100000 * this.optionsPanel.getMaxStoringSize();
        list_of_urls = this.getListOfUrls();
        if (list_of_urls == null) {
            this.stopSession("Saving stopped. Bad URL or unreachable URL.");
            return;
        }
        list_of_urls.trimToSize();
        this.listOfUrls = (Vector)list_of_urls.clone();
        if (this.totalNumberOfFiles == 0) {
            this.stopSession("");
            return;
        }
        this.filesPanel.writeRate(this.numberOfLoadedFiles + "/" + this.totalNumberOfFiles);
        this.listOfThreads = new Vector<E>();
        this.updateDirectory();
        count = 0;
        while (!this.listOfUrls.isEmpty()) {
            url = (String)this.listOfUrls.firstElement();
            this.listOfUrls.removeElementAt(0);
            if (this.shouldStop) break;
            if (!this.findFile(String.valueOf(this.outputPath) + GetFile.getFileName(url))) ** GOTO lbl36
            continue;
lbl-1000:
            // 1 sources

            {
                try {
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException v0) {
                    this.setCursor(cursor);
                    this.terminate();
                }
lbl36:
                // 3 sources

                ** while (this.listOfThreads != null && this.listOfThreads.size() >= thread_number && !this.shouldStop)
            }
lbl37:
            // 1 sources

            if (this.shouldStop || this.listOfThreads == null) continue;
            gf = new GetFile(Integer.toString(count), url, this.outputPath, this);
            this.writeStatus("Start saving... " + GetFile.getFileName(url));
            this.addGetFile(gf);
            gf.start();
            ++count;
        }
        this.displayRunningThreads();
        if (this.listOfThreads == null || this.listOfThreads.isEmpty()) {
            this.stopSession("");
        }
    }

    public String updateDirectory() {
        String output_path = this.optionsPanel.getDirectory().trim();
        File f = new File(output_path);
        if (!f.isAbsolute()) {
            File f2 = new File("");
            String abs_path = GetFile.getAbsolutePath(f2.getAbsolutePath());
            if (output_path.indexOf(abs_path) == -1) {
                output_path = output_path.startsWith(File.separator) ? String.valueOf(abs_path) + output_path.substring(1) : String.valueOf(abs_path) + output_path;
            }
            this.optionsPanel.setDirectory(output_path);
        }
        if (!(f = new File(this.optionsPanel.getDirectory())).isDirectory()) {
            output_path = "";
            this.optionsPanel.setDirectory("");
            this.outputPath = "";
            return this.outputPath;
        }
        if (!(output_path = output_path.trim()).endsWith(File.separator)) {
            output_path = String.valueOf(output_path) + File.separator;
            this.optionsPanel.setDirectory(output_path);
        }
        this.outputPath = output_path;
        return this.outputPath;
    }

    public Vector getListOfUrls() {
        String url_str = this.addressPanel.getText().trim().toLowerCase();
        if (!url_str.startsWith("http://") && !url_str.startsWith("ftp://")) {
            this.addressPanel.setText("http://" + url_str);
            this.repaint();
        }
        if (this.requestParameters == null) {
            this.requestParameters = new RequestParameters(this.addressPanel.getText(), this.fileFormatPanel.getSelection(), this.optionsPanel.getThreadNumber(), this.optionsPanel.downloadFilesFromLinks(), this.optionsPanel.downloadEmbedImages(), this.fileFilterPanel.getFilter(), this.optionsPanel.getPrefixName(), this.optionsPanel.getSuffixName(), this.optionsPanel.getStartIndex(), this.optionsPanel.getStopIndex(), this.optionsPanel.getNumberOfDigits(), this.optionsPanel.getMaxStoringSize());
        } else if (this.requestParameters.isSame(this.addressPanel.getText(), this.fileFormatPanel.getSelection(), this.optionsPanel.getThreadNumber(), this.optionsPanel.downloadFilesFromLinks(), this.optionsPanel.downloadEmbedImages(), this.fileFilterPanel.getFilter(), this.optionsPanel.getPrefixName(), this.optionsPanel.getSuffixName(), this.optionsPanel.getStartIndex(), this.optionsPanel.getStopIndex(), this.optionsPanel.getNumberOfDigits(), this.optionsPanel.getMaxStoringSize())) {
            return this.requestParameters.response;
        }
        this.sessionFilesSize = 0L;
        this.numberOfLoadedFiles = 0;
        this.totalNumberOfFiles = 0;
        Vector<String> urls = new Vector<String>();
        String filter = this.fileFilterPanel.getFilter().trim();
        boolean empty_filter = filter.equals("");
        if (this.optionsPanel.downloadFilesFromLinks()) {
            Object url = null;
            DataInputStream dis = null;
            try {
                this.writeStatus("Trying to connect to server...");
                URLConnection url_connection = new URL(this.addressPanel.getText()).openConnection();
                this.writeStatus("Waiting for response...");
                dis = new DataInputStream(new BufferedInputStream(url_connection.getInputStream()));
                String link = null;
                String line = null;
                boolean load_images = this.optionsPanel.downloadEmbedImages();
                String img_url = null;
                String html_tag = null;
                boolean entered = false;
                this.htmlString = "";
                int count = 0;
                while ((line = dis.readLine()) != null) {
                    if (!entered) {
                        this.writeStatus("Getting html links...");
                        this.filesPanel.writeRate(String.valueOf(count));
                        entered = true;
                    }
                    this.htmlString = String.valueOf(this.htmlString) + line;
                }
                while ((html_tag = this.getNextHtmlTag()) != null) {
                    link = this.hasLink(html_tag);
                    if (link != null) {
                        if (urls.contains(link) || !empty_filter && link.indexOf(filter) == -1) continue;
                        this.writeStatus("Getting html links...");
                        this.filesPanel.writeRate(String.valueOf(++count));
                        urls.addElement(link);
                        continue;
                    }
                    if (!load_images || (img_url = this.getEmbedImage(html_tag)) == null || urls.contains(img_url)) continue;
                    this.writeStatus("Getting html links...");
                    this.filesPanel.writeRate(String.valueOf(++count));
                    urls.addElement(img_url);
                }
                this.totalNumberOfFiles = count;
                this.requestParameters.response = urls;
            }
            catch (MalformedURLException malformedURLException) {
                this.writeStatus("Sorry, cannot connect to server.");
                this.numberOfLoadedFiles = 0;
                this.totalNumberOfFiles = 0;
                this.requestParameters.response = null;
            }
            catch (IOException iOException) {
                this.writeStatus("Sorry, the server does not respond.");
                this.numberOfLoadedFiles = 0;
                this.totalNumberOfFiles = 0;
                this.requestParameters.response = null;
            }
        } else {
            int digit_number = this.optionsPanel.getNumberOfDigits();
            String base_url = String.valueOf(this.getURL(this.addressPanel.getText())) + this.optionsPanel.getPrefixName();
            int start = this.optionsPanel.getStartIndex();
            int stop = this.optionsPanel.getStopIndex();
            String url = null;
            if (start < 0 || stop < 0 || stop < start) {
                this.writeStatus("Sorry, bad Parameters. Cannot execute the request.");
                return urls;
            }
            String suffix = String.valueOf(this.optionsPanel.getSuffixName()) + this.fileFormatPanel.getSelection();
            int i = start;
            while (i <= stop) {
                url = String.valueOf(base_url) + this.getIndex(i, digit_number) + suffix;
                if (empty_filter || url.indexOf(filter) != -1) {
                    urls.addElement(url);
                }
                ++i;
            }
            this.totalNumberOfFiles = 1 + stop - start;
            this.requestParameters.response = urls;
        }
        this.writeStatus("Total : " + urls.size() + " files.");
        return this.requestParameters.response;
    }

    private String getNextHtmlTag() {
        int pos = -1;
        pos = this.htmlString.indexOf("<");
        if (pos == -1) {
            return null;
        }
        this.htmlString = this.htmlString.substring(pos);
        pos = this.htmlString.indexOf(">");
        if (pos == -1) {
            return null;
        }
        String html_tag = this.htmlString.substring(0, pos + 1);
        this.htmlString = this.htmlString.substring(pos + 1);
        return html_tag;
    }

    public String hasLink(String html_file_line) {
        String line = new String(html_file_line.toLowerCase());
        line = line.trim();
        int pos = -1;
        pos = line.indexOf("<a");
        if (pos == -1) {
            pos = line.indexOf("< a");
        }
        if (pos == -1) {
            return null;
        }
        pos = line.indexOf("href=");
        if (pos == -1) {
            return null;
        }
        if ((line = line.substring(pos + 5)).startsWith("\"") ? (pos = (line = line.substring(1)).indexOf("\"")) == -1 : (pos = line.indexOf(">")) == -1) {
            return null;
        }
        line = line.substring(0, pos);
        if (!(line = line.trim()).endsWith(this.fileFormatPanel.getSelection())) {
            return null;
        }
        String filter = this.fileFilterPanel.getFilter().trim();
        if (!filter.equals("") && line.indexOf(filter) == -1) {
            return null;
        }
        line = this.getHtmlLink(line);
        return line;
    }

    private String getHtmlLink(String line) {
        if (!line.startsWith("http")) {
            if (line.startsWith("ftp:")) {
                return null;
            }
            line = line.startsWith("/") ? String.valueOf(this.getRootURL(this.addressPanel.getText())) + line : String.valueOf(this.getURL(this.addressPanel.getText())) + line;
        }
        return line;
    }

    public String getEmbedImage(String html_file_line) {
        String line = new String(html_file_line).trim();
        int pos = -1;
        if (line.length() <= 5) {
            return null;
        }
        String html_tag = line.substring(0, 5).trim().toLowerCase();
        pos = html_tag.indexOf("<img");
        if (pos == -1) {
            pos = html_tag.indexOf("< img");
        }
        if (pos == -1) {
            return null;
        }
        html_tag = line.substring(pos).trim().toLowerCase();
        if ((pos = html_tag.indexOf("src=")) == -1) {
            return null;
        }
        if ((line = line.substring(pos + 4)).startsWith("\"") ? (pos = (line = line.substring(1)).indexOf("\"")) == -1 : (pos = line.indexOf(" ")) == -1 && (pos = line.indexOf(">")) == -1) {
            return null;
        }
        line = line.substring(0, pos);
        if (!FileFormatPanel.isImage(line = line.trim())) {
            return null;
        }
        String filter = this.fileFilterPanel.getFilter().trim();
        if (!filter.equals("") && line.indexOf(filter) == -1) {
            return null;
        }
        if (line.length() <= 5) {
            return null;
        }
        line = this.getHtmlLink(line);
        return line;
    }

    public void terminate() {
        this.save();
        this.stopSession("Exiting...");
        this.frame.dispose();
        System.exit(0);
    }

    public boolean findFile(String url) {
        String file_name = null;
        String file = GetFile.getFileName(url);
        Enumeration e = this.listOfFiles.elements();
        while (e.hasMoreElements()) {
            file_name = (String)e.nextElement();
            if (!file_name.equals(file)) continue;
            return true;
        }
        return false;
    }

    public synchronized void getFileDone(GetFile gf) {
        System.gc();
        this.displayRunningThreads();
        if (gf == null) {
            return;
        }
        if (this.listOfThreads == null && (this.listOfUrls == null || this.listOfUrls.size() == 0)) {
            gf.shouldStop = true;
            return;
        }
        if (this.listOfThreads != null && !this.listOfThreads.contains(gf)) {
            gf.shouldStop = true;
            return;
        }
        if (this.shouldStop) {
            try {
                if (this.listOfThreads != null) {
                    this.listOfThreads.removeElement(gf);
                }
                this.displayRunningThreads();
                try {
                    gf.shouldStop = true;
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.reInitStatusBar();
            return;
        }
        Date dt = new Date();
        boolean rate = false;
        if (gf.fileSaved()) {
            this.filesPanel.setProgressBarValue(gf.getLoad());
            this.writeStatus("File : " + gf.getFileName() + " loaded at " + gf.getLoad() + "% (" + gf.getSizeLabel() + ")");
            ++this.numberOfLoadedFiles;
            this.sessionFilesSize += (long)gf.getReadBytes();
            this.filesPanel.writeRate(this.numberOfLoadedFiles + "/" + this.totalNumberOfFiles);
            this.filesPanel.writeLoad(this.sessionFilesSize / 1024L + " Kb");
            Object tracker = null;
            Image img = null;
            long mem1 = -1L;
            Runtime rt = Runtime.getRuntime();
            String vendor = System.getProperty("java.vendor");
            if (vendor != null) {
                vendor = vendor.toLowerCase();
            }
            if (this.imageThumbnailMemoryUsed != -1L && rt.freeMemory() < this.imageThumbnailMemoryUsed && vendor != null && vendor.indexOf("microsoft") == -1) {
                MessageBox mb = new MessageBox("Out of Memory|The session is stopped");
                this.stopSession("Session stopped, out of memory!");
                return;
            }
            if (this.optionsPanel.viewerIsActive()) {
                if (FileFormatPanel.isImage(gf.getFileName())) {
                    this.writeStatus("Loading image " + gf.getFullFileName() + "...");
                    img = this.loadImage(gf.getFullFileName());
                    if (img != null) {
                        if (this.imageThumbnailMemoryUsed == -1L) {
                            mem1 = rt.freeMemory();
                        }
                        this.filesPanel.add(new ImageThumbnail(this.filesPanel, img, gf.getFileName(), this.outputPath, gf.getSize()));
                        if (this.imageThumbnailMemoryUsed == -1L) {
                            this.imageThumbnailMemoryUsed = mem1 - rt.freeMemory();
                        }
                        this.writeStatus("Image " + gf.getFullFileName() + " loaded");
                        this.filesPanel.reInitProgressBar(0);
                    }
                } else {
                    String icon_file_name = String.valueOf(this.installationDir) + IMAGES_PATH + this.fileFormatPanel.getIconName();
                    img = this.loadImage(icon_file_name);
                    this.filesPanel.add(new GenericThumbnail(this.filesPanel, img, gf.getFileName(), this.outputPath, gf.getSize()));
                }
            }
            this.listOfFiles.addElement(String.valueOf(this.outputPath) + gf.getFileName());
            this.repaint();
        } else if (gf.getSize() == 0L) {
            this.filesPanel.writeRate(this.numberOfLoadedFiles + "/" + this.totalNumberOfFiles);
        }
        try {
            gf.shouldStop = true;
        }
        catch (Exception exception) {}
        if (this.listOfThreads != null) {
            this.listOfThreads.removeElement(gf);
        }
        this.displayRunningThreads();
        if ((this.listOfThreads == null || this.listOfThreads != null && this.listOfThreads.size() == 0) && this.listOfUrls != null && this.listOfUrls.size() == 0) {
            this.writeStatus("Saving done.");
            this.filesPanel.reInitProgressBar(0);
            this.iconStop.setInactive(true);
            this.iconStart.setInactive(false);
            Cursor cursor = Cursor.getPredefinedCursor(0);
            this.setCursor(cursor);
            this.listOfThreads = null;
        }
    }

    public synchronized void addGetFile(GetFile gf) {
        if (this.listOfThreads != null && gf != null) {
            this.listOfThreads.addElement(gf);
            this.displayRunningThreads();
        }
    }

    public synchronized boolean getFileUpdate(GetFile gf) {
        if (!this.shouldStop && !gf.shouldStop) {
            if (this.sessionFilesSize + gf.getSize() > this.maxStoringSize) {
                this.stopSession("The Maximum amount of saved file size is reached!");
                MessageBox mb = new MessageBox("The allowed amount of saved files (" + this.optionsPanel.getMaxStoringSize() + "Mb) is reached!|The session is stopped.");
                return false;
            }
            this.filesPanel.setProgressBarValue(gf.getLoad());
            this.writeStatus("File " + gf.getFileName() + " loaded at " + gf.getLoad() + "%");
            this.sessionFilesSize += (long)gf.getReadBytes();
            this.filesPanel.writeLoad(this.sessionFilesSize / 1024L + " Kb");
        }
        return true;
    }

    public void startSession() {
        this.start();
    }

    public void stopSession(String message) {
        Cursor cursor = Cursor.getPredefinedCursor(0);
        this.setCursor(cursor);
        this.stopAllThreads();
        this.writeStatus(message);
        this.filesPanel.reInitProgressBar(0);
        this.iconStop.setInactive(true);
        this.iconStart.setInactive(false);
        this.stop();
    }

    public synchronized void stopAllThreads() {
        this.displayRunningThreads();
        this.shouldStop = true;
        if (this.listOfThreads == null) {
            return;
        }
        GetFile gf = null;
        Enumeration e = this.listOfThreads.elements();
        while (e.hasMoreElements()) {
            gf = (GetFile)e.nextElement();
            gf.shouldStop = true;
        }
        this.displayRunningThreads();
        this.listOfThreads = null;
    }

    public synchronized void displayRunningThreads() {
        if (this.listOfThreads == null || this.listOfThreads.size() == 0) {
            return;
        }
        GetFile gf = null;
        Enumeration e = this.listOfThreads.elements();
        while (e.hasMoreElements()) {
            gf = (GetFile)e.nextElement();
        }
    }

    public void writeStatus(String new_status) {
        this.filesPanel.writeStatus(new_status);
        this.repaint();
    }

    public String getIndex(int i, int digit_number) {
        String str = null;
        switch (digit_number) {
            case -1: 
            case 0: {
                return String.valueOf(i);
            }
            case 1: {
                str = String.valueOf(i);
                break;
            }
            case 2: {
                if (i < 10) {
                    str = "0" + i;
                    break;
                }
                str = String.valueOf(i);
                break;
            }
            case 3: {
                if (i < 10) {
                    str = "00" + i;
                    break;
                }
                if (i < 100) {
                    str = "0" + i;
                    break;
                }
                str = String.valueOf(i);
                break;
            }
        }
        return str;
    }

    private String getURL(String url) {
        int pos = -1;
        String str = new String(url).trim();
        String base_url = "";
        boolean has_found = false;
        pos = str.indexOf("http://");
        str = str.substring(pos + 7);
        while ((pos = str.indexOf(47)) != -1) {
            base_url = String.valueOf(base_url) + str.substring(0, pos + 1);
            str = str.substring(pos + 1);
            has_found = true;
        }
        base_url = !has_found ? "http://" + str : (str.indexOf(".") != -1 ? "http://" + base_url : "http://" + base_url + str);
        if (!base_url.endsWith("/")) {
            base_url = String.valueOf(base_url) + "/";
        }
        return base_url;
    }

    private String getRootURL(String url) {
        int pos = -1;
        String str = new String(url).trim();
        String base_url = "";
        pos = str.indexOf("http://");
        if (str.length() < pos + 7) {
            return "http://";
        }
        base_url = (pos = (str = str.substring(pos + 7)).indexOf("/")) == -1 ? "http://" + str : "http://" + str.substring(0, pos);
        return base_url;
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof IconCanvas) {
            IconCanvas icon = (IconCanvas)evt.getSource();
            if (icon == this.iconNew) {
                if (!this.isInitializing) {
                    this.newFile();
                }
            } else if (icon == this.iconOpen) {
                if (!this.isInitializing) {
                    this.openFile();
                }
            } else if (icon == this.iconSave) {
                if (!this.isInitializing) {
                    if (this.fileName != null && this.fileName.equals(String.valueOf(this.currentDir) + PROPERTIES_FILE)) {
                        this.saveAs();
                    } else {
                        this.save();
                    }
                }
            } else if (icon == this.iconStart) {
                if (!this.isInitializing) {
                    this.start();
                }
            } else if (icon == this.iconStop && !this.isInitializing) {
                this.stopSession("Saving stopped.");
            }
        }
    }

    public class MenuItemListener
    implements ActionListener {
        private Frame frame;

        public MenuItemListener(Frame f) {
            DownloadExpertPanel.this = DownloadExpertPanel.this;
            this.frame = f;
        }

        public void actionPerformed(ActionEvent evt) {
            block17: {
                MenuItem item;
                block29: {
                    block27: {
                        String key;
                        block28: {
                            block26: {
                                block25: {
                                    block24: {
                                        block23: {
                                            block22: {
                                                block21: {
                                                    block20: {
                                                        block19: {
                                                            block18: {
                                                                item = (MenuItem)evt.getSource();
                                                                if (item != DownloadExpertPanel.this.quitItem) break block18;
                                                                DownloadExpertPanel.this.terminate();
                                                                break block17;
                                                            }
                                                            if (item != DownloadExpertPanel.this.startSessionItem) break block19;
                                                            DownloadExpertPanel.this.start();
                                                            break block17;
                                                        }
                                                        if (item != DownloadExpertPanel.this.stopSessionItem) break block20;
                                                        DownloadExpertPanel.this.stopSession("Saving stopped.");
                                                        break block17;
                                                    }
                                                    if (item != DownloadExpertPanel.this.optionsSessionItem) break block21;
                                                    Point p = null;
                                                    if (DownloadExpertPanel.this.optionsDialog == null) {
                                                        DownloadExpertPanel.this.optionsDialog = new OptionsDialog(this.frame, "Setup", DownloadExpertPanel.this.optionsPanel);
                                                        DownloadExpertPanel.this.currentOptionsValues = DownloadExpertPanel.this.optionsPanel.getValues();
                                                    }
                                                    p = DownloadExpertPanel.this.getSubPanelPosition(new Dimension(500, 400));
                                                    ((Component)DownloadExpertPanel.this.optionsDialog).setLocation(p.x, p.y);
                                                    DownloadExpertPanel.this.optionsDialog.show();
                                                    if (DownloadExpertPanel.this.optionsDialog.getResult() == 0) {
                                                        if (!DownloadExpertPanel.this.optionsPanel.goodParameters()) {
                                                            DownloadExpertPanel.this.optionsPanel.setValues(DownloadExpertPanel.this.currentOptionsValues);
                                                        } else {
                                                            DownloadExpertPanel.this.currentOptionsValues = DownloadExpertPanel.this.optionsPanel.getValues();
                                                        }
                                                    } else {
                                                        DownloadExpertPanel.this.optionsPanel.setValues(DownloadExpertPanel.this.currentOptionsValues);
                                                    }
                                                    DownloadExpertPanel.this.updateDirectory();
                                                    break block17;
                                                }
                                                if (item != DownloadExpertPanel.this.newItem) break block22;
                                                if (DownloadExpertPanel.this.isInitializing) break block17;
                                                DownloadExpertPanel.this.newFile();
                                                break block17;
                                            }
                                            if (item != DownloadExpertPanel.this.openItem) break block23;
                                            if (DownloadExpertPanel.this.isInitializing) break block17;
                                            DownloadExpertPanel.this.openFile();
                                            break block17;
                                        }
                                        if (item != DownloadExpertPanel.this.saveItem) break block24;
                                        if (DownloadExpertPanel.this.isInitializing) break block17;
                                        if (DownloadExpertPanel.this.fileName != null && DownloadExpertPanel.this.fileName.equals(PROPERTIES_FILE)) {
                                            DownloadExpertPanel.this.saveAs();
                                        } else {
                                            DownloadExpertPanel.this.save();
                                        }
                                        break block17;
                                    }
                                    if (item != DownloadExpertPanel.this.saveAsItem) break block25;
                                    if (DownloadExpertPanel.this.isInitializing) break block17;
                                    DownloadExpertPanel.this.saveAs();
                                    break block17;
                                }
                                if (item != DownloadExpertPanel.this.helpContentItem) break block26;
                                Runtime runtime = Runtime.getRuntime();
                                String os = System.getProperty("os.name");
                                os = os.toLowerCase();
                                try {
                                    if (!(os == null || os.indexOf("windows") == -1 && os.indexOf("microsoft") == -1 || os.indexOf("95") == -1 && os.indexOf("98") == -1)) {
                                        runtime.exec("start doc/index.html");
                                        break block17;
                                    }
                                    runtime.exec("doc/index.html");
                                }
                                catch (IOException iOException) {
                                    MessageBox mg = new MessageBox("Sorry, cannot launch Web browser!");
                                }
                                break block17;
                            }
                            if (item != DownloadExpertPanel.this.activationKeyItem) break block27;
                            String default_value = "";
                            if (((Hashtable)DownloadExpertPanel.this.configuration).get("key") != null) {
                                default_value = (String)((Hashtable)DownloadExpertPanel.this.configuration).get("key");
                            }
                            if ((key = DownloadExpertPanel.this.enterKey(default_value)) != null && (key.length() <= 0 || DownloadExpertPanel.this.keyIsValid(key))) break block28;
                            MessageBox mb = new MessageBox("Sorry, Invalid Activation Key (" + key + ")!");
                            break block17;
                        }
                        if (key.length() <= 0 || !DownloadExpertPanel.this.keyIsValid(key)) break block17;
                        ((Hashtable)DownloadExpertPanel.this.configuration).put("key", key);
                        DownloadExpertPanel.this.saveConfigFile();
                        break block17;
                    }
                    if (item != DownloadExpertPanel.this.helpAboutItem) break block29;
                    String key = "Not registered";
                    if (((Hashtable)DownloadExpertPanel.this.configuration).get("key") != null) {
                        key = (String)((Hashtable)DownloadExpertPanel.this.configuration).get("key");
                    }
                    String user = "";
                    if (((Hashtable)DownloadExpertPanel.this.configuration).get("user") != null) {
                        user = (String)((Hashtable)DownloadExpertPanel.this.configuration).get("user");
                    }
                    String version = VERSION;
                    if (((Hashtable)DownloadExpertPanel.this.configuration).get("version") != null) {
                        version = (String)((Hashtable)DownloadExpertPanel.this.configuration).get("version");
                    }
                    String oid = "";
                    if (((Hashtable)DownloadExpertPanel.this.configuration).get("oid") != null) {
                        oid = (String)((Hashtable)DownloadExpertPanel.this.configuration).get("oid");
                    }
                    String message = String.valueOf(PROGRAM_NAME) + "|Copyright(c) 1996-99 Modestory Software." + "|Version        : " + version + "|Copy  ID       : " + Long.toString(Long.parseLong(oid), 36) + "|Activation key : " + key + "| Web site : http://www.modestory.com/software" + "| E-mail   : software@modestory.com";
                    AdminDialog ad = new AdminDialog(this.frame, "About " + PROGRAM_NAME + "...", message);
                    break block17;
                }
                if (item != DownloadExpertPanel.this.webSiteItem) break block17;
                try {
                    Runtime runtime = Runtime.getRuntime();
                    runtime.exec("start http://www.modestory.com/software");
                }
                catch (IOException iOException) {
                    System.out.println("Sorry, cannot launch Internet browser!");
                }
            }
        }
    }
}

