// C Point JavaScript Library v2.1
// Copyright 1999, 2000 C Point Pty Ltd, 71 Williamson Road, Para Hills 5096
// Web: http://www.c-point.com Email: c-point@c-point.com
// ************ To use the C Point JavaScript Library you must obtain the license from C Point ************* //

// ************  Move object functions ************ 
function initClassMoveable()
{
	bMoving = false;
	document.onmousedown=startMove;
	document.onmousemove=moveObj;
	document.onmouseup=new Function("bMoving=false");
}

function moveObj()
{
	if(!bMoving) return true;
	if(event.button!=1) return true;

// Reposition the object, keeping the same distance from the cursor
	ob.style.pixelLeft=event.clientX-xdif;
	ob.style.pixelTop=event.clientY-ydif;
	return false;
}

function startMove()
{
// Only "moveable" objects can move
	if(event.srcElement.className!="moveable") return;

	bMoving=true;
// Store the object and the differnce between the obj pos and cursor pos: it must remain the same
	ob=event.srcElement;
	xdif=event.clientX-event.srcElement.style.pixelLeft;
	ydif=event.clientY-event.srcElement.style.pixelTop;
}

// ************ Navigation Functions ************ 
function cpGoHome()
{
	document.URL="index.html";
}

function cpGoPrev()
{
	var str = document.URL;	
	str.toLowerCase();
	if(str.search("0002")!=-1) cpGoHome();
	else cpGoPage(-1);
}

function cpGoPage(n)
{
	var str = document.URL;	
	var idx = str.lastIndexOf("."); 
	var nPage = str.slice(idx-4, idx); 
	var nNum = nPage*1 + n; 

	if(nNum<10) idx-=1;
	else if(nNum<100) idx-=2;
	else if(nNum<1000) idx-=3;
	else if(nNum<10000) idx-=4;
	
	var sPath = str.slice(0, idx) + nNum + ".html";
	idx = str.lastIndexOf("\\"); 	
	document.URL = sPath.slice(idx+1, sPath.length);
}

function cpGoNext()
{
	var str = document.URL;	
	str.toLowerCase();
	if(str.search("index.html")!=-1) document.URL = "page0002.html";
	else cpGoPage(1);
}

// ************ Button Functions ************ 

// 2-state button (checkbox): function toggles the 2 states
function cpClickState(obj)
{
	if(obj.cpType=="2")
	{
		obj.cpType="1";
		obj.src=obj.cpDn;			
	}
	else
	{
		obj.cpType="2";	
		obj.src=obj.cpUp;
	}
}

function cpSound(f)
{
	MPlyr.FileName=f;
	MPlyr.Play();
}

function cpMouseOver(obj, f)
{
	obj.src=f;
}

function cpMouseOut(obj, f)
{
	obj.src=f;	
}

// Move/display the object at the specified location
function cpPopup(ob2, x, y)
{
	ob2.style.posLeft=x;
	ob2.style.posTop=y;
	ob2.style.visibility="visible";	
}

// Roll the first object, display the second at the specified location
function cpMousePopOver(ob1, f, ob2, x, y)
{
	cpMouseOver(ob1, f);
	cpPopup(ob2, x, y);	
}

// Roll the first object, display the second
function cpRollPopOver(ob1, f, ob2)
{
	cpMouseOver(ob1, f);
	ob2.style.visibility="visible";
}

// Restore the first object, hide the second
function cpMousePopOut(ob1, f, ob2)
{
	cpMouseOut(ob1, f);
	ob2.style.visibility="hidden";		
}

// Toggle the object's visibility
function cpPop(ob)
{
	if(ob.style.visibility=="visible") ob.style.visibility="hidden";	
	else ob.style.visibility="visible";	
}

// ************  Misc functions ************ 
function cpRandom(min, max)
{
	var nRand = Math.random()*(max-min+1);
	return(Math.round(nRand + 0.5)+min-1);
}

function cpGoRandom(obj, n)
{
	n = cpRandom(1, n);			   	
	var str = obj.src;					   
	var idx = str.lastIndexOf("."); 
	var filler = "0";
	if(n<10) filler = "000";
	else if(n<100) filler = "00";
	else if(n<1000) filler = "0";
	obj.src=str.slice(0, idx-4) + filler + n + str.slice(idx, str.length);
}


