#!/usr/bin/perl
# Quick Website News
# Licensed Under the GNU General Public License (see COPYING File)
#
# You are welcome to modify and improve this program as long as any
# improvements are added to the public code base. I would be more than
# pleased to recieve improvements, comment and suggestions by email at qwn@tildemh.com.
# The latest version of these scripts will always be available from my website
# http://www.tildemh.com
#
#                     Copyright (c) 2001 by Mark Howard
#
#       This program is free software; you can redistribute it and/or
#       modify it under the terms of the GNU General Public License as
#       published by the Free Software Foundation; either version 2 of
#       the License, or (at your option) any later version.
#
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#
#       You should have received a copy of the GNU General Public License
#       along with this program in the file 'COPYING'; if not, write to
#       the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#       Boston, MA 02111-1307, USA, or contact the author:
#
# QWN
#
# view.cgi - shows all the items, and allows them to be edited.


use qwnui;
use config;
use checksess;
use encode;
use htmlgen;
require 'cgi-lib1.pl';
&ReadParse(*input);
&checksess::validsess;
&checksess::loadedproj;


# Add new parameters
# where to start and how many to show.
# view.cgi?startindex=1&pagecount=10


print "Content-Type: text/html\n\n";
print <<HEADEND;
<html>
<head>
<title>QWN- View / Edit News</title>
<link href="style.css" typ=text/css rel=stylesheet>
</head>
<body>
HEADEND
qwnui::qwnheader;

# print "<p>In: $input";




# This form also used to save edited details.
if ($input eq ""){
        $pagenum=1;
}elsif(($input =~ /agenum/)<=0){
        @detail = split (/&/, $input);
        foreach $detail(@detail){
                %details=split(/=/,$detail);
                while (($name,$value)=each %details){
                        if ($name eq "time"){$time=$value;}
                        if ($name eq "author"){$author=$value;}
                        if ($name eq "title"){$title=$value;}
                        if ($name eq "content"){$content=$value;}
                }
        }
        $editedentry="$time#$author#$title#$content";
        $editedentry =~ s/\+/ /g;
        # print "$editedentry";


        open(NEWS,"config/$session::newsdb");
        @news=<NEWS>;
        close(NEWS);
        $timestamp=$time;
        open(NEWS,">config/$session::newsdb");
        foreach $entry(@news){
                chomp $entry;
                $test= ($entry =~ /$timestamp/);
                if ($test<=0){
                        print NEWS "$entry\n";
                }else{
                        print NEWS "$editedentry\n";
                }
        }
        close(NEWS);
        print "<p class=info>Successfully Edited news item<br>";
        print "Regenerating Static HTML Pages:";
        &htmlgen::makehtml;
        $pagenum=1;
        print "</p>";
}else{
        $input =~s/pagenum=//g;
        $pagenum=$input;
}

print "<h2>View / Edit Details</h2>";

sub formatdate{
# Formats a date based on input string.
# e.g. formatdate("dd/mm/yyyy hh:nn",$date);

gmtime(@_[1]);


}




open(NEWS,"config/$session::newsdb");
@news=<NEWS>;
close(NEWS);
$perpage=10;
$curpage=0;
$curitem=0;

$max=scalar @news;
$max=int($max/ $perpage)+1;
if ($max != 1){ print "<p>Page $pagenum of $max, a total of $#news news items.</p>"; }


sub changepage(){
$new=$pagenum-1;
if ($new>0&&$new<=$max){
        print "<form action=\"view.cgi\" method=post><input type=hidden name=\"pagenum\" value=\"$new\">";
        print "<input type=submit value=\"Previous Page\"></form>";
}
$new=$pagenum+1;
if ($new>0&&$new<=$max){
        print "<form action=\"view.cgi\" method=post><input type=hidden name=\"pagenum\" value=\"$new\">";
        print "<input type=submit value=\"Next Page\"></form>";
}
}

&changepage();

do{
                $entry=pop(@news);
                $entry=&encode::unencode($entry);
                $curitem++;
                $curpage=int($curitem / $perpage)+1;
        if ($curpage==$pagenum){
                chomp $entry;
                @separated=split(/#/, $entry);
                $date=&formatdate("dd/mm/yyyy hh:nn",$separated[0]);
                print "Date: $date <a href=\"edit.cgi?&timestamp=$separated[0]\">[Edit]</a><br>";   #Option to let dates to be written as you want.
                print "Title: $separated[2]<br>";
                print "Author: $separated[1]<br>";
                print "@separated[3]<br><br>";
        }
}while $#news>=0;
&changepage();
print "</body></html>";
&config::savesess;
