/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class DefaultTableModel
extends AbstractTableModel
implements Serializable {
    protected Vector dataVector;
    protected Vector columnIdentifiers;

    public DefaultTableModel() {
        this((Vector)null, 0);
    }

    public DefaultTableModel(int n, int n2) {
        Vector vector = new Vector(n2);
        vector.setSize(n2);
        this.setColumnIdentifiers(vector);
        this.dataVector = new Vector();
        this.setNumRows(n);
    }

    public DefaultTableModel(Vector vector, int n) {
        this.setColumnIdentifiers(vector);
        this.dataVector = new Vector();
        this.setNumRows(n);
    }

    public DefaultTableModel(Vector vector, Vector vector2) {
        this.setDataVector(vector, vector2);
    }

    public DefaultTableModel(Object[] objectArray, int n) {
        this(DefaultTableModel.convertToVector(objectArray), n);
    }

    public DefaultTableModel(Object[][] objectArray, Object[] objectArray2) {
        this.setDataVector(objectArray, objectArray2);
    }

    public void addColumn(Object object) {
        this.addColumn(object, (Vector)null);
    }

    public void addColumn(Object object, Vector vector) {
        if (object == null) {
            throw new IllegalArgumentException("addColumn() - null parameter");
        }
        this.columnIdentifiers.addElement(object);
        int n = 0;
        Enumeration enumeration = this.dataVector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = vector != null && n < vector.size() ? (Object)vector.elementAt(n) : null;
            ((Vector)enumeration.nextElement()).addElement(e);
            ++n;
        }
        this.fireTableStructureChanged();
    }

    public void addColumn(Object object, Object[] objectArray) {
        this.addColumn(object, DefaultTableModel.convertToVector(objectArray));
    }

    public void addRow(Vector vector) {
        if (vector == null) {
            vector = new Vector(this.getColumnCount());
        } else {
            vector.setSize(this.getColumnCount());
        }
        this.dataVector.addElement(vector);
        this.newRowsAdded(new TableModelEvent(this, this.getRowCount() - 1, this.getRowCount() - 1, -1, 1));
    }

    public void addRow(Object[] objectArray) {
        this.addRow(DefaultTableModel.convertToVector(objectArray));
    }

    protected static Vector convertToVector(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            vector.addElement(objectArray[n]);
            ++n;
        }
        return vector;
    }

    protected static Vector convertToVector(Object[][] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Vector<Vector> vector = new Vector<Vector>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            vector.addElement(DefaultTableModel.convertToVector(objectArray[n]));
            ++n;
        }
        return vector;
    }

    public int getColumnCount() {
        return this.columnIdentifiers.size();
    }

    public String getColumnName(int n) {
        if (this.columnIdentifiers == null || this.columnIdentifiers.size() <= n) {
            return super.getColumnName(n);
        }
        Object e = this.columnIdentifiers.elementAt(n);
        if (e == null) {
            return super.getColumnName(n);
        }
        return e.toString();
    }

    public Vector getDataVector() {
        return this.dataVector;
    }

    public int getRowCount() {
        return this.dataVector.size();
    }

    public Object getValueAt(int n, int n2) {
        Vector vector = (Vector)this.dataVector.elementAt(n);
        return vector.elementAt(n2);
    }

    public void insertRow(int n, Vector vector) {
        if (vector == null) {
            vector = new Vector(this.getColumnCount());
        } else {
            vector.setSize(this.getColumnCount());
        }
        this.dataVector.insertElementAt(vector, n);
        this.newRowsAdded(new TableModelEvent(this, n, n, -1, 1));
    }

    public void insertRow(int n, Object[] objectArray) {
        this.insertRow(n, DefaultTableModel.convertToVector(objectArray));
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public void moveRow(int n, int n2, int n3) {
        if (n < 0 || n >= this.getRowCount()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n2 < 0 || n2 >= this.getRowCount()) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n <= n3 && n3 <= n2) {
            return;
        }
        boolean bl = n3 < n;
        int n4 = n;
        while (n4 <= n2) {
            Object e = this.dataVector.elementAt(n4);
            this.dataVector.removeElementAt(n4);
            this.dataVector.insertElementAt(e, n3);
            if (bl) {
                ++n3;
            }
            ++n4;
        }
        this.fireTableDataChanged();
    }

    public void newDataAvailable(TableModelEvent tableModelEvent) {
        this.fireTableChanged(tableModelEvent);
    }

    public void newRowsAdded(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getLastRow();
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = this.getRowCount() - 1;
        }
        int n3 = n;
        while (n3 < n2) {
            ((Vector)this.dataVector.elementAt(n3)).setSize(this.getColumnCount());
            ++n3;
        }
        this.fireTableChanged(tableModelEvent);
    }

    public void removeRow(int n) {
        this.dataVector.removeElementAt(n);
        this.fireTableRowsDeleted(n, n);
    }

    public void rowsRemoved(TableModelEvent tableModelEvent) {
        this.fireTableChanged(tableModelEvent);
    }

    public void setColumnIdentifiers(Vector vector) {
        this.columnIdentifiers = vector != null ? vector : new Vector();
        this.fireTableStructureChanged();
    }

    public void setColumnIdentifiers(Object[] objectArray) {
        this.setColumnIdentifiers(DefaultTableModel.convertToVector(objectArray));
    }

    public void setDataVector(Vector vector, Vector vector2) {
        if (vector == null) {
            throw new IllegalArgumentException("setDataVector() - Null parameter");
        }
        this.dataVector = new Vector(0);
        this.setColumnIdentifiers(vector2);
        this.dataVector = vector;
        this.newRowsAdded(new TableModelEvent(this, 0, this.getRowCount() - 1, -1, 1));
    }

    public void setDataVector(Object[][] objectArray, Object[] objectArray2) {
        this.setDataVector(DefaultTableModel.convertToVector(objectArray), DefaultTableModel.convertToVector(objectArray2));
    }

    public void setNumRows(int n) {
        if (n < 0 || n == this.getRowCount()) {
            return;
        }
        int n2 = this.getRowCount();
        if (n <= this.getRowCount()) {
            this.dataVector.setSize(n);
            this.fireTableRowsDeleted(this.getRowCount(), n2 - 1);
        } else {
            int n3 = this.getColumnCount();
            while (this.getRowCount() < n) {
                Vector vector = new Vector(n3);
                vector.setSize(n3);
                this.dataVector.addElement(vector);
            }
            this.fireTableRowsInserted(n2, this.getRowCount() - 1);
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        Vector vector = (Vector)this.dataVector.elementAt(n);
        vector.setElementAt(object, n2);
        this.fireTableChanged(new TableModelEvent(this, n, n, n2));
    }
}

