/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import com.l2fprod.gui.plaf.skin.SkinSplitArrowButton;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class SkinSplitPaneDivider
extends BasicSplitPaneDivider
implements SwingConstants {
    static final Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    static final Insets NO_INSETS = new Insets(0, 0, 0, 0);
    protected Skin skin = SkinLookAndFeel.getSkin();

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
    }

    public void setDividerSize(int newSize) {
        this.dividerSize = newSize;
        this.splitPane.setDividerSize(newSize);
    }

    public Dimension getPreferredSize() {
        return this.getLayout().preferredLayoutSize(this.splitPane);
    }

    public Dimension getMinimumSize() {
        return this.getLayout().preferredLayoutSize(this.splitPane);
    }

    public void paint(Graphics g) {
        Rectangle bounds;
        Dimension size = this.getSize();
        this.skin.getSplitPane().paintGutter(g, this.splitPane, this.getSize());
        if (this.leftButton != null) {
            bounds = this.leftButton.getBounds();
            Graphics glb = g.create(bounds.x, bounds.y, bounds.width, bounds.height);
            this.leftButton.paint(glb);
        }
        if (this.rightButton != null) {
            bounds = this.rightButton.getBounds();
            Graphics grb = g.create(bounds.x, bounds.y, bounds.width, bounds.height);
            this.rightButton.paint(grb);
        }
        this.skin.getSplitPane().paintThumb(g, this.splitPane, this.getSize());
    }

    protected JButton createLeftOneTouchButton() {
        int button_direction = 5;
        if (this.orientation == 1) {
            button_direction = 7;
        }
        SkinSplitArrowButton b = new SkinSplitArrowButton(button_direction);
        b.setCursor(defaultCursor);
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        this.updateDividerSize(((JComponent)b).getPreferredSize());
        return b;
    }

    protected JButton createRightOneTouchButton() {
        int button_direction = 1;
        if (this.orientation == 1) {
            button_direction = 3;
        }
        SkinSplitArrowButton b = new SkinSplitArrowButton(button_direction);
        b.setCursor(defaultCursor);
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        this.updateDividerSize(((JComponent)b).getPreferredSize());
        return b;
    }

    protected void updateDividerSize(Dimension d) {
        int buttonSize = 0;
        buttonSize = this.orientation == 1 ? d.width : d.height;
        int sbSize = this.splitPane.getDividerSize();
        if (sbSize < buttonSize) {
            this.splitPane.setDividerSize(buttonSize);
        }
    }

    public SkinSplitPaneDivider(BasicSplitPaneUI ui) {
        super(ui);
        this.setLayout(new DividerLayout(this));
        this.setBasicSplitPaneUI(ui);
        this.orientation = this.splitPane.getOrientation();
        this.setBackground(UIManager.getColor("SplitPane.background"));
    }

    protected class DividerLayout
    extends BasicSplitPaneDivider.DividerLayout {
        private final /* synthetic */ SkinSplitPaneDivider this$0;

        public void layoutContainer(Container c) {
            if (this.this$0.leftButton != null && this.this$0.rightButton != null && c == this.this$0) {
                Dimension leftSize = this.this$0.leftButton.getPreferredSize();
                Dimension rightSize = this.this$0.rightButton.getPreferredSize();
                if (this.this$0.splitPane.isOneTouchExpandable()) {
                    Insets insets = ((Container)this.this$0).getInsets();
                    if (insets == null) {
                        insets = NO_INSETS;
                    }
                    if (this.this$0.orientation == 0) {
                        int blockSize = this.this$0.getDividerSize() - (insets.left + insets.right);
                        int y = (c.getSize().height - blockSize) / 2;
                        this.this$0.leftButton.setBounds(insets.left + leftSize.width, y, leftSize.width, leftSize.height);
                        this.this$0.rightButton.setBounds(insets.left * 2 + leftSize.width + rightSize.width, y, rightSize.width, rightSize.height);
                    } else {
                        int blockSize = this.this$0.getDividerSize() - (insets.top + insets.bottom);
                        int x = (c.getSize().width - blockSize) / 2;
                        this.this$0.leftButton.setBounds(x, insets.top + leftSize.height, leftSize.width, leftSize.height);
                        this.this$0.rightButton.setBounds(x, insets.top * 2 + leftSize.height + rightSize.height, rightSize.width, rightSize.height);
                    }
                } else {
                    this.this$0.leftButton.setBounds(-5, -5, 1, 1);
                    this.this$0.rightButton.setBounds(-5, -5, 1, 1);
                }
            }
        }

        public Dimension minimumLayoutSize(Container c) {
            if (this.this$0.splitPane.isOneTouchExpandable()) {
                int x;
                int y;
                Dimension leftSize = this.this$0.leftButton.getPreferredSize();
                Dimension rightSize = this.this$0.rightButton.getPreferredSize();
                Insets insets = ((Container)this.this$0).getInsets();
                if (insets == null) {
                    insets = NO_INSETS;
                }
                if (this.this$0.orientation == 0) {
                    y = Math.max(leftSize.height, rightSize.height) + insets.top + insets.bottom;
                    int n = insets.left + leftSize.width + insets.left + rightSize.width + insets.right;
                } else {
                    x = Math.max(leftSize.width, rightSize.width) + insets.left + insets.right;
                    y = insets.top + leftSize.height + insets.top + rightSize.height + insets.bottom;
                }
                return new Dimension(x, y);
            }
            int divSize = (Integer)UIManager.get("SplitPane.dividerSize");
            if (this.this$0.orientation == 0) {
                return new Dimension(((SkinSplitPaneDivider)this.this$0).splitPane.getSize().height, divSize);
            }
            return new Dimension(divSize, ((SkinSplitPaneDivider)this.this$0).splitPane.getSize().width);
        }

        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        DividerLayout(SkinSplitPaneDivider skinSplitPaneDivider) {
            SkinSplitPaneDivider skinSplitPaneDivider2 = skinSplitPaneDivider;
            if (skinSplitPaneDivider2 == null) {
                throw null;
            }
            super(skinSplitPaneDivider2);
            this.this$0 = skinSplitPaneDivider;
        }
    }
}

