/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.hsql.Trace;
import org.hsql.jdbcConnection;
import org.hsql.jdbcResultSet;

public class jdbcStatement
implements Statement {
    private jdbcConnection cConnection;
    private jdbcResultSet rSet;
    private boolean bEscapeProcessing = true;
    private int iMaxRows;

    jdbcStatement(jdbcConnection jdbcConnection2) {
        this.cConnection = jdbcConnection2;
    }

    public void addBatch(String string) throws SQLException {
        throw Trace.error(19);
    }

    public void cancel() {
    }

    public void clearBatch() throws SQLException {
        throw Trace.error(19);
    }

    public void clearWarnings() {
    }

    public void close() {
        this.closeOldResult();
        this.rSet = null;
    }

    private void closeOldResult() {
        if (this.rSet != null) {
            this.rSet.close();
            this.rSet = null;
        }
    }

    public boolean execute(String string) throws SQLException {
        this.fetchResult(string);
        if (this.rSet == null) {
            return false;
        }
        return this.rSet.isResult();
    }

    public int[] executeBatch() throws SQLException {
        throw Trace.error(19);
    }

    public ResultSet executeQuery(String string) throws SQLException {
        this.fetchResult(string);
        return this.rSet;
    }

    public int executeUpdate(String string) throws SQLException {
        this.fetchResult(string);
        if (this.rSet == null) {
            return -1;
        }
        return this.rSet.getUpdateCount();
    }

    private void fetchResult(String string) throws SQLException {
        if (this.bEscapeProcessing) {
            string = this.cConnection.nativeSQL(string);
        }
        this.closeOldResult();
        if (this.iMaxRows == 0) {
            this.rSet = this.cConnection.execute(string);
        } else {
            try {
                string = "SET MAXROWS " + this.iMaxRows + ";" + string;
                this.rSet = this.cConnection.execute(string);
                this.cConnection.execute("SET MAXROWS 0");
            }
            catch (SQLException sQLException) {
                this.cConnection.execute("SET MAXROWS 0");
                throw sQLException;
            }
        }
    }

    public Connection getConnection() {
        return this.cConnection;
    }

    public int getFetchDirection() {
        return 1000;
    }

    public int getFetchSize() {
        return 1;
    }

    public int getMaxFieldSize() {
        return 0;
    }

    public int getMaxRows() {
        return this.iMaxRows;
    }

    public boolean getMoreResults() {
        return false;
    }

    public int getQueryTimeout() {
        return 0;
    }

    public ResultSet getResultSet() {
        return this.rSet;
    }

    public int getResultSetConcurrency() {
        return 1007;
    }

    public int getResultSetType() {
        return 1003;
    }

    public int getUpdateCount() {
        if (this.rSet == null) {
            return -1;
        }
        return this.rSet.getUpdateCount();
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void setCursorName(String string) {
    }

    public void setEscapeProcessing(boolean bl) {
        this.bEscapeProcessing = bl;
    }

    public void setFetchDirection(int n) throws SQLException {
        if (n != 1000) {
            throw Trace.error(19);
        }
    }

    public void setFetchSize(int n) {
    }

    public void setMaxFieldSize(int n) {
    }

    public void setMaxRows(int n) {
        this.iMaxRows = n;
    }

    public void setQueryTimeout(int n) {
    }
}

