/*
 * Decompiled with CFR 0.152.
 */
package rogatkin;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import rogatkin.Persistentable;
import rogatkin.Program;
import rogatkin.Serializer;

public abstract class BaseController
implements Persistentable {
    public static final int LOW_MEMORY = 0;
    public static final Cursor WAIT_CURSOR = new Cursor(3);
    public static final Cursor DEFAULT_CURSOR = new Cursor(0);
    public static final String ISO_8859_1 = "iso-8859-1";
    private static final String WIN_ID = "Windows";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "netscape";
    private static final String UNIX_FLAG = "-remote openURL";
    private static final String[] HEX_DIGITS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    static final int BUF_SIZE = 8192;
    private static String HASHHASH = "something";
    private Hashtable components;
    protected Program main;
    protected Serializer serializer;
    protected boolean ms_vm;
    protected static boolean java2 = System.getProperty("java.specification.name") != null;
    protected int screen_height;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$System;

    public BaseController(Program program) {
        this.main = program;
        HASHHASH = program.getVersion();
        this.components = new Hashtable();
        this.serializer = new Serializer(program.getName());
        try {
            this.ms_vm = System.getProperty("java.vendor").indexOf("Microsoft") >= 0;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.screen_height = Toolkit.getDefaultToolkit().getScreenSize().height;
    }

    public abstract Image getMainIcon();

    public void save() {
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof Persistentable)) continue;
            ((Persistentable)v).save();
        }
    }

    public void load() {
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof Persistentable)) continue;
            ((Persistentable)v).load();
        }
    }

    public boolean showUrl(String string) {
        block6: {
            String string2 = "";
            try {
                if (BaseController.isWindowsPlatform()) {
                    string2 = "rundll32 url.dll,FileProtocolHandler " + string;
                    Process process = Runtime.getRuntime().exec(string2);
                    break block6;
                }
                string2 = "netscape -remote openURL(" + string + ")";
                Process process = Runtime.getRuntime().exec(string2);
                try {
                    int n = process.waitFor();
                    if (n != 0) {
                        string2 = "netscape " + string;
                        process = Runtime.getRuntime().exec(string2);
                    }
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("Error bringing up browser, cmd='" + string2 + "'\nCaught: " + interruptedException);
                    return false;
                }
            }
            catch (IOException iOException) {
                System.err.println("Could not invoke browser, using " + string2 + "\n" + iOException);
                return false;
            }
        }
        return true;
    }

    public static boolean isWindowsPlatform() {
        String string = System.getProperty("os.name");
        return string != null && string.startsWith(WIN_ID);
    }

    public static boolean isLowMemory() {
        if (java2) {
            return Runtime.getRuntime().freeMemory() / 1024L / 1024L < 0L;
        }
        return false;
    }

    public static ImageIcon getResourceIcon(String string) {
        try {
            return new ImageIcon(ClassLoader.getSystemResource((java2 ? "" : "/") + string));
        }
        catch (Exception exception) {
            System.err.println("Couldn't load graphical resource " + string + ", 'cause " + exception);
            return new ImageIcon();
        }
    }

    public void add(Component component, Object object) {
        this.components.put(object, component);
    }

    public Component component(Object object) {
        return (Component)this.components.get(object);
    }

    public Enumeration components() {
        return this.components.elements();
    }

    public Enumeration names() {
        return this.components.keys();
    }

    public static String encryptXor(String string) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            stringBuffer.setCharAt(n, (char)(stringBuffer.charAt(n) ^ HASHHASH.charAt(n % HASHHASH.length())));
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setWaitCursor(Container container, boolean bl) {
        if (container == null) {
            if (!(this.main instanceof Container)) return;
            container = (Container)((Object)this.main);
        } else if (this.ms_vm && container instanceof JComponent) {
            container = ((JComponent)container).getTopLevelAncestor();
        }
        if (bl) {
            container.setCursor(WAIT_CURSOR);
            return;
        } else {
            container.setCursor(DEFAULT_CURSOR);
        }
    }

    public JFrame getMainFrame() {
        if (this.main instanceof JFrame) {
            return (JFrame)((Object)this.main);
        }
        return null;
    }

    public Component getMainGlassPane() {
        if (this.main instanceof JFrame) {
            return ((JFrame)((Object)this.main)).getGlassPane();
        }
        return null;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public static void copyFile(File file, File file2) throws IOException {
        BaseController.copyFile(file, new BufferedOutputStream(new FileOutputStream(file2), 8192));
    }

    public static void copyFile(File file, OutputStream outputStream) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 8192);
        byte[] byArray = new byte[8192];
        while ((n = bufferedInputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
        bufferedInputStream.close();
        outputStream.close();
    }

    public static String toHexString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 4);
        int n = 0;
        while (n < string.length()) {
            stringBuffer.append("0x0").append(Integer.toHexString(string.charAt(n)));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String bytesToHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(HEX_DIGITS[byArray[n] >> 4 & 0xF]).append(HEX_DIGITS[byArray[n] & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static byte[] hexToBytes(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[(cArray.length + 1) / 2];
        int n = 0;
        while (n < (cArray.length + 1) / 2) {
            int n2 = cArray[n * 2] - 48;
            if (n2 > 9) {
                n2 = cArray[n * 2] - 97 + 10;
            }
            if (n2 > 15) {
                n2 = cArray[n * 2] - 65 + 10;
            }
            if (n2 > 15) {
                n2 = 0;
            }
            byArray[n] = (byte)(n2 << 4);
            if (n * 2 + 1 < cArray.length) {
                n2 = cArray[n * 2 + 1] - 48;
                if (n2 > 9) {
                    n2 = cArray[n * 2 + 1] - 97 + 10;
                }
                if (n2 > 15) {
                    n2 = cArray[n * 2 + 1] - 65 + 10;
                }
                if (n2 < 16) {
                    int n3 = n;
                    byArray[n3] = (byte)(byArray[n3] + (byte)n2);
                }
            }
            ++n;
        }
        return byArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            (class$java$lang$System == null ? (class$java$lang$System = BaseController.class$("java.lang.System")) : class$java$lang$System).getDeclaredMethod("setProperty", class$java$lang$String == null ? (class$java$lang$String = BaseController.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = BaseController.class$("java.lang.String")) : class$java$lang$String);
            java2 = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            java2 = false;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

