#include "common.h"
#include "qmath.h"

void q_mul(point c, point a, point b)
{
   c[0] = a[0]*b[0] - a[1]*b[1] - a[2]*b[2] - a[3]*b[3];   /* e part */
   c[1] = a[0]*b[1] + a[1]*b[0] + a[2]*b[3] - a[3]*b[2];   /* j part */
   c[2] = a[0]*b[2] - a[1]*b[3] + a[2]*b[0] + a[3]*b[1];   /* k part */
   c[3] = a[0]*b[3] + a[1]*b[2] - a[2]*b[1] + a[3]*b[0];   /* l part */
   return;
}           

void q_add(point c, point a, point b)
{
   c[0] = a[0] + b[0];
   c[1] = a[1] + b[1];
   c[2] = a[2] + b[2];
   c[3] = a[3] + b[3];
   return;
}           

void q_sub(point c, point a, point b)
{
   c[0] = a[0] - b[0];
   c[1] = a[1] - b[1];
   c[2] = a[2] - b[2];
   c[3] = a[3] - b[3];
   return;
}           


