/* 6.10.99 */

#include <windows.h>
#include <stdlib.h>

/**************************************************************************/

HINSTANCE globalhInstance;
HDC    globalhdc;
HDC    bmphdc;
HBRUSH blackbrush;
unsigned char   *bgr;
HWND   bmphandle,windowhandle;
int    xpos=0,ypos=0,HWIN,VWIN,xold,yold,ldown,rdown;

/**************************************************************************/
void crypt(unsigned char*,unsigned int*);
void get_passwd();
int getC();
void init();
void setpict(int);
int decode();
void cleanup();
void ende(int,int);
int get_byte();
int get_word();
void SOI();
void EOI();
void DQT();
void DHT();
void SOF();
void SOS();
void APP0();
void COM();
void UNKNOWN();
void out_string(char*);
void out_byte(int);
void out_bin(int,int);
void out_hex1(int);
void out_hex2(int);
void out_hex4(int);
void out_dec(int);
void print_string(char*);
void print_dec(int);
int get_bits(int);

LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
VOID zeichne(HDC);

/**************************************************************************/

int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine, int       nCmdShow)
{MSG msg;
 WNDCLASS    wc; 
 BITMAPINFO  bmpinfo;
 int i;
 char *p,*q;

 globalhInstance=hInstance;
 wc.style         = CS_HREDRAW | CS_VREDRAW;
 wc.lpfnWndProc   = (WNDPROC)WndProc;
 wc.cbClsExtra    = 0;
 wc.cbWndExtra    = 0;
 wc.hInstance     = hInstance;
 wc.hIcon         = NULL;
 wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
 wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
 wc.lpszMenuName  = NULL;
 wc.lpszClassName = "pfp";

 bmpinfo.bmiHeader.biSize=40;
 bmpinfo.bmiHeader.biWidth=HBMP;
 bmpinfo.bmiHeader.biHeight=-VBMP;
 bmpinfo.bmiHeader.biPlanes=1;
 bmpinfo.bmiHeader.biBitCount=24;
 bmpinfo.bmiHeader.biCompression=BI_RGB;
 bmpinfo.bmiHeader.biSizeImage=0;
 bmpinfo.bmiHeader.biXPelsPerMeter=1000;
 bmpinfo.bmiHeader.biYPelsPerMeter=1000;
 bmpinfo.bmiHeader.biClrUsed=0;
 bmpinfo.bmiHeader.biClrImportant=0;


 if (!RegisterClass(&wc)) return (FALSE);
 HWIN=GetSystemMetrics(SM_CXSCREEN);
 VWIN=GetSystemMetrics(SM_CYSCREEN);
 if (!(windowhandle=CreateWindow("pfp", "", WS_POPUP|WS_VISIBLE,xpos,
       ypos, HWIN, VWIN, NULL, NULL, hInstance, NULL))) return (FALSE);
 globalhdc=GetDC(windowhandle);

 if (!(bmphdc=CreateCompatibleDC(NULL))) return (FALSE);
 if (!(bmphandle=
       CreateDIBSection(globalhdc,&bmpinfo,DIB_RGB_COLORS,&bgr,NULL,0))
      )
    return (FALSE);
 if (!(SelectObject(bmphdc,bmphandle))) return (FALSE);

 blackbrush=CreateSolidBrush(0);

 p=lpCmdLine; 
 q=filename;
 while (*p == ' ') p++; if (*p=='"') p++; i=0;
 while ( (*q++ = *p++)>' ' && (i++ < 90) ); 
 *(--q)=0; if (*(--q)=='"')*q=0;

 init(); decode(); zeichne(globalhdc);
 
/**************************************************************************/

 while (GetMessage(&msg, NULL,0,0)) 
       {TranslateMessage(&msg); DispatchMessage(&msg); }
 DeleteObject(blackbrush); 
 DeleteObject(bmphandle); 
 DeleteDC(bmphdc);
 ReleaseDC(NULL,globalhdc);
 return (msg.wParam);
}

/**************************************************************************/

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{PAINTSTRUCT ps;
 HDC hdc;
 static int dir=0;
  
 switch (message) 
     {case WM_CHAR:
           if (wParam == ' ')  
             {if (dir<=0) {setpict(pictnr-dir); dir=1; decode();}
              zeichne(globalhdc);
              if (decode()) dir=0;
             }
           else if (wParam == 'b'|| wParam == 'B')  
             {if (dir>=0) {setpict(pictnr-2-dir); dir= -1; decode();}
              zeichne(globalhdc);
              if (pictnr==1) dir=0; else {setpict(pictnr-2); decode();}
             }
           else if (wParam == 'x' || wParam == 'X')  PostQuitMessage(0);
           break;
           
      case WM_LBUTTONDOWN:
           if (dir<=0) {setpict(pictnr-dir); dir=1; decode();}
           zeichne(globalhdc);
           if (decode()) dir=0;
           break;
      case WM_LBUTTONUP:
           break;

      case WM_RBUTTONDOWN:
           if (dir>=0) {setpict(pictnr-2-dir); dir= -1; decode();}
           zeichne(globalhdc);
           if (pictnr==1) dir=0; else {setpict(pictnr-2); decode();}
           break;
      case WM_RBUTTONUP:
           break;

      case WM_MOUSEMOVE:
           break;

      case WM_PAINT:
           hdc = BeginPaint (hWnd, &ps);
           zeichne(hdc); 
           EndPaint (hWnd, &ps);
           break; 

      case WM_DESTROY:
           cleanup();
           PostQuitMessage(0);
           break;

      default:
           return (DefWindowProc(hWnd, message, wParam, lParam));
     }
 return (0);
}

/**************************************************************************/

void zeichne(hdc) 
HDC hdc;
{int i,j,k,l,m,n;
 SelectObject(hdc,blackbrush);
 Rectangle(hdc,0,0,HWIN,VWIN);
 n=hdim; m=vdim;
 if (hdim>HWIN ||vdim>VWIN)
    {if (hdim*VWIN>vdim*HWIN)
        {m=HWIN*vdim/hdim; n=HWIN;
         for (i=0; i<m; i++)
           for (j=0; j<n; j++)
            {k=(i*HBMP+j)*3;l=((i*hdim/HWIN)*HBMP+j*hdim/HWIN)*3;
             bgr[k++]=bgr[l++];
             bgr[k++]=bgr[l++];
             bgr[k++]=bgr[l++];
            }
        }

       else

        {m=VWIN; n=VWIN*hdim/vdim;
         for (i=0; i<VWIN; i++)
           for (j=0; j<n; j++)
            {k=(i*HBMP+j)*3; l=((i*vdim/VWIN)*HBMP+j*vdim/VWIN)*3;
             bgr[k++]=bgr[l++];
             bgr[k++]=bgr[l++];
             bgr[k++]=bgr[l++];
            }
        }
     hdim=n; vdim=m;
    }

 BitBlt(hdc,(HWIN-n)/2,(VWIN-m)/2,n,m,bmphdc,0,0,SRCCOPY);

}

BOOL CALLBACK Dialog (hwndDlg, message, wParam, lParam)
HWND hwndDlg;
UINT message;
WPARAM wParam;
LPARAM lParam;
{switch (message)
  {case WM_INITDIALOG:
        return TRUE;
   case WM_COMMAND:
        switch (LOWORD(wParam))
          {case IDOK:
                passwd[30]=GetDlgItemText(hwndDlg,0,passwd,26);
                EndDialog(hwndDlg, wParam);
                return TRUE;
           case IDCANCEL:
                passwd[30]=GetDlgItemText(hwndDlg,0,passwd,26);
                while (passwd[30]<24) passwd[passwd[30]++]=' ';
                passwd[30]=24;
                EndDialog(hwndDlg, wParam);
                return TRUE;
          }
  }
 return FALSE;
} 

void get_passwd()
{int i;
 char *p;
 typedef struct
   {DWORD style;
    DWORD xstyle;
    WORD  cdit;
    short x;
    short y;
    short cx;
    short cy;
    WORD  menu;
    WORD  class;
    WORD  title;
    
    DWORD style1;
    DWORD xstyle1;
    short x1;
    short y1;
    short cx1;
    short cy1;
    WORD  id1;
    WORD  class1a;
    WORD  class1b;
    char  title1[40];
    WORD  data1;
   }dboxt;

 dboxt dbox1;
 dbox1.style=WS_POPUP|WS_BORDER;
 dbox1.xstyle=0;
 dbox1.cdit=1;
 dbox1.x=10;
 dbox1.y=100;
 dbox1.cx=200;
 dbox1.cy=30;
 dbox1.menu=0;
 dbox1.class=0;
 dbox1.title=0;
 dbox1.style1=WS_CHILD|WS_VISIBLE|SS_LEFT;
 dbox1.xstyle1=0;
 dbox1.x1=10;
 dbox1.y1=10;
 dbox1.cx1=180;
 dbox1.cy1=10;
 dbox1.id1=0;
 dbox1.class1a=0xffff;
 dbox1.class1b=0x0081;
 dbox1.data1=0;
 p="Enter Password       ";

 do
   {i=0; while (i<40) {dbox1.title1[i++]=*p++;dbox1.title1[i++]=0; }
    dbox1.title1[38]=0;
    DialogBoxIndirect(globalhInstance,(LPDLGTEMPLATE) &dbox1,
                      windowhandle,(DLGPROC)Dialog);
    /* MessageBox(windowhandle,passwd,"Password",MB_OK); */
    p="Password to short     ";
   } while (passwd[30]<24);
}

