// TestAxGComDlg.cpp : implementation file
//

#include "stdafx.h"
#include "TestAxGCom.h"
#include "TestAxGComDlg.h"
#include "math.h"
#include "resource.h"
#include "EngineDlg.h"
#include "Ver25.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTestAxGComDlg dialog

CTestAxGComDlg::CTestAxGComDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTestAxGComDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTestAxGComDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	IsLoadTestScript = FALSE;
}

void CTestAxGComDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTestAxGComDlg)
	DDX_Control(pDX, IDC_YP, m_py);
	DDX_Control(pDX, IDC_XP, m_px);
	DDX_Control(pDX, IDC_H, m_rh);
	DDX_Control(pDX, IDC_W, m_rw);
	DDX_Control(pDX, IDC_Y, m_ry);
	DDX_Control(pDX, IDC_X, m_rx);
	DDX_Control(pDX, IDC_AXGC, m_gcom);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTestAxGComDlg, CDialog)
	//{{AFX_MSG_MAP(CTestAxGComDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_CLEAR, OnClear)
	ON_BN_CLICKED(IDC_CREATEDATA, OnCreatedata)
	ON_BN_CLICKED(IDC_ADDNEWSERIES, OnAddnewseries)
	ON_BN_CLICKED(IDC_PROPERTY, OnProperty)
	ON_BN_CLICKED(IDC_ISVIEW, OnIsviewAxis)
	ON_BN_CLICKED(IDC_RUNSCRIPT, OnRunScript)
	ON_BN_CLICKED(IDC_SETXYRANGE, OnSetxyrange)
	ON_BN_CLICKED(IDC_SAVEPICTURE, OnSavePicture)
	ON_BN_CLICKED(IDC_SHADOW, OnShadow)
	ON_BN_CLICKED(IDC_DRAWPOINT, OnDrawPoint)
	ON_BN_CLICKED(IDC_DRAWPOINT_2, OnDrawpoint2)
	ON_BN_CLICKED(IDC_DRAWPOINTS_3, OnDrawPoints3)
	ON_BN_CLICKED(IDC_DRAWPOINTS_4, OnDrawPoints4)
	ON_WM_DESTROY()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_ANIMATE, OnAnimate)
	ON_BN_CLICKED(IDC_SCRIPTENG, OnScriptEng)
	ON_BN_CLICKED(IDC_PICINPIC, OnPicinPic)
	ON_BN_CLICKED(IDC_LIFE, OnLife)
	ON_BN_CLICKED(IDC_MORE, OnMore)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTestAxGComDlg message handlers

BOOL CTestAxGComDlg::PreTranslateMessage(MSG* pMsg) 
{
	
		if(pMsg->message == WM_KEYDOWN)
		{
			
			if(pMsg->wParam == VK_ESCAPE || pMsg->wParam == VK_RETURN)
			{
				return 0;
			}
		}
	return CDialog::PreTranslateMessage(pMsg);
}


BOOL CTestAxGComDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon	
	
	m_uTimerID = (UINT)(SetTimer(0x451,10,0));
	
	m_sli = 150; 
	int sm = m_sli*m_sli;
	pbLife = new BYTE[sm];
	temppbLife = new BYTE[sm];
	m_life = FALSE;
    m_ischec = FALSE;
	m_t = 0;
	

	m_gcom.LicensingKey(123456789); //  You mast set your own licensing key!


	

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTestAxGComDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CTestAxGComDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CTestAxGComDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CTestAxGComDlg::OnClear() 
{
	m_gcom.RemoveAll();
}

void CTestAxGComDlg::OnCreatedata() 
{
	/*
		1. Remove all data from graphical component (RemoveAll)
		2. Create new data-series (CreateSeries)
		3. Add point to series (AddPointToSeries)
	*/

	m_gcom.RemoveAll();
	m_gcom.CreateSeries();
	for(int i = 0; i< 1000; i++)
	{
		m_gcom.AddPointToSeries(0,i,i*sin((double)i/20));
	}



	XYRange();
}

void CTestAxGComDlg::OnAddnewseries() 
{

	m_gcom.CreateSeries();
	int n = m_gcom.GetCountSeries();
	if(n)
	{
		m_gcom.SetPropertySeries(n-1,255,(2*rand())&RGB(255,255,255));
		for(int i = 0; i< 1000; i++)
		{
			m_gcom.AddPointToSeries(n-1,i,n*100.0 + i*sin((double)i/(n*20.0)));
		}

	}


	XYRange();
}

void CTestAxGComDlg::OnProperty() 
{

	m_gcom.SetBackColor((2*rand())&RGB(255,255,255));
	
}

void CTestAxGComDlg::OnIsviewAxis() 
{
	BOOL v = m_gcom.GetViewAxis();
	m_gcom.SetViewAxis(!v);
}

void CTestAxGComDlg::OnRunScript() 
{
	//m_gcom.RemoveAll();
	if(!IsLoadTestScript)
	{
		LONG Script = 0;
		IsLoadTestScript = TRUE;
		m_gcom.LoadScript("Advanced.js", Script);
		// Arguments LoadScript
		// 1. Filename 
		// 2. Type of programming language.  0 - JScript, 1 - VBScript
	}

	switch( m_t ) 
	{
		case 0:
			{m_gcom.RunFunction("FightingCocks");break;}
		case 1:
			{m_gcom.RunFunction("BrownsMove");break;}
		case 2:
			{m_gcom.RunFunction("PtCl6");break;}
		case 3:
			{m_gcom.RunFunction("Commet");break;}
		case 4:
			{m_gcom.RunFunction("Flowers");break;}
		case 5:
			{m_gcom.RunFunction("Mosaic");break;}
		case 6:
			{m_gcom.RunFunction("CreepingLine");break;}
		default :
			{m_gcom.RunFunction("FightingCocks");break;}
	}


	XYRange();
}

void CTestAxGComDlg::OnSetxyrange() 
{
	CString S;
	double x,y,h,w;

	m_rx.GetWindowText(S);
	x = atof(S);
	m_ry.GetWindowText(S);
	y = atof(S);
	m_rw.GetWindowText(S);
	w = atof(S);
	m_rh.GetWindowText(S);
	h = atof(S);

	m_gcom.SetBox(x, y, w, h);
}

void CTestAxGComDlg::XYRange()
{
	double x,y,h,w;
	m_gcom.GetBox(&x,&y,&w,&h);

	CString S;
	S.Format("%.2f",x);
	m_rx.SetWindowText(S);

	S.Format("%.2f",y);
	m_ry.SetWindowText(S);

	S.Format("%.2f",w);
	m_rw.SetWindowText(S);

	S.Format("%.2f",h);
	m_rh.SetWindowText(S);
}

BEGIN_EVENTSINK_MAP(CTestAxGComDlg, CDialog)
    //{{AFX_EVENTSINK_MAP(CTestAxGComDlg)
	ON_EVENT(CTestAxGComDlg, IDC_AXGC, 1 /* ChangePosition */, OnChangePositionAxGC, VTS_NONE)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()

void CTestAxGComDlg::OnChangePositionAxGC() 
{
	double x,y;
	x = m_gcom.GetX();
	y = m_gcom.GetY();

	CString S;
	S.Format("X position %.2f",x);
	m_px.SetWindowText(S);

	S.Format("Y position %.2f",y);
	m_py.SetWindowText(S);


}

void CTestAxGComDlg::OnSavePicture() 
{
	CHAR buf[1024];
	DWORD dwR,dwN = 1024;
	dwR = ::GetCurrentDirectory(dwN,buf);


	if(dwR)
	{
		m_gcom.AddFrame("frame"); 
		m_gcom.SaveFrameToGraphFile("randPic.jpg", "frame");
	}

}



void CTestAxGComDlg::OnShadow() 
{
	m_gcom.Shadow(3, 3, 5, 100, 200, 200, 200);
}

void CTestAxGComDlg::OnDrawPoint() 
{
	
	m_gcom.RemoveAll();
	m_gcom.CreateSeries();
	int n = m_gcom.GetCountSeries();
	if(n)
	{ 
		m_gcom.SetPropertySeries(n-1,255,(2*rand())&RGB(255,255,255));
		for(int i = 0; i< 1000; i++)
		{
			m_gcom.AddPointToSeries(n-1,i,n*100.0 + i*sin((double)i/(n*20.0)));
		}
		
		m_gcom.Points(30,2);


	}
	

	XYRange();
}

void CTestAxGComDlg::OnDrawpoint2() 
{
	m_gcom.RemoveAll();
	m_gcom.CreateSeries();
	int n = m_gcom.GetCountSeries();
	if(n)
	{
		m_gcom.SetPropertySeries(n-1,255, RGB(0,0,255));
		for(int i = 0; i< 20; i++)
		{
			m_gcom.AddPointToSeries(n-1,i,i*i);
		}
		
		m_gcom.Points(8,255);


	}
	

	XYRange();
}

void CTestAxGComDlg::OnDrawPoints3() 
{
	m_gcom.RemoveAll();
	for(int k=0;k<3;k++)
	{
		m_gcom.CreateSeries();
	}
	
	m_gcom.SetPropertySeries(0,255, RGB(0,0,255));
	m_gcom.SetPropertySeries(1,255, RGB(255,0,0));
	m_gcom.SetPropertySeries(2,255, RGB(255,255,0));
	
	for(int i = 0; i< 2000; i++)
	{
		m_gcom.AddPointToSeries(0,i,i*rand());
		m_gcom.AddPointToSeries(1,i,(i-2000)*rand());
		m_gcom.AddPointToSeries(2,i,(i-3000)*rand());
	}
		
	m_gcom.Points(80,1);


	m_gcom.SetIsDrawOnlyPoints(TRUE);	
}

void CTestAxGComDlg::OnDrawPoints4() 
{
	
	m_gcom.RemoveAll();
	m_gcom.CreateSeries();
	m_gcom.SetPropertySeries(0,255, RGB(0,0,255));
	
	for(int i = 0; i< 20; i++)
	{
		m_gcom.AddPointToSeries(0,i,i);
	}
		
	m_gcom.Points(10,255);

	
	m_gcom.SetIsDrawOnlyPoints(TRUE);	
}


void CTestAxGComDlg::OnDestroy() 
{
	delete[] pbLife;
	delete[] temppbLife;
	m_life = FALSE;

	CDialog::OnDestroy();
	KillTimer(m_uTimerID);
}

void CTestAxGComDlg::OnTimer(UINT nIDEvent) 
{
	if(m_ischec)OnRunScript();
	if(m_life)OnLife();
	
	CDialog::OnTimer(nIDEvent);
}


void CTestAxGComDlg::OnAnimate() 
{
	m_ischec = ((CButton*)GetDlgItem(IDC_ANIMATE))->GetCheck();
	
	GetDlgItem(IDC_SAVEPICTURE)->EnableWindow(!m_ischec);
	GetDlgItem(IDC_CLEAR)->EnableWindow(!m_ischec);
	GetDlgItem(IDC_CREATEDATA)->EnableWindow(!m_ischec);
	GetDlgItem(IDC_ADDNEWSERIES)->EnableWindow(!m_ischec);
	GetDlgItem(IDC_PROPERTY)->EnableWindow(!m_ischec);
	GetDlgItem(IDC_ISVIEW)->EnableWindow(!m_ischec);
	GetDlgItem(IDC_SETXYRANGE)->EnableWindow(!m_ischec);
	GetDlgItem(IDC_RUNSCRIPT)->EnableWindow(!m_ischec);
	GetDlgItem(IDC_SHADOW)->EnableWindow(!m_ischec);
	GetDlgItem(IDC_DRAWPOINT)->EnableWindow(!m_ischec);
	GetDlgItem(IDC_DRAWPOINT_2)->EnableWindow(!m_ischec);
	GetDlgItem(IDC_DRAWPOINTS_3)->EnableWindow(!m_ischec);
	GetDlgItem(IDC_DRAWPOINTS_4)->EnableWindow(!m_ischec);
	GetDlgItem(IDC_SCRIPTENG)->EnableWindow(!m_ischec);
	GetDlgItem(IDC_PICINPIC)->EnableWindow(!m_ischec);
	GetDlgItem(IDC_LIFE)->EnableWindow(!m_ischec);
	GetDlgItem(IDC_MORE)->EnableWindow(!m_ischec);
		
}

void CTestAxGComDlg::OnScriptEng() 
{
	CEngineDlg dlg;
	if(dlg.DoModal()==IDOK)
	{
		m_gcom.RemoveAll();
		m_ischec = 1;
		((CButton*)GetDlgItem(IDC_ANIMATE))->SetCheck(TRUE);
		dlg.DestroyWindow();
		OnAnimate();
		OnRunScript();
	}
}

void CTestAxGComDlg::OnPicinPic() 
{


	IStorage* pIStorage = NULL;
	IStream*  pIStream  = NULL;
	
	HRESULT hr = StgCreateDocfile(
      L"temp.cmp", 
      STGM_READWRITE|STGM_CREATE|STGM_SHARE_EXCLUSIVE|STGM_DELETEONRELEASE , 
      0, 
      &pIStorage);

	hr = pIStorage->CreateStream(L"Image",
			STGM_READWRITE|STGM_SHARE_EXCLUSIVE,
			0,
			0,
			&pIStream);
 

	m_gcom.SavePicture((IDispatch*)pIStream);
	m_gcom.SetImage((IDispatch*)pIStream, 100, 100, 200, 200);

	
	pIStream->Release(); 
	pIStorage->Release();	
   
	 
	
}

void CTestAxGComDlg::OnLife() 
{
	
	m_life = ((CButton*)GetDlgItem(IDC_LIFE))->GetCheck();

	GetDlgItem(IDC_ANIMATE)->EnableWindow(!m_life);
	GetDlgItem(IDC_SAVEPICTURE)->EnableWindow(!m_life);
	GetDlgItem(IDC_CLEAR)->EnableWindow(!m_life);
	GetDlgItem(IDC_CREATEDATA)->EnableWindow(!m_life);
	GetDlgItem(IDC_ADDNEWSERIES)->EnableWindow(!m_life);
	GetDlgItem(IDC_PROPERTY)->EnableWindow(!m_life);
	GetDlgItem(IDC_ISVIEW)->EnableWindow(!m_life);
	GetDlgItem(IDC_SETXYRANGE)->EnableWindow(!m_life);
	GetDlgItem(IDC_RUNSCRIPT)->EnableWindow(!m_life);
	GetDlgItem(IDC_SHADOW)->EnableWindow(!m_life);
	GetDlgItem(IDC_DRAWPOINT)->EnableWindow(!m_life);
	GetDlgItem(IDC_DRAWPOINT_2)->EnableWindow(!m_life);
	GetDlgItem(IDC_DRAWPOINTS_3)->EnableWindow(!m_life);
	GetDlgItem(IDC_DRAWPOINTS_4)->EnableWindow(!m_life);
	GetDlgItem(IDC_SCRIPTENG)->EnableWindow(!m_life);
	GetDlgItem(IDC_PICINPIC)->EnableWindow(!m_life);
	GetDlgItem(IDC_MORE)->EnableWindow(!m_life);

	if(!m_life) m_gcom.RemoveAll();
	int k = m_gcom.GetCountMatrix();
	m_gcom.SetBackColor(RGB(0,0,100));
	if(!k)
	{
		m_gcom.CreateMatrix();
		m_gcom.SetMatrixSize(0,m_sli,m_sli);
		int inx;
		for(int i=0;i<m_sli;i++)
			{
				for(int j=0;j<m_sli;j++)
				{
					inx = j*m_sli + i;
					pbLife[inx] = !(rand()%5);
					m_gcom.SetCell(0,i,j,RGB(0,50,100),RGB(200,255,0),255,1,pbLife[inx]);
				}
			}
	}else
	{
		int stat = 0;
		int inx,inx2;
		int sm = m_sli*m_sli;
		memcpy(temppbLife,pbLife,sm*sizeof(BYTE));
		for(int i=1;i<m_sli-1;i++)
		{
			for(int j=1;j<m_sli-1;j++)
			{
				inx = j*m_sli + i;
				stat = 0;
				
				for(int k = i-1;k<i+2;k++)
				{
					for(int r = j-1;r<j+2;r++)
					{
						inx2 = r*m_sli + k;
						if(!(k==i && r==j))
						{
							stat+=pbLife[inx2];
						}
					}
				}

				if(stat<2 || stat>3)  temppbLife[inx] = 0;
				if(stat==3) temppbLife[inx] = 1;		
			}
		}

		memcpy(pbLife,temppbLife,sm*sizeof(BYTE));
		for(i=1;i<m_sli-1;i++)
		{
			for(int j=1;j<m_sli-1;j++)
			{
				inx = j*m_sli + i;
				m_gcom.SetCell(0,i,j,RGB(0,50,100),RGB(200,255,0),255,1, pbLife[inx]);
			}
		}

	
	}
		
	
}


void CTestAxGComDlg::OnMore() 
{
	CVer25 more;
	more.DoModal(); 	
}
