//
//
//           ^           **   **   **** ***** *    ****     ^      Take me to
//          (_)            * *     *      *   *    *       (_)    / your
//     ^                    *      **     *   *    **            ^  leader...
//    (_)       ^          * *     *      *   *    *            (_)
//             (_)       **   **   *    ***** **** ****
//
//                    Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
//                          *** Tester Application ***
//
// Created by Chuck Walbourn
//
// xtbuffer.cpp
//
//

//
//
//                                Includes
//
//

#include <iostream.h>

#include "xfile.hpp"

//
//
//                               Routines
//
//

void print_error(char *s);
void print_error(class XFile *xf, char *s);

//
//
//                                 Code
//
//

//Ŀ
// buffer                                                                   
//
void buffer()
{
// Perform file tests 
   cout << "\n\n\n Buffered Disk tests \n";

   XFileDiskBuf xf;

   if (xf.create("TESTFILE.DAT",XF_OPEN_WRITE|XF_OPEN_READ))
   {
       print_error(&xf,"Failed to create file");
   }
   else {
       ulong    i;
       ulong    result;
       char     data[128];

       cout << "File created.\n";

       result=xf.write("Test string\n",sizeof("Test string\n"));

       if (result != sizeof("Test string\n"))
           print_error(&xf,"Failed to write string");
       else
           cout << "Written.\n";

       cout << "Current file position: " << xf.tell() << "\n";

       xf.flush();
       xf.seek_set(0);

       result=xf.read(data,128);

       if (!result)
           print_error(&xf,"Failed to read");
       else {
           for(i=0; i < result; i++)
               cout << data[i];
       }

       xf.close();
   }
}

// End of module - xtbuffer.cpp 

