//
//
//                                                           %__________%
//                                                          %/ . .  .   \%
//           Van Gogh 2D-Display Library                     |  . .  o. |
//                                                           |. _  .   .|
//        Microsoft Windows 95/98/NT Version                 | / \   .  |
//                                                           |_|_|_._._.|
//                                                           |.-.-.-.-..|
//                                                          %\__________/%
//                                                           %          %
//
//  Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Tim Little
//
// tri8.cpp
//
//

//
//
//                                Includes
//
//
//#include <assert.h>
#include <string.h>

#include "debug.h"
#include "portable.h"
#include "vangogh.hpp"

//
//
//                                Equates
//
//


//
//
//                               Structures
//
//

//
//
//                               Routines
//
//

extern "C" void scan_solid_edge(VngoPoint2 *edge,VngoPoint2 *p1, VngoPoint2 *p2);
extern "C" void draw_hlines(VngoTriangle *tri);

//
//
//                                 Data
//
//

//
//
//                                 Code
//
//

//
//  void vngo_triangle8(VngoVbuffer *vb,VngoPoint2 *pts,dword color)
//      This routine draws a flat shaded triangle, making the assumption
//      that it has already been clipped.
//

extern "C" void vngo_triangle8 (VngoVbuffer *vb,VngoPoint2 *pts,dword color)
{
    VngoTriangle    tri;
    int high_pt_idx = 0;
    int low_pt_idx = 2;
    int mid_pt_idx = 1;
    VngoPoint2 *edge1 = (VngoPoint2*)vb->edge1;
    VngoPoint2 *edge2 = (VngoPoint2*)vb->edge2;

    calc_order(high_pt_idx,mid_pt_idx,low_pt_idx,pts);

    VngoPoint2 *high_pt = &pts[high_pt_idx];
    VngoPoint2 *mid_pt = &pts[mid_pt_idx];
    VngoPoint2 *low_pt = &pts[low_pt_idx];

    long    dy1 = ((low_pt->y + 0x8000) >> 16) - ((high_pt->y + 0x8000) >> 16);
    long    dy2 = ((mid_pt->y + 0x8000) >> 16) - ((high_pt->y + 0x8000) >> 16);

    if (dy1 == 0)
    {   // the triangle is completely flat if this is true.
        return;
    }

    VngoShadePal8   *tp = (VngoShadePal8*)vb->pal->shd_pal;
    VngoColorShade8 *tc = &(*tp)[color];
    byte            clr = tc->shl[pts[0].shade >> 19];
    byte            *scrnptr = vb->scrn_ptr + vb->ytable[(high_pt->y + 0x8000) >> 16];

    scan_solid_edge(edge1,high_pt,low_pt);

    scan_solid_edge(edge2,high_pt,mid_pt);

    scan_solid_edge(&edge2[dy2],mid_pt,low_pt);

    tri.sptr = scrnptr;
    tri.pitch = vb->pitch;
    tri.color = clr;
    tri.height = dy1;

    if (edge1[dy2].x < edge2[dy2].x)
    {
        tri.left_edge = edge1;
        tri.right_edge = edge2;
    }
    else
    {
        tri.left_edge = edge2;
        tri.right_edge = edge1;
    }
    draw_hlines(&tri);
}

extern "C" void scan_solid_edge(VngoPoint2 *edge,VngoPoint2 *p1, VngoPoint2 *p2)
{
    Flx16 xstep;
    Flx16 dy = Flx16(p2->y - p1->y,0);
    long  count = ((p2->y + 0x8000) >> 16) - ((p1->y + 0x8000) >> 16);
    if (count)
    {
        Flx16 dx = Flx16(p2->x - p1->x,0);
        if (dy.flx < 0x10000)
        {
            xstep = dx;
        }
        else
        {
            xstep = dx / dy;
        }
        Flx16 wx = Flx16(p1->x,0);

        count++;
        while (count--)
        {
            edge->x = wx.flx;
            edge++;
            wx += xstep;
        }
    }
}



extern "C" void draw_hlines(VngoTriangle *tri)
{
    long        count = tri->height;
    long        pitch = tri->pitch;
    byte        clr = (byte)tri->color;
    byte        *scrn = (byte*)tri->sptr;
    VngoPoint2  *edge1 = tri->left_edge;
    VngoPoint2  *edge2 = tri->right_edge;

    for (long y=0;y <= count;y++)
    {
        long tx = (edge1->x + 0x8000) >> 16;
        byte *ptr = scrn + tx;
        int dx = ((edge2->x + 0x8000) >> 16) - tx;

        for (int x = 0;x <= dx; x++)
        {
            *ptr++ = clr;
        }
        scrn += pitch;
        edge1++;
        edge2++;
    }
}

// End of module - tri8.cpp 
