//
//
//                              S I M   G I N E
//
//             __               ___   ______,-------
//           __==__,------------/|\--|      | .-.-.|    ___________
//         (|     |--------------|---|------| '-`-`|  _/___________\_
//         (|_____|      _       _   |   _  | 6000 | |               |
//          |__\\_|`-._/___\___/___\_|_/___\|      | |               |
//         __/ |===|--|_____|_|_____|_|___  |\_____|=|_______________|
//      |=|[_]==[_]    \ _ /   \ _ /   \ _ /          [_]   [_]   [_]
//
//
//                     A Simluator Framework for MythOS(tm)
//
//                     Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1997-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Dan Higdon and Chuck Walbourn
//
// simaudio.hpp
//
// SimAudio - Audio management class
//
//

#ifndef __SIMAUDIO_HPP
#define __SIMAUDIO_HPP   1

#ifdef __WATCOMC__
#pragma pack(1);
#endif

#ifdef _MSC_VER
#pragma pack(push,1)
#endif

//
//
//                                Classes
//
//

//
// SimAudio - audio management class
//
// This class manages the sound source, sample caching, and sample timing
// needed by the application.
//
class SimAudio
{
public:
    //Ŀ
    // Equates                                                              
    //
    enum error_codes
    {
        ERROR_NONE      = 0,
        ERROR_INIT      = 1,
        ERROR_NOMEMORY  = 2,
    };

    //Ŀ
    // Public data members                                                  
    //
    BachDigital         *digi;
    ulong               nchannels3d;
    BachSample3D        **channels3d;
    ulong               nchannels;
    ulong               nreserved;
    BachStaticSample    **channels;
    BachFileSample      *stream;

    //Ŀ
    // Constructor/Destructors                                              
    //
    SimAudio();
    virtual ~SimAudio();

    //Ŀ
    // Operations                                                           
    //
    virtual error_codes init (ulong drate=BACH_DIGI_DRIVERRATE,
                              bach_digi_fmt dfmt=BACH_DIGI_STEREO_16,
                              ulong nchannels=SIM_AUDIO_NCHANNELS,
                              ulong nreserved=SIM_AUDIO_NRESERVED,
                              ulong n3d=SIM_AUDIO_NCHANNELS3D);
    virtual void release();
    virtual void clear_all_sounds();

    virtual int prepare_wav(const char *fname, int channel = -1);
    virtual void play(ulong channel, int loop=0);
    virtual void stop(ulong channel);

    virtual int prepare_wav_stream(const char *fname);
    virtual void play_stream(int loop=0);
    virtual void next_stream();
    virtual void stop_stream();

    //Ŀ
    // Utility functions                                                    
    //
    BachStaticSample *get_channel(ulong channel)
    {
        if (!channels
            || (channel >= nchannels))
            return 0;

        return channels[channel];
    }
    BachSample3D *get_channel3d(ulong channel)
    {
        if (!channels3d
            || (channel >= nchannels3d))
            return 0;

        return channels3d[channel];
    }
};


//
//
//                                 Data
//
//

extern SimAudio         *Audio;             // Audio control instance

#ifdef __WATCOMC__
#pragma pack();
#endif

#ifdef _MSC_VER
#pragma pack(pop)
#endif

#endif

// End of header - simaudio.hpp 
