//
//
//
//
//
//
//
//
//
//
// Microsoft Windows 95/98/NT Version 
//
//Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Tim Little & Chuck Walbourn
//
// essfield.cpp
//
// Contains the code for the EschStarfield class which implements
// a space 'starfield' drawable.
//
//

//
//
//                                Includes
//
//

#include "escher.hpp"

//
//
//                                 Data
//
//

extern VngoPointF EschTempVPointF;

//
//
//                                 Code
//
//

//
//  Constructors/Destructors  
//

//Ŀ
// EschStarfield - Destructor                                               
//
EschStarfield::~EschStarfield()
{
    release();
}



//
//  Operations  
//

//Ŀ
// EschStarfield - operator =                                               
//                                                                          
// Copies the data from another starfield.                                  
//
const EschStarfield &EschStarfield::operator = (const EschStarfield &sf)
{
    if (this != &sf)
    {
        release();

        EschDrawable::operator = (sf);

        count = sf.count;
        stars = sf.stars;
        brightness = sf.brightness;
        color = sf.color;
    }
    return *this;
}


//Ŀ
// EschStarfield - draw                                                     
//                                                                          
// Draws the starfield using the current drawing context.                   
//
void EschStarfield::draw()
{
    EschCamera          *cam;

    if (!stars || !count)
        return;

// Setup local pointers to current camera and Van Gogh viewport.
    assertMyth("EschStarfield::draw needs camera in current context",
               EschCurrent != NULL && EschCurrent->camera != NULL);

    cam=EschCurrent->camera;

    assertMyth("EschStarfield::draw needs a viewport in current context's camera",
               cam->vport != NULL);

    VngoVport *vport = cam->vport;

    assertMyth("EschStarfield::draw needs palette in viewport",
               vport->vbuff.pal != 0);

    EschTempVPointF.clr = color;
    EschTempVPointF.shade = float(vport->vbuff.pal->shd_pal->mid_point);

// Setup Context
    EschContext ec(EschCurrent);
    ec.current = this;
    ec.push();

// Draw stars
    for(ulong i=0; i < count; i++)
    {
        // Transform into copy of point
        if (flags & ESCH_SFLD_FTL)
        {
            stars[i].transform(&cam->eye.iorient,(EschPoint*)&EschTempVPointF);
        }
        else
        {
            ((EschVector*)&stars[i])->transform(&cam->eye.iorient,
                                                (EschVector*)&EschTempVPointF);
        }

        if (brightness)
            EschTempVPointF.shade = float(brightness[i]);

        // Draw
        esch_clipdraw_point(ESCH_CDF_CLIP | ESCH_CDF_INFINITEZ);
    }

// Cleanup
    ec.pop();
}


//Ŀ
// EschStarfield - release                                                  
//                                                                          
// Releases the star database.                                              
//
void EschStarfield::release()
{
    if (flags & ESCH_DRW_OWNSDATA)
    {
        if (stars)
        {
            delete [] stars;
        }
        if (brightness)
        {
            delete [] brightness;
        }
    }
    flags &= ~ESCH_DRW_OWNSDATA;
    stars=0;
    brightness=0;
}



//
//  Utility Routines  
//

//Ŀ
// EschStarfield - create_stars                                             
//                                                                          
// Creates a random starfield.                                              
//
esch_error_codes EschStarfield::create_stars(ulong c, int dobrights)
{
    release();

// Allocate memory
    stars = new EschPoint[c];
    if (!stars)
        return ESCH_ERR_NOMEMORY;

    if (dobrights)
    {
        brightness = new dword[c];
        if (!brightness)
        {
            delete [] stars;
            stars=0;
            return ESCH_ERR_NOMEMORY;
        }
    }

    flags |= ESCH_DRW_OWNSDATA;

// Create random stars
    count=c;

    for(ulong i=0; i < c; i++)
    {
        stars[i].x = flx_rand();
        stars[i].y = flx_rand();
        stars[i].z = flx_rand();

        if (brightness)
        {
            brightness[i] = ((flx_rand().flx & 0xf) << 4) | 0x1f;
        }
    }

    return ESCH_ERR_NONE;
}

// End of module - essfield.cpp 

