/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.util.io.ASCII85;
import org.freehep.util.io.FinishableOutputStream;

public class ASCII85OutputStream
extends FilterOutputStream
implements ASCII85,
FinishableOutputStream {
    private boolean end = false;
    private int characters = 80;
    private int[] b = new int[4];
    private int bIndex = 0;
    private int[] c = new int[5];

    public ASCII85OutputStream(OutputStream out) {
        super(out);
    }

    public void write(int a2) throws IOException {
        this.b[this.bIndex] = a2 & 0xFF;
        ++this.bIndex;
        if (this.bIndex >= this.b.length) {
            this.writeTuple();
            this.bIndex = 0;
        }
    }

    public void finish() throws IOException {
        if (!this.end) {
            this.end = true;
            if (this.bIndex > 0) {
                this.writeTuple();
            }
            this.writeChar(126);
            this.writeChar(62);
            this.flush();
            if (this.out instanceof FinishableOutputStream) {
                ((FinishableOutputStream)((Object)this.out)).finish();
            }
        }
    }

    public void close() throws IOException {
        this.finish();
        super.close();
    }

    private void writeTuple() throws IOException {
        int i2 = this.bIndex;
        while (i2 < this.b.length) {
            this.b[i2] = 0;
            ++i2;
        }
        long d2 = (long)(this.b[0] << 24 | this.b[1] << 16 | this.b[2] << 8 | this.b[3]) & 0xFFFFFFFFL;
        this.c[0] = (int)(d2 / 52200625L + 33L);
        this.c[1] = (int)((d2 %= 52200625L) / 614125L + 33L);
        this.c[2] = (int)((d2 %= 614125L) / 7225L + 33L);
        this.c[3] = (int)((d2 %= 7225L) / 85L + 33L);
        this.c[4] = (int)(d2 % 85L + 33L);
        if (this.bIndex >= this.b.length && this.c[0] == 33 && this.c[1] == 33 && this.c[2] == 33 && this.c[3] == 33 && this.c[4] == 33) {
            this.writeChar(122);
        } else {
            int i3 = 0;
            while (i3 < this.bIndex + 1) {
                this.writeChar(this.c[i3]);
                ++i3;
            }
        }
    }

    private void writeChar(int b2) throws IOException {
        if (this.characters == 0) {
            this.characters = 80;
            super.write(10);
        }
        --this.characters;
        super.write(b2);
    }
}

