/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.graphics;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import org.freehep.swing.graphics.AbstractRegionSelectionPanel;
import org.freehep.swing.graphics.GraphicalSelectionPanel;
import org.freehep.swing.images.FreeHepImage;

public class RectangularSelectionPanel
extends AbstractRegionSelectionPanel {
    public int getNumberOfControlPoints() {
        return 4;
    }

    public Cursor getControlPointCursor(int index) {
        if (index >= 0) {
            int k2 = (index + 2) % 4;
            return AbstractRegionSelectionPanel.compassCursor("Resize", this.xCtrlPts[index] - this.xCtrlPts[k2], this.yCtrlPts[index] - this.yCtrlPts[k2], 4, true);
        }
        return FreeHepImage.getCursor("RectangularCursor");
    }

    public void initializeControlPoints(int x2, int y2) {
        this.activeCtrlPt = 2;
        Arrays.fill(this.xCtrlPts, x2);
        Arrays.fill(this.yCtrlPts, y2);
    }

    public void updateActiveControlPoint(int x2, int y2) {
        x2 = this.forceXCoordinateWithinBounds(x2);
        y2 = this.forceYCoordinateWithinBounds(y2);
        this.xCtrlPts[this.activeCtrlPt] = x2;
        this.yCtrlPts[this.activeCtrlPt] = y2;
        int oppCtrlPt = (this.activeCtrlPt + 2) % this.nCtrlPts;
        int xOpp = this.xCtrlPts[oppCtrlPt];
        int yOpp = this.yCtrlPts[oppCtrlPt];
        int otherCtrlPt = x2 < xOpp && y2 > yOpp || x2 > xOpp && y2 < yOpp ? 1 : 3;
        otherCtrlPt = (this.activeCtrlPt + otherCtrlPt) % 4;
        this.xCtrlPts[otherCtrlPt] = x2;
        this.yCtrlPts[otherCtrlPt] = yOpp;
        otherCtrlPt = (otherCtrlPt + 2) % this.nCtrlPts;
        this.xCtrlPts[otherCtrlPt] = xOpp;
        this.yCtrlPts[otherCtrlPt] = y2;
        this.repaintPanel();
    }

    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        if (this.visible) {
            Graphics2D g2d = (Graphics2D)g2;
            g2d.setStroke(GraphicalSelectionPanel.thickStroke);
            g2.setColor(Color.black);
            g2.drawPolygon(this.xCtrlPts, this.yCtrlPts, this.nCtrlPts);
            g2d.setStroke(GraphicalSelectionPanel.thinStroke);
            g2.setColor(Color.white);
            g2.drawPolygon(this.xCtrlPts, this.yCtrlPts, this.nCtrlPts);
            if (this.activeCtrlPt >= 0) {
                g2.setColor(Color.black);
                g2.fillRect(this.xCtrlPts[this.activeCtrlPt] - AbstractRegionSelectionPanel.ctrlPtSize - 1, this.yCtrlPts[this.activeCtrlPt] - AbstractRegionSelectionPanel.ctrlPtSize - 1, 2 * AbstractRegionSelectionPanel.ctrlPtSize + 3, 2 * AbstractRegionSelectionPanel.ctrlPtSize + 3);
                g2.setColor(Color.white);
                g2.fillRect(this.xCtrlPts[this.activeCtrlPt] - AbstractRegionSelectionPanel.ctrlPtSize, this.yCtrlPts[this.activeCtrlPt] - AbstractRegionSelectionPanel.ctrlPtSize, 2 * AbstractRegionSelectionPanel.ctrlPtSize + 1, 2 * AbstractRegionSelectionPanel.ctrlPtSize + 1);
            }
        }
    }

    public AffineTransform makeAffineTransform() {
        int second = 0;
        int third = 0;
        int first = 0;
        int savedValue = this.xCtrlPts[0] * this.xCtrlPts[0] + this.yCtrlPts[0] * this.yCtrlPts[0];
        int i2 = 1;
        while (i2 < 4) {
            int value = this.xCtrlPts[i2] * this.xCtrlPts[i2] + this.yCtrlPts[i2] * this.yCtrlPts[i2];
            if (value < savedValue) {
                savedValue = value;
                first = i2;
            }
            ++i2;
        }
        second = (first + 1) % 4;
        third = (first + 2) % 4;
        return this.makeTransform(this.xCtrlPts[first], this.yCtrlPts[first], this.xCtrlPts[second], this.yCtrlPts[second], this.xCtrlPts[third], this.yCtrlPts[third]);
    }

    public boolean isValidSelection() {
        return this.visible && (this.xCtrlPts[0] != this.xCtrlPts[2] || this.yCtrlPts[0] != this.yCtrlPts[2]);
    }
}

