/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.record.loop.examples;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.TooManyListenersException;
import org.freehep.record.loop.LoopException;
import org.freehep.record.loop.SequentialRecordLoopImpl;
import org.freehep.record.loop.event.ChainableRecordListenerDecorator;
import org.freehep.record.loop.event.RecordAdapter;
import org.freehep.record.loop.event.RecordSuppliedEvent;
import org.freehep.record.loop.examples.EchoStrings;

public class RejectEvenStrings
extends RecordAdapter {
    private long count;

    public void recordSupplied(RecordSuppliedEvent event) {
        ++this.count;
        if (0L == this.count % 2L) {
            event.getRecordLoop().doNotCount(event.getRecord());
        }
    }

    public static void main(String[] args) throws FileNotFoundException {
        if (0 == args.length) {
            System.err.println("Filename must be specified.");
            return;
        }
        EchoStrings echoStrings = new EchoStrings();
        RejectEvenStrings rejectEvenStrings = new RejectEvenStrings();
        ChainableRecordListenerDecorator listener = new ChainableRecordListenerDecorator(rejectEvenStrings);
        try {
            listener.addRecordListener(echoStrings);
        }
        catch (TooManyListenersException e2) {
            // empty catch block
        }
        EchoStrings echoStrings2 = echoStrings;
        echoStrings2.getClass();
        EchoStrings.LineSupplier supplier = echoStrings2.new EchoStrings.LineSupplier(args[0]);
        SequentialRecordLoopImpl recordLoop = new SequentialRecordLoopImpl(supplier);
        try {
            recordLoop.addRecordListener(listener);
            long count = 1 < args.length ? (long)Integer.parseInt(args[1]) : -1L;
            long processed = recordLoop.loop(count);
            System.out.println("Processed " + processed + " lines.");
        }
        catch (TooManyListenersException e3) {
        }
        catch (LoopException e1) {
            System.err.println("Loop failed:\n" + e1.toString());
        }
        catch (IOException e3) {
            System.err.println("An IOException was thrown.");
        }
    }
}

