/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;

public class Polyline16
extends EMFTag {
    private Rectangle bounds;
    private int numberOfPoints;
    private Point[] points;

    Polyline16() {
        super(87, 1);
    }

    public Polyline16(Rectangle bounds, int numberOfPoints, Point[] points) {
        this();
        this.bounds = bounds;
        this.numberOfPoints = numberOfPoints;
        this.points = points;
    }

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        Rectangle r2 = emf.readRECTL();
        int n2 = emf.readDWORD();
        Polyline16 tag = new Polyline16(r2, n2, emf.readPOINTS(n2));
        return tag;
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        emf.writeRECTL(this.bounds);
        emf.writeDWORD(this.numberOfPoints);
        emf.writePOINTS(this.numberOfPoints, this.points);
    }

    public String toString() {
        return super.toString() + "\n" + "  bounds: " + this.bounds + "\n" + "  #points: " + this.numberOfPoints;
    }
}

