/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphics2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.AttributedCharacterIterator;
import java.util.Properties;
import org.freehep.graphics2d.PrintColor;
import org.freehep.graphics2d.SymbolShape;
import org.freehep.graphics2d.TagString;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.util.UserProperties;

public abstract class AbstractVectorGraphics
extends VectorGraphics {
    private UserProperties properties;
    private String creator;
    private boolean isDeviceIndependent;
    private SymbolShape cachedShape;
    private int colorMode;
    private Color backgroundColor;
    private Color currentColor;
    private Paint currentPaint;
    private Font currentFont;

    public AbstractVectorGraphics() {
        this.properties = new UserProperties();
        this.creator = "FreeHEP Graphics2D Driver";
        this.isDeviceIndependent = false;
        this.cachedShape = new SymbolShape();
        this.colorMode = 0;
        this.currentFont = null;
        this.backgroundColor = null;
        this.currentColor = null;
        this.currentPaint = null;
    }

    protected AbstractVectorGraphics(AbstractVectorGraphics graphics) {
        this.properties = graphics.properties;
        this.creator = graphics.creator;
        this.isDeviceIndependent = graphics.isDeviceIndependent;
        this.cachedShape = graphics.cachedShape;
        this.backgroundColor = graphics.backgroundColor;
        this.currentColor = graphics.currentColor;
        this.currentPaint = graphics.currentPaint;
        this.colorMode = graphics.colorMode;
        this.currentFont = graphics.currentFont;
    }

    public void setProperties(Properties newProperties) {
        if (newProperties == null) {
            return;
        }
        this.properties.setProperties(newProperties);
    }

    protected void initProperties(Properties defaults) {
        this.properties = new UserProperties();
        this.properties.setProperties(defaults);
    }

    protected Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public Color getPropertyColor(String key) {
        return this.properties.getPropertyColor(key);
    }

    public Rectangle getPropertyRectangle(String key) {
        return this.properties.getPropertyRectangle(key);
    }

    public Insets getPropertyInsets(String key) {
        return this.properties.getPropertyInsets(key);
    }

    public Dimension getPropertyDimension(String key) {
        return this.properties.getPropertyDimension(key);
    }

    public int getPropertyInt(String key) {
        return this.properties.getPropertyInt(key);
    }

    public double getPropertyDouble(String key) {
        return this.properties.getPropertyDouble(key);
    }

    public boolean isProperty(String key) {
        return this.properties.isProperty(key);
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        if (creator != null) {
            this.creator = creator;
        }
    }

    public boolean isDeviceIndependent() {
        return this.isDeviceIndependent;
    }

    public void setDeviceIndependent(boolean isDeviceIndependent) {
        this.isDeviceIndependent = isDeviceIndependent;
    }

    public Font getFont() {
        return this.currentFont;
    }

    public void setFont(Font font) {
        this.currentFont = font;
    }

    public void drawSymbol(int x2, int y2, int size, int symbol) {
        this.drawSymbol((double)x2, (double)y2, (double)size, symbol);
    }

    public void fillSymbol(int x2, int y2, int size, int symbol) {
        this.fillSymbol((double)x2, (double)y2, (double)size, symbol);
    }

    public void drawSymbol(double x2, double y2, double size, int symbol) {
        if (size <= 0.0) {
            return;
        }
        this.drawSymbol(this, x2, y2, size, symbol);
    }

    protected void drawSymbol(VectorGraphics g2, double x2, double y2, double size, int symbol) {
        switch (symbol) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.cachedShape.create(symbol, x2, y2, size);
                g2.draw(this.cachedShape);
                break;
            }
            case 5: {
                double diameter = Math.max(1.0, size);
                diameter += diameter % 2.0;
                g2.drawOval(x2 - diameter / 2.0, y2 - diameter / 2.0, diameter, diameter);
                break;
            }
        }
    }

    public void fillSymbol(double x2, double y2, double size, int symbol) {
        if (size <= 0.0) {
            return;
        }
        this.fillSymbol(this, x2, y2, size, symbol);
    }

    protected void fillSymbol(VectorGraphics g2, double x2, double y2, double size, int symbol) {
        switch (symbol) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.cachedShape.create(symbol, x2, y2, size);
                g2.draw(this.cachedShape);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.cachedShape.create(symbol, x2, y2, size);
                g2.fill(this.cachedShape);
                break;
            }
            case 5: {
                double diameter = Math.max(1.0, size);
                diameter += diameter % 2.0;
                g2.fillOval(x2 - diameter / 2.0, y2 - diameter / 2.0, diameter, diameter);
                break;
            }
        }
    }

    public void clearRect(int x2, int y2, int width, int height) {
        this.clearRect((double)x2, (double)y2, (double)width, (double)height);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.drawLine((double)x1, (double)y1, (double)x2, (double)y2);
    }

    public void drawRect(int x2, int y2, int width, int height) {
        this.drawRect((double)x2, (double)y2, (double)width, (double)height);
    }

    public void fillRect(int x2, int y2, int width, int height) {
        this.fillRect((double)x2, (double)y2, (double)width, (double)height);
    }

    public void drawArc(int x2, int y2, int width, int height, int startAngle, int arcAngle) {
        this.drawArc((double)x2, (double)y2, (double)width, (double)height, (double)startAngle, (double)arcAngle);
    }

    public void fillArc(int x2, int y2, int width, int height, int startAngle, int arcAngle) {
        this.fillArc((double)x2, (double)y2, (double)width, (double)height, (double)startAngle, (double)arcAngle);
    }

    public void drawOval(int x2, int y2, int width, int height) {
        this.drawOval((double)x2, (double)y2, (double)width, (double)height);
    }

    public void fillOval(int x2, int y2, int width, int height) {
        this.fillOval((double)x2, (double)y2, (double)width, (double)height);
    }

    public void drawRoundRect(int x2, int y2, int width, int height, int arcWidth, int arcHeight) {
        this.drawRoundRect((double)x2, (double)y2, (double)width, (double)height, (double)arcWidth, (double)arcHeight);
    }

    public void fillRoundRect(int x2, int y2, int width, int height, int arcWidth, int arcHeight) {
        this.fillRoundRect((double)x2, (double)y2, (double)width, (double)height, (double)arcWidth, (double)arcHeight);
    }

    public void translate(int x2, int y2) {
        this.translate((double)x2, (double)y2);
    }

    public void setLineWidth(int width) {
        this.setLineWidth((double)width);
    }

    public void setLineWidth(double width) {
        Stroke stroke = this.getStroke();
        if (stroke instanceof BasicStroke) {
            BasicStroke cs = (BasicStroke)stroke;
            if ((double)cs.getLineWidth() != width) {
                stroke = new BasicStroke((float)width, cs.getEndCap(), cs.getLineJoin(), cs.getMiterLimit(), cs.getDashArray(), cs.getDashPhase());
                this.setStroke(stroke);
            }
        } else {
            stroke = new BasicStroke((float)width);
            this.setStroke(stroke);
        }
    }

    public void drawString(String str, int x2, int y2) {
        this.drawString(str, (double)x2, (double)y2);
    }

    public void drawString(String s2, float x2, float y2) {
        this.drawString(s2, (double)x2, (double)y2);
    }

    public void drawString(AttributedCharacterIterator iterator, int x2, int y2) {
        this.drawString(iterator, (float)x2, (float)y2);
    }

    public void drawString(String str, double x2, double y2, int horizontal, int vertical) {
        this.drawString(str, x2, y2, horizontal, vertical, false, null, 0.0, false, null);
    }

    public void drawString(TagString str, double x2, double y2) {
        this.drawString(str, x2, y2, 1, 0);
    }

    public void drawString(TagString str, double x2, double y2, int horizontal, int vertical) {
        this.drawString(str, x2, y2, horizontal, vertical, false, null, 0.0, false, null);
    }

    public int getColorMode() {
        return this.colorMode;
    }

    public void setColorMode(int colorMode) {
        this.colorMode = colorMode;
    }

    public Color getBackground() {
        return this.backgroundColor;
    }

    public void setBackground(Color color) {
        this.backgroundColor = color;
    }

    public void setColor(Color color) {
        this.currentColor = color;
        this.currentPaint = color;
    }

    public Color getColor() {
        return this.currentColor;
    }

    public void setPaint(Paint paint) {
        if (!(paint instanceof Color)) {
            this.currentColor = null;
        }
        this.currentPaint = paint;
    }

    public Paint getPaint() {
        return this.currentPaint;
    }

    protected Color getPrintColor(Color color) {
        if (this.colorMode == 0) {
            return color;
        }
        PrintColor printColor = PrintColor.createPrintColor(color);
        return printColor.getColor(this.colorMode);
    }

    public void rotate(double theta, double x2, double y2) {
        this.translate(x2, y2);
        this.rotate(theta);
        this.translate(-x2, -y2);
    }

    public void drawArc(double x2, double y2, double width, double height, double startAngle, double arcAngle) {
        this.draw(new Arc2D.Double(x2, y2, width, height, startAngle, arcAngle, 0));
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.draw(new Line2D.Double(x1, y1, x2, y2));
    }

    public void drawOval(double x2, double y2, double width, double height) {
        this.draw(new Ellipse2D.Double(x2, y2, width, height));
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.draw(this.createShape(xPoints, yPoints, nPoints, false));
    }

    public void drawPolyline(double[] xPoints, double[] yPoints, int nPoints) {
        this.draw(this.createShape(xPoints, yPoints, nPoints, false));
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.draw(this.createShape(xPoints, yPoints, nPoints, true));
    }

    public void drawPolygon(double[] xPoints, double[] yPoints, int nPoints) {
        this.draw(this.createShape(xPoints, yPoints, nPoints, true));
    }

    public void drawRect(double x2, double y2, double width, double height) {
        this.draw(new Rectangle2D.Double(x2, y2, width, height));
    }

    public void drawRoundRect(double x2, double y2, double width, double height, double arcWidth, double arcHeight) {
        this.draw(new RoundRectangle2D.Double(x2, y2, width, height, arcWidth, arcHeight));
    }

    public void fillArc(double x2, double y2, double width, double height, double startAngle, double arcAngle) {
        this.fill(new Arc2D.Double(x2, y2, width, height, startAngle, arcAngle, 2));
    }

    public void fillOval(double x2, double y2, double width, double height) {
        this.fill(new Ellipse2D.Double(x2, y2, width, height));
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.fill(new Polygon(xPoints, yPoints, nPoints));
    }

    public void fillPolygon(double[] xPoints, double[] yPoints, int nPoints) {
        this.fill(this.createShape(xPoints, yPoints, nPoints, true));
    }

    public void fillRect(double x2, double y2, double width, double height) {
        this.fill(new Rectangle2D.Double(x2, y2, width, height));
    }

    public void fillRoundRect(double x2, double y2, double width, double height, double arcWidth, double arcHeight) {
        this.fill(new RoundRectangle2D.Double(x2, y2, width, height, arcWidth, arcHeight));
    }

    protected abstract GeneralPath createShape(double[] var1, double[] var2, int var3, boolean var4);

    protected GeneralPath createShape(int[] xPoints, int[] yPoints, int nPoints, boolean close) {
        GeneralPath path = new GeneralPath(0);
        if (nPoints > 0) {
            path.moveTo(xPoints[0], yPoints[0]);
            int lastX = xPoints[0];
            int lastY = yPoints[0];
            if (close && Math.abs(xPoints[nPoints - 1] - lastX) < 1 && Math.abs(yPoints[nPoints - 1] - lastY) < 1) {
                --nPoints;
            }
            int i2 = 1;
            while (i2 < nPoints) {
                if (Math.abs(xPoints[i2] - lastX) > 1 || Math.abs(yPoints[i2] - lastY) > 1) {
                    path.lineTo(xPoints[i2], yPoints[i2]);
                    lastX = xPoints[i2];
                    lastY = yPoints[i2];
                }
                ++i2;
            }
            if (close) {
                path.closePath();
            }
        }
        return path;
    }
}

