/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Color;

public class PdfPRow {
    protected PdfPCell[] cells;
    protected float maxHeight = 0.0f;
    protected boolean calculated = false;

    public PdfPRow(PdfPCell[] pdfPCellArray) {
        this.cells = pdfPCellArray;
    }

    public PdfPRow(PdfPRow pdfPRow) {
        this.maxHeight = pdfPRow.maxHeight;
        this.calculated = pdfPRow.calculated;
        this.cells = new PdfPCell[pdfPRow.cells.length];
        int n2 = 0;
        while (n2 < this.cells.length) {
            if (pdfPRow.cells[n2] != null) {
                this.cells[n2] = new PdfPCell(pdfPRow.cells[n2]);
            }
            ++n2;
        }
    }

    public boolean setWidths(float[] fArray) {
        if (fArray.length != this.cells.length) {
            return false;
        }
        float f2 = 0.0f;
        this.calculated = false;
        int n2 = 0;
        while (n2 < fArray.length) {
            PdfPCell pdfPCell = this.cells[n2];
            pdfPCell.setLeft(f2);
            int n3 = n2 + pdfPCell.getColspan();
            while (n2 < n3) {
                f2 += fArray[n2];
                ++n2;
            }
            --n2;
            pdfPCell.setRight(f2);
            pdfPCell.setTop(0.0f);
            ++n2;
        }
        return true;
    }

    public float calculateHeights() {
        this.maxHeight = 0.0f;
        int n2 = 0;
        while (n2 < this.cells.length) {
            PdfPCell pdfPCell = this.cells[n2];
            if (pdfPCell != null) {
                float f2;
                PdfPTable pdfPTable = pdfPCell.getTable();
                if (pdfPTable == null) {
                    f2 = pdfPCell.isNoWrap() ? 20000.0f : pdfPCell.right() - pdfPCell.getPaddingRight();
                    ColumnText columnText = new ColumnText(null);
                    columnText.setSimpleColumn(pdfPCell.getPhrase(), pdfPCell.left() + pdfPCell.getPaddingLeft(), pdfPCell.top() - pdfPCell.getPaddingTop(), f2, -20000.0f, 0.0f, pdfPCell.getHorizontalAlignment());
                    columnText.setLeading(pdfPCell.getLeading(), pdfPCell.getMultipliedLeading());
                    columnText.setIndent(pdfPCell.getIndent());
                    columnText.setExtraParagraphSpace(pdfPCell.getExtraParagraphSpace());
                    columnText.setFollowingIndent(pdfPCell.getFollowingIndent());
                    columnText.setRightIndent(pdfPCell.getRightIndent());
                    try {
                        columnText.go(true);
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter(documentException);
                    }
                    float f3 = columnText.getYLine();
                    pdfPCell.setBottom(f3 - pdfPCell.getPaddingBottom());
                } else {
                    pdfPTable.setTotalWidth(pdfPCell.right() - pdfPCell.getPaddingRight() - pdfPCell.getPaddingLeft() - pdfPCell.left());
                    pdfPCell.setBottom(pdfPCell.top() - pdfPCell.getPaddingTop() - pdfPCell.getPaddingBottom() - pdfPTable.getTotalHeight());
                }
                f2 = pdfPCell.getFixedHeight();
                if (f2 <= 0.0f) {
                    f2 = pdfPCell.height();
                }
                if (f2 < pdfPCell.getFixedHeight()) {
                    f2 = pdfPCell.getFixedHeight();
                } else if (f2 < pdfPCell.getMinimumHeight()) {
                    f2 = pdfPCell.getMinimumHeight();
                }
                if (f2 > this.maxHeight) {
                    this.maxHeight = f2;
                }
            }
            ++n2;
        }
        this.calculated = true;
        return this.maxHeight;
    }

    public void writeBorderAndBackgroung(float f2, float f3, PdfPCell pdfPCell, PdfContentByte[] pdfContentByteArray) {
        PdfContentByte pdfContentByte = pdfContentByteArray[2];
        PdfContentByte pdfContentByte2 = pdfContentByteArray[1];
        float f4 = pdfPCell.left() + f2;
        float f5 = pdfPCell.top() + f3;
        float f6 = pdfPCell.right() + f2;
        float f7 = f5 - this.maxHeight;
        Color color = pdfPCell.backgroundColor();
        if (color != null) {
            pdfContentByte2.setColorFill(color);
            pdfContentByte2.rectangle(f4, f5, f6 - f4, f7 - f5);
            pdfContentByte2.fill();
        } else if (pdfPCell.grayFill() > 0.0f) {
            pdfContentByte2.setGrayFill(pdfPCell.grayFill());
            pdfContentByte2.rectangle(f4, f5, f6 - f4, f7 - f5);
            pdfContentByte2.fill();
        }
        if (pdfPCell.hasBorders()) {
            Color color2;
            if (pdfPCell.borderWidth() != -1.0f) {
                pdfContentByte.setLineWidth(pdfPCell.borderWidth());
            }
            if ((color2 = pdfPCell.borderColor()) != null) {
                pdfContentByte.setColorStroke(color2);
            }
            if (pdfPCell.hasBorder(15)) {
                pdfContentByte.rectangle(f4, f5, f6 - f4, f7 - f5);
            } else {
                if (pdfPCell.hasBorder(8)) {
                    pdfContentByte.moveTo(f6, f5);
                    pdfContentByte.lineTo(f6, f7);
                }
                if (pdfPCell.hasBorder(4)) {
                    pdfContentByte.moveTo(f4, f5);
                    pdfContentByte.lineTo(f4, f7);
                }
                if (pdfPCell.hasBorder(2)) {
                    pdfContentByte.moveTo(f4, f7);
                    pdfContentByte.lineTo(f6, f7);
                }
                if (pdfPCell.hasBorder(1)) {
                    pdfContentByte.moveTo(f4, f5);
                    pdfContentByte.lineTo(f6, f5);
                }
            }
            pdfContentByte.stroke();
            if (color2 != null) {
                pdfContentByte.resetRGBColorStroke();
            }
        }
    }

    public void writeCells(float f2, float f3, PdfContentByte[] pdfContentByteArray) {
        if (!this.calculated) {
            this.calculateHeights();
        }
        int n2 = 0;
        while (n2 < this.cells.length) {
            PdfPCell pdfPCell = this.cells[n2];
            if (pdfPCell != null) {
                float f4;
                float f5;
                this.writeBorderAndBackgroung(f2, f3, pdfPCell, pdfContentByteArray);
                PdfPTable pdfPTable = pdfPCell.getTable();
                float f6 = 0.0f;
                switch (pdfPCell.getVerticalAlignment()) {
                    case 6: {
                        f6 = pdfPCell.top() + f3 - this.maxHeight + pdfPCell.height() - pdfPCell.getPaddingTop();
                        break;
                    }
                    case 5: {
                        f6 = pdfPCell.top() + f3 + (pdfPCell.height() - this.maxHeight) / 2.0f - pdfPCell.getPaddingTop();
                        break;
                    }
                    default: {
                        f6 = pdfPCell.top() + f3 - pdfPCell.getPaddingTop();
                    }
                }
                if (pdfPTable == null) {
                    f5 = pdfPCell.getFixedHeight();
                    f4 = pdfPCell.right() + f2 - pdfPCell.getPaddingRight();
                    float f7 = pdfPCell.left() + f2 + pdfPCell.getPaddingLeft();
                    if (pdfPCell.isNoWrap()) {
                        switch (pdfPCell.getHorizontalAlignment()) {
                            case 1: {
                                f4 += 10000.0f;
                                f7 -= 10000.0f;
                                break;
                            }
                            case 2: {
                                f7 -= 20000.0f;
                                break;
                            }
                            default: {
                                f4 += 20000.0f;
                            }
                        }
                    }
                    ColumnText columnText = new ColumnText(pdfContentByteArray[3]);
                    float f8 = -20000.0f;
                    if (f5 > 0.0f && pdfPCell.height() > this.maxHeight) {
                        f6 = pdfPCell.top() + f3 - pdfPCell.getPaddingTop();
                        f8 = pdfPCell.top() + f3 - this.maxHeight + pdfPCell.getPaddingBottom();
                    }
                    columnText.setSimpleColumn(pdfPCell.getPhrase(), f7, f6, f4, f8, 0.0f, pdfPCell.getHorizontalAlignment());
                    columnText.setLeading(pdfPCell.getLeading(), pdfPCell.getMultipliedLeading());
                    columnText.setIndent(pdfPCell.getIndent());
                    columnText.setExtraParagraphSpace(pdfPCell.getExtraParagraphSpace());
                    columnText.setFollowingIndent(pdfPCell.getFollowingIndent());
                    columnText.setRightIndent(pdfPCell.getRightIndent());
                    columnText.setSpaceCharRatio(pdfPCell.getSpaceCharRatio());
                    try {
                        columnText.go();
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter(documentException);
                    }
                } else {
                    f5 = 0.0f;
                    f4 = 0.0f;
                    if (pdfPTable.size() > 0) {
                        PdfPRow pdfPRow = pdfPTable.getRow(pdfPTable.size() - 1);
                        f5 = this.maxHeight - pdfPTable.getTotalHeight() - pdfPCell.getPaddingBottom() - pdfPCell.getPaddingTop();
                        if (f5 > 0.0f) {
                            f4 = pdfPRow.getMaxHeights();
                            pdfPRow.setMaxHeights(pdfPRow.getMaxHeights() + f5);
                        }
                    }
                    pdfPTable.writeSelectedRows(0, -1, pdfPCell.left() + f2 + pdfPCell.getPaddingLeft(), f6, pdfContentByteArray);
                    if (f5 > 0.0f) {
                        pdfPTable.getRow(pdfPTable.size() - 1).setMaxHeights(f4);
                    }
                }
            }
            ++n2;
        }
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public float getMaxHeights() {
        if (this.calculated) {
            return this.maxHeight;
        }
        return this.calculateHeights();
    }

    public void setMaxHeights(float f2) {
        this.maxHeight = f2;
    }

    float[] getEventWidth(float f2) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.cells.length) {
            if (this.cells[n3] != null) {
                ++n2;
            }
            ++n3;
        }
        float[] fArray = new float[n2 + 1];
        n2 = 0;
        fArray[n2++] = f2;
        int n4 = 0;
        while (n4 < this.cells.length) {
            if (this.cells[n4] != null) {
                fArray[n2] = fArray[n2 - 1] + this.cells[n4].width();
                ++n2;
            }
            ++n4;
        }
        return fArray;
    }
}

