Attribute VB_Name = "Module1"
Option Explicit

'=========================================================
'   Program:         DeleteOldFiles
'   Date Written:   8/13/1999
'   Author:             Craig Duey
'=========================================================
'
'   This command line program will delete old files from the specified drive.
'   It accepts path & day arguments that determine how old the files should be before they are
'   deleted and where they are deleted from.  The command line format is:
'       DeleteOldFiles path days [-r]
'   for example, to delete files older than 45 days from the MyTemp directory;
'       DeleteOldFiles C:\MyTemp 45
'   use the -r option to recursively search through sub-directories, for example;
'       DeleteOldFiles C:\MyTemp 45 -r
'   will delete files from MyTemp and all of its directories
'
'   The last write date is used to calculate the file's age.
'   Files older than the 'days' argument will be deleted.
'
'   This program utilizes the windows "shell" API function call: SHFileOperation
'   The function is used to delete files by moving them to the recycle bin - thereby
'   giving the user the ability to recover deleted files.
'
'   The program also makes use of Windows System 32 API calls to search the
'   directory and to convert date/time fields.
'
'   Results are written to: DeleteOldFiles.log
'=========================================================

Public m_intNbrRecsDel As Integer
Public m_intNbrDirDel As Integer
Public m_dCurrDate As Date
Public m_lngArgDays As Long
Public m_strEmpty As String * 1
Public m_dFileDate As Date, m_lngDays As Long
Public m_strFileName As String, m_vRtn As Variant
Public m_bRecurse As Boolean
Public m_bDeleteOn As Boolean
Public m_bEmpty As Boolean
Public m_bCreateDate As Boolean

Public Const FO_DELETE = &H3
Public Const FOF_ALLOWUNDO = &H40
Public Const FOF_NOCONFIRMATION = &H10
Public Const MAX_PATH = 260

' structure used by SHFileOperation
Type SHFILEOPSTRUCT
    hwnd As Long
    wFunc As Long
    pFrom As String
    pTo As String
    fFlags As Integer
    fAnyOperationsAborted As Long
    hNameMappings As Long
    lpszProgressTitle As String ' only used if FOF_SIMPLEPROGRESS
End Type
   
' structure used by time conversion functions
Public Type SYSTEMTIME
    wYear As Integer
    wMonth As Integer
    wDayOfWeek As Integer
    wDay As Integer
    wHour As Integer
    wMinute As Integer
    wSecond As Integer
    wMilliseconds As Integer
End Type
    
' structures used by Find file functions
Public Type FILETIME
    dwLowDateTime As Long
    dwHighDateTime As Long
End Type

Public Type WIN32_FIND_DATA
    dwFileAttributes As Long
    ftCreationTime As FILETIME
    ftLastAccessTime As FILETIME
    ftLastWriteTime As FILETIME
    nFileSizeHigh As Long
    nFileSizeLow As Long
    dwReserved0 As Long
    dwReserved1 As Long
    cFileName As String * MAX_PATH
    cAlternate As String * 14
End Type


Declare Function SHFileOperation Lib "shell32.dll" Alias "SHFileOperationA" (lpFileOp As SHFILEOPSTRUCT) As Long
    
Declare Function FindFirstFile Lib "kernel32" Alias "FindFirstFileA" (ByVal lpFileName As String, lpFindFileData As WIN32_FIND_DATA) As Long

Declare Function FindNextFile Lib "kernel32" Alias "FindNextFileA" (ByVal hfindfile As Long, lpFindFileData As WIN32_FIND_DATA) As Long

Declare Function FindClose Lib "kernel32" (ByVal hfindfile As Long) As Long
                        
Declare Function FileTimeToSystemTime Lib "kernel32" (lpFileTime As FILETIME, lpSystemTime As SYSTEMTIME) As Long
                        
Declare Function FileTimeToLocalFileTime Lib "kernel32" (lpFileTime As FILETIME, lpLocalFileTime As FILETIME) As Long

' +++++++++++++++++++++++++++++++++++++++++++++++++++++++
' +++++++++++++++++  M A I N   R O U T I N E    ++++++++++++++++++++++
' +++++++++++++++++++++++++++++++++++++++++++++++++++++++
Private Sub Main()

    Dim i As Integer
    Dim strArgs As String, strMsg As String, strDaysArg As String, intPos As Integer
    Dim strArgPath As String, strCurPath As String, bArgsFound As Boolean

    
    m_dCurrDate = Date
    strCurPath = CurDir
    
    ' get the command line argument(s)...
    strArgs = Command
    
    ' check for help request...
    If strArgs = "" _
    Or strArgs = "?" _
    Or strArgs = "/?" _
    Or strArgs = "-?" Then
        strMsg = "Version " & App.Major & "." & App.Minor & "." & App.Revision & vbCrLf & _
                         "This program deletes files that are greater than n days old." & vbCrLf & vbCrLf & _
                        "DeleteOldFiles path days [-c][-e][-n][-r]" & vbCrLf & _
                        "    path" & vbTab & "= fully qualified path name to delete files from" & vbCrLf & _
                        "    days" & vbTab & "= age of files to be deleted" & vbCrLf & _
                        "    -c" & vbTab & "= optional flag to use the Create date when determining age.  " & vbCrLf & _
                        vbTab & vbTab & "Default behavior is to use the file's modify date." & vbCrLf & _
                        "    -e" & vbTab & "= optional flag to delete directories if they are Empty and " & vbCrLf & _
                        vbTab & vbTab & "are greater than n days old" & vbCrLf & _
                        "    -n" & vbTab & "= optional flag to disable deletion - log file will indicate which files are" & vbCrLf & _
                        vbTab & vbTab & "eligible for deletion " & vbCrLf & _
                        "    -r" & vbTab & "= optional flag to search sub-directories Recursively  " & vbCrLf & _
                        "For example, to delete files from MyTemp and all of its sub-directories, enter:" & vbCrLf & vbCrLf & _
                        "DeleteOldFiles c:\MyTemp 45 -r" & vbCrLf & vbCrLf & _
                        "Process results are in text file: " & App.EXEName & ".log.  " & _
                        "Files are recoverable via the Recycle Bin.  " & _
                        "Only local files are sent to the Recycle Bin  " & _
                        "i.e. not files on network drives" & vbCrLf & vbCrLf & _
                        "Craig Duey - cduey@cdwebtech.com" & vbCrLf & _
                        "CDWebTech.com" & vbCrLf & vbCrLf & _
                        "April 2000"
        MsgBox strMsg
        Exit Sub
    End If
    
    ' init optional parms
    
    m_bRecurse = False
    m_bDeleteOn = True
    m_bEmpty = False
    m_bCreateDate = False
    
    ' parse argument string into seperate arguments
    
    bArgsFound = True
    strArgs = Trim(strArgs)
    
    While bArgsFound = True
        Select Case UCase(Right(strArgs, 3))
            
            Case " -R"      ' recurse option
                ' this option used to determine if program should recursively  search through
                ' sub-directories
                m_bRecurse = True
                ' trim option off of end of string
                strArgs = Left(strArgs, Len(strArgs) - 3)
            
            Case " -N"         ' non-update option
                ' this option is used to turn deletion off.  log file will be produced but files
                ' will not be deleted.
                m_bDeleteOn = False
                ' trim option off of end of string
                strArgs = Left(strArgs, Len(strArgs) - 3)
            
            Case " -E"         ' Empty directory option
                ' this option is used to delete directories if they are empty
                m_bEmpty = True
                ' trim option off of end of string
                strArgs = Left(strArgs, Len(strArgs) - 3)
                            
            Case " -C"         ' Create date option
                ' this option is used to force evaluatuion of a file's create date
                m_bCreateDate = True
                ' trim option off of end of string
                strArgs = Left(strArgs, Len(strArgs) - 3)
                
            Case Else
                bArgsFound = False
        End Select
    Wend

    
    ' get number of days from the end of the string...
    
    strDaysArg = ""
    
    intPos = Len(strArgs)
    For i = 1 To Len(strArgs)
        If IsNumeric(Mid(strArgs, intPos, intPos)) Then
            strDaysArg = Mid(strArgs, intPos, 1) & strDaysArg
            intPos = intPos - 1
        Else
            Exit For
        End If
    Next i
    
    ' get the path from the beginning of the string
    
    strArgPath = Left(strArgs, intPos)
    
    ' if necessary, append a slash (/) to end of path
    If Not Right(strArgPath, 1) = "\" Then
        strArgPath = strArgPath & "\"
    End If
    
    ' perform edits...

    If IsNumeric(strDaysArg) Then
        m_lngArgDays = strDaysArg
    Else
        MsgBox "Invalid 'days' argument passed:" & vbCrLf & vbCrLf & _
                    strDaysArg & vbCrLf & vbCrLf & _
                    "enter DeleteOldFiles -? for more information."
        Exit Sub
    End If
    
    ' check for valid path...
    ' "Dir" will return an empty string if the path is invalid.
    
    strMsg = Dir(strArgPath, vbDirectory)   ' the vbDirectory argument will cause the Dir command
                                                                ' to return "." & ".." if there are no files in the directory.
                                                                ' This way, a legit (empty) directory is not confused with
                                                                ' an invalid direcotry.
    
    If strMsg = "" _
    Or Not Mid(strArgPath, 2, 2) = ":\" Then
        MsgBox "Invalid 'path' argument passed:" & vbCrLf & vbCrLf & _
                    strArgPath & vbCrLf & vbCrLf & _
                    "enter DeleteOldFiles ? for more information."
        Exit Sub
    End If


    ' Start log file...

    Open strCurPath & "/" & App.EXEName & ".log" For Output As 2
    
    Print #2, App.EXEName & " activity log for " & Date & "  " & Time
    Print #2,
    Print #2, "Files older than " & m_lngArgDays & " days will be deleted"
    If m_bRecurse = True Then
        Print #2,
        Print #2, "Sub-directories included in search"
    End If
    If m_bDeleteOn = False Then
        Print #2,
        Print #2, "Non-update, files will not be deleted"
    End If
    If m_bEmpty = True _
    And m_bDeleteOn = True Then
        Print #2,
        Print #2, "Empty directories will be deleted"
    End If
    If m_bCreateDate = True Then
        Print #2,
        Print #2, "Create date will be used to determine age"
    Else
        Print #2,
        Print #2, "Modify date will be used to determine age"
    End If
    Print #2,
    
    m_intNbrRecsDel = 0
    m_intNbrDirDel = 0
    
    Call SearchDir(strArgPath)

    ' finish the log file...
    
    Print #2,
    If m_bDeleteOn = True Then
        Print #2, Date & "  " & Time & "  " & _
                    "Number of files deleted: " & m_intNbrRecsDel
        Print #2, Date & "  " & Time & "  " & _
                    "Number of directories deleted: " & m_intNbrDirDel
    Else
        Print #2, Date & "  " & Time & "  " & _
                    "Number of files eligible for deletion: " & m_intNbrRecsDel
        Print #2, Date & "  " & Time & "  " & _
                    "Number of directories eligible for deletion: " & m_intNbrDirDel
    End If
    Print #2,
    
    Close #2
    
    
End Sub

Private Sub SearchDir(ByVal strPath As String)
    Dim bEndOfDir As Boolean, wfdFileData As WIN32_FIND_DATA
    Dim hFile As Long, strMsg As String
    
    Print #2, "Begin directory: " & strPath
    Print #2,
    
    
'   find the first file in the directory...
'       wfdFileData is a data structure that contains file details
'       The FindFirstFile function returns a handle that is used in subsequent Find functions
'       If zero is returned, the function did not work.

    hFile = FindFirstFile(strPath & "*.*", wfdFileData)
    
    If hFile = 0 Then
        Print #2, "*** ERROR with FindFirstFile function, processes aborted"
        Close #2
        Exit Sub
    End If

    bEndOfDir = False
    
    ' loop through all files in directory...
    
    While bEndOfDir = False
        With wfdFileData
        
            'convert the fixed length (name) string to a variable length string
            m_strFileName = Left(.cFileName, InStr(1, .cFileName, m_strEmpty) - 1)
            
'            If .dwFileAttributes And vbDirectory Then
'                Print #2, "file name: " & m_strFileName
'                Print #2, "attributes: " & .dwFileAttributes
'                Print #2, "directory"
'            End If
'            If .dwFileAttributes And vbSystem Then
'                Print #2, "file name: " & m_strFileName
'                Print #2, "attributes: " & .dwFileAttributes
'                Print #2, "system"
'            End If
'            If .dwFileAttributes And vbHidden Then
'                Print #2, "file name: " & m_strFileName
'                Print #2, "attributes: " & .dwFileAttributes
'                Print #2, "hidden"
'            End If
'            If .dwFileAttributes And vbVolume Then
'                Print #2, "file name: " & m_strFileName
'                Print #2, "attributes: " & .dwFileAttributes
'                Print #2, "volume"
'            End If

            If m_strFileName = "." _
            Or m_strFileName = ".." Then
                ' Print #2, ". or .. - skip"
            ElseIf (.dwFileAttributes And vbDirectory) _
                    And m_bRecurse = True Then
                ' recurse into sub-directory...
                ' Print #2, "directory"
                Call SearchDir(strPath & m_strFileName & "\")
            ElseIf Not (.dwFileAttributes And vbSystem) _
            And Not (.dwFileAttributes And vbHidden) _
            And Not (.dwFileAttributes And vbVolume) _
            And Not (.dwFileAttributes And vbDirectory) Then
                ' "normal" file...
                ' Print #2, "file looks normal"
                m_dFileDate = GreatestFileDate(wfdFileData)
                ' Print #2, "m_dFileDate = " & m_dFileDate
                ' calculate the age of the file
                m_lngDays = DateDiff("d", m_dFileDate, m_dCurrDate)
                ' Print #2, "m_lngDays = " & m_lngDays
                ' if the number of days exceedes the passed number of days, delete the file
                If m_lngDays > m_lngArgDays Then
                    If m_bDeleteOn = True Then
                        Print #2, "Delete      : " & strPath & m_strFileName
                    Else
                        Print #2, "Eligible for deletion: " & strPath & m_strFileName
                    End If
                    Print #2, "Compare date: " & m_dFileDate
                    Print #2,
        
                    If m_bDeleteOn = True Then
                        m_vRtn = ShellDelete(strPath & m_strFileName)
                        If Not m_vRtn = 0 Then
                            Print #2, "*** ERROR *** " & m_vRtn & " retruned from SHFileOperation; processes terminated"
                            Close #2
                            Exit Sub
                        End If
                    End If
                    
                    m_intNbrRecsDel = m_intNbrRecsDel + 1
                End If
            Else
                ' Print #2, "skipped, system, hidden, volume, or dir"
            End If
            
            .cFileName = ""
            
            ' find the next file in the directory...
            m_vRtn = FindNextFile(hFile, wfdFileData)
            ' Print #2, "------------------------------------------------------"
            If m_vRtn = 0 Then
                bEndOfDir = True
            End If
        End With
    Wend
    
    Print #2, "End directory: " & strPath
    Print #2,
    
    ' close the Find file functions
    Call FindClose(hFile)
    
    ' Delete directory...
    
    If m_bEmpty = True Then
        hFile = FindFirstFile(Left(strPath, Len(strPath) - 1), wfdFileData)
    
        If hFile = 0 Then
            Print #2, "*** ERROR with FindFirstFile function, processes aborted"
            Close #2
            Exit Sub
        End If
        
        m_dFileDate = GreatestFileDate(wfdFileData)
        m_strFileName = Left(wfdFileData.cFileName, InStr(1, wfdFileData.cFileName, m_strEmpty) - 1)
    
        ' Print #2, "dir name: " & wfdFileData.cFileName
        ' Print #2, "Directory name: " & m_strFileName & " date: " & m_dFileDate
    
        strMsg = Dir(strPath & "*.*")
        If strMsg = "" Then   ' Empty directory
            m_lngDays = DateDiff("d", m_dFileDate, m_dCurrDate)
            If m_lngDays > m_lngArgDays Then
                If m_bDeleteOn = True Then
                    Print #2, "Delete Directory: " & strPath
                Else
                    Print #2, "Directory eligible for deletion: " & strPath
                End If
                Print #2, "Compare date: " & m_dFileDate
                Print #2,
        
                If m_bDeleteOn = True Then
                    m_vRtn = ShellDelete(Left(strPath, Len(strPath) - 1))
                    If Not m_vRtn = 0 Then
                        Print #2, "*** ERROR *** " & m_vRtn & " retruned from SHFileOperation; processes terminated"
                        Close #2
                        Exit Sub
                    End If
                End If
                m_intNbrDirDel = m_intNbrDirDel + 1
            End If
        End If

        ' close the Find file functions
        Call FindClose(hFile)
    
        ' end test cwd 4/00
    End If
    
End Sub

Public Function ShellDelete(ParamArray vntFileName() As Variant)
    
' Standard code from the Microsoft web site

' This routine accepts and array of file names.  This program only passes single
' file name but the routine was left as-is because it is fairly standard.
' The shell file operation function is used to move files to the recycle bin.
    
    Dim i As Integer
    Dim sFileNames As String
    Dim SHFileOp As SHFILEOPSTRUCT
    ' Print #2, "ShellDelete"
    For i = LBound(vntFileName) To UBound(vntFileName)
        sFileNames = sFileNames & vntFileName(i) & vbNullChar
    Next
    
    sFileNames = sFileNames & vbNullChar
    ' Print #2, "sFileNames: " & sFileNames
    With SHFileOp
        .wFunc = FO_DELETE                                                      ' delete operation
        .pFrom = sFileNames                                                      ' file name
        .fFlags = FOF_ALLOWUNDO + FOF_NOCONFIRMATION    ' allow undo in windows recycle bin,
    End With                                                                             ' do not prompt user for confirmation
    
    ShellDelete = SHFileOperation(SHFileOp)
    
End Function

Public Function GreatestFileDate(wfd As WIN32_FIND_DATA) As Date

    ' NOTE: At one point the most recent of the three dates was used for comparison.
    '           This did not work because system back-ups cause the last access date
    '           to be a recent date.  This routine modified to simply return the
    '           creation date.

    ' determine the most recent file date...
    ' Print #2, "GreatestFileDate"
    With wfd
        If m_bCreateDate = True Then
            GreatestFileDate = FileTimeToDate(.ftCreationTime)
        Else
            GreatestFileDate = FileTimeToDate(.ftLastWriteTime)
        End If
        
'        If FileTimeToDate(.ftLastAccessTime) > GreatestFileDate Then
'            GreatestFileDate = FileTimeToDate(.ftLastAccessTime)
'        End If
        
'        If FileTimeToDate(.ftLastWriteTime) > GreatestFileDate Then
'            GreatestFileDate = FileTimeToDate(.ftLastWriteTime)
'        End If
        
    End With
End Function

Public Function FileTimeToDate(ftPassedFileTime As FILETIME) As Date
    Dim stDateTime As SYSTEMTIME
    Dim ftDateTime As FILETIME
    Dim Result As Long
    Dim strBuffer As String
    ' Print #2, "FileTimetoDate"
    ' use the Windows FileTime functions to convert Windows
    ' FILETIME data structure to vb date field.
    
    Result = FileTimeToLocalFileTime(ftPassedFileTime, ftDateTime)          ' convert passed filetime fields to LocalTime
    Result = FileTimeToSystemTime(ftDateTime, stDateTime)                   ' convert LocalTime to SystemTime
    
    ' concatenate date/time components into string
    
    With stDateTime
        strBuffer = Format(.wMonth) & "/"
        strBuffer = strBuffer & Format(.wDay) & "/"
        strBuffer = strBuffer & Format(.wYear) & " "
        strBuffer = strBuffer & Format(.wHour) & ":"
        strBuffer = strBuffer & Format(.wMinute, "00") & ":"
        strBuffer = strBuffer & Format(.wSecond, "00")
    End With
    ' Print #2, "strBuffer (before CDate): " & strBuffer
    ' convert string to date field
    FileTimeToDate = CDate(strBuffer)
    
    If Err.Number <> 0 Then
        Print #2, "Error in FileTimeToDate, err nbr: " & Err.Number
        FileTimeToDate = CDate("12/31/209912:00:00 AM")
    End If
    
End Function
