/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.jar;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.jar.JarFile;

class JarFileFactory {
    private static Map cache = new Hashtable();
    private static int BUF_SIZE = 2048;
    private HashMap permissions = new HashMap();
    private HashMap connections = new HashMap();
    private HashMap fileCache = new HashMap();

    JarFileFactory() {
    }

    private boolean isFileURL(URL uRL) {
        return uRL.getProtocol().equalsIgnoreCase("file");
    }

    public URLConnection getConnection(JarFile jarFile) {
        return (URLConnection)this.connections.get(jarFile);
    }

    public void cacheConnection(JarFile jarFile, URLConnection uRLConnection) {
        this.connections.put(jarFile, uRLConnection);
    }

    public Permission getPermission(JarFile jarFile) {
        return (Permission)this.permissions.get(jarFile);
    }

    public void cachePermission(JarFile jarFile, Permission permission) {
        this.permissions.put(jarFile, permission);
    }

    public JarFile get(URL uRL) throws IOException {
        JarFile jarFile = null;
        JarFile jarFile2 = null;
        if (this.isFileURL(uRL)) {
            Object object;
            String string = uRL.getHost();
            if (string != null && !string.equals("") && !string.equals("localhost")) {
                uRL = new URL("file", "", "//" + string + uRL.getPath());
            }
            JarFileFactory jarFileFactory = this;
            synchronized (jarFileFactory) {
                jarFile = (JarFile)this.fileCache.get(uRL);
            }
            if (jarFile == null) {
                jarFile2 = new JarFile(uRL.getFile());
                object = this;
                synchronized (object) {
                    jarFile = (JarFile)this.fileCache.get(uRL);
                    if (jarFile == null) {
                        this.fileCache.put(uRL, jarFile2);
                        jarFile = jarFile2;
                    } else if (jarFile2 != null) {
                        jarFile2.close();
                    }
                }
            }
            object = uRL.openConnection();
            Permission permission = ((URLConnection)object).getPermission();
            JarFileFactory jarFileFactory2 = this;
            synchronized (jarFileFactory2) {
                this.cachePermission(jarFile, permission);
                this.cacheConnection(jarFile, (URLConnection)object);
            }
        }
        JarFileFactory jarFileFactory = this;
        synchronized (jarFileFactory) {
            jarFile = this.getCachedJarFile(uRL);
        }
        if (jarFile == null) {
            jarFile2 = this.retrieve(uRL);
            JarFileFactory jarFileFactory3 = this;
            synchronized (jarFileFactory3) {
                jarFile = this.getCachedJarFile(uRL);
                if (jarFile == null) {
                    this.cacheJarFile(uRL, jarFile2);
                    jarFile = jarFile2;
                } else if (jarFile2 != null) {
                    jarFile2.close();
                }
            }
        }
        if (jarFile == null) {
            throw new FileNotFoundException(uRL.toString());
        }
        return jarFile;
    }

    void cacheJarFile(URL uRL, JarFile jarFile) {
        cache.put(uRL, jarFile);
    }

    JarFile getCachedJarFile(URL uRL) {
        SecurityManager securityManager;
        Permission permission;
        JarFile jarFile = (JarFile)cache.get(uRL);
        if (jarFile != null && (permission = this.getPermission(jarFile)) != null && (securityManager = System.getSecurityManager()) != null) {
            try {
                securityManager.checkPermission(permission);
            }
            catch (SecurityException securityException) {
                if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                    securityManager.checkRead(permission.getName());
                }
                if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
                throw securityException;
            }
        }
        return jarFile;
    }

    public JarFile retrieve(URL uRL) throws IOException {
        JarFile jarFile = null;
        final URLConnection uRLConnection = uRL.openConnection();
        Permission permission = null;
        permission = uRLConnection.getPermission();
        int n = uRLConnection.getContentLength();
        try {
            jarFile = (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public Object run() throws IOException {
                    TempJarFile tempJarFile;
                    OutputStream outputStream;
                    block4: {
                        InputStream inputStream = null;
                        outputStream = null;
                        try {
                            inputStream = uRLConnection.getInputStream();
                            File file = File.createTempFile("jar_cache", null);
                            outputStream = new FileOutputStream(file);
                            int n = 0;
                            byte[] byArray = new byte[BUF_SIZE];
                            while ((n = inputStream.read(byArray)) != -1) {
                                outputStream.write(byArray, 0, n);
                            }
                            outputStream.close();
                            tempJarFile = new TempJarFile(file);
                            Object var8_7 = null;
                            if (inputStream == null) break block4;
                        }
                        catch (Throwable throwable) {
                            Object var8_8 = null;
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            if (outputStream == null) throw throwable;
                            outputStream.close();
                            throw throwable;
                        }
                        inputStream.close();
                    }
                    if (outputStream == null) return tempJarFile;
                    outputStream.close();
                    return tempJarFile;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        if (jarFile != null) {
            this.cachePermission(jarFile, permission);
            this.cacheConnection(jarFile, uRLConnection);
        }
        return jarFile;
    }

    private static class TempJarFile
    extends JarFile {
        TempJarFile(File file) throws IOException {
            super(file, true, 5);
        }

        protected void finalize() throws IOException {
            this.close();
        }
    }
}

