/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;

public abstract class Calendar
implements Serializable,
Cloneable {
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int WEEK_OF_YEAR = 3;
    public static final int WEEK_OF_MONTH = 4;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_YEAR = 6;
    public static final int DAY_OF_WEEK = 7;
    public static final int DAY_OF_WEEK_IN_MONTH = 8;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int ZONE_OFFSET = 15;
    public static final int DST_OFFSET = 16;
    public static final int FIELD_COUNT = 17;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int UNDECIMBER = 12;
    public static final int AM = 0;
    public static final int PM = 1;
    protected int[] fields = new int[17];
    protected boolean[] isSet = new boolean[17];
    transient int[] stamp = new int[17];
    protected long time;
    protected boolean isTimeSet;
    protected boolean areFieldsSet;
    transient boolean areAllFieldsSet;
    private boolean lenient = true;
    private TimeZone zone;
    private int firstDayOfWeek;
    private int minimalDaysInFirstWeek;
    private static Hashtable cachedLocaleData = new Hashtable(3);
    static final int UNSET = 0;
    static final int INTERNALLY_SET = 1;
    static final int MINIMUM_USER_STAMP = 2;
    private int nextStamp = 2;
    static final int currentSerialVersion = 1;
    private int serialVersionOnStream = 1;
    static final long serialVersionUID = -1807547505821590642L;
    private static final String[] FIELD_NAME = new String[]{",ERA=", ",YEAR=", ",MONTH=", ",WEEK_OF_YEAR=", ",WEEK_OF_MONTH=", ",DAY_OF_MONTH=", ",DAY_OF_YEAR=", ",DAY_OF_WEEK=", ",DAY_OF_WEEK_IN_MONTH=", ",AM_PM=", ",HOUR=", ",HOUR_OF_DAY=", ",MINUTE=", ",SECOND=", ",MILLISECOND=", ",ZONE_OFFSET=", ",DST_OFFSET="};

    protected Calendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    protected Calendar(TimeZone timeZone, Locale locale) {
        this.zone = timeZone;
        this.setWeekCountData(locale);
    }

    public static synchronized Calendar getInstance() {
        return new GregorianCalendar();
    }

    public static synchronized Calendar getInstance(TimeZone timeZone) {
        return new GregorianCalendar(timeZone, Locale.getDefault());
    }

    public static synchronized Calendar getInstance(Locale locale) {
        return new GregorianCalendar(TimeZone.getDefault(), locale);
    }

    public static synchronized Calendar getInstance(TimeZone timeZone, Locale locale) {
        return new GregorianCalendar(timeZone, locale);
    }

    public static synchronized Locale[] getAvailableLocales() {
        return DateFormat.getAvailableLocales();
    }

    protected abstract void computeTime();

    protected abstract void computeFields();

    public final Date getTime() {
        return new Date(this.getTimeInMillis());
    }

    public final void setTime(Date date) {
        this.setTimeInMillis(date.getTime());
    }

    protected long getTimeInMillis() {
        if (!this.isTimeSet) {
            this.updateTime();
        }
        return this.time;
    }

    protected void setTimeInMillis(long l) {
        this.isTimeSet = true;
        this.time = l;
        this.areFieldsSet = false;
        if (!this.areFieldsSet) {
            this.computeFields();
            this.areFieldsSet = true;
            this.areAllFieldsSet = true;
        }
    }

    public final int get(int n) {
        this.complete();
        return this.fields[n];
    }

    protected final int internalGet(int n) {
        return this.fields[n];
    }

    final void internalSet(int n, int n2) {
        this.fields[n] = n2;
    }

    public final void set(int n, int n2) {
        this.isTimeSet = false;
        this.fields[n] = n2;
        ++this.nextStamp;
        this.areFieldsSet = false;
        this.isSet[n] = true;
    }

    public final void set(int n, int n2, int n3) {
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
    }

    public final void set(int n, int n2, int n3, int n4, int n5) {
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
    }

    public final void set(int n, int n2, int n3, int n4, int n5, int n6) {
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
        this.set(13, n6);
    }

    public final void clear() {
        this.fields = new int[17];
        this.stamp = new int[17];
        this.areFieldsSet = false;
        this.areAllFieldsSet = false;
        this.isSet = new boolean[17];
        this.isTimeSet = false;
    }

    public final void clear(int n) {
        this.fields[n] = 0;
        this.stamp[n] = 0;
        this.areFieldsSet = false;
        this.areAllFieldsSet = false;
        this.isSet[n] = false;
        this.isTimeSet = false;
    }

    public final boolean isSet(int n) {
        return this.stamp[n] != 0;
    }

    protected void complete() {
        if (!this.isTimeSet) {
            this.updateTime();
        }
        if (!this.areFieldsSet) {
            this.computeFields();
            this.areFieldsSet = true;
            this.areAllFieldsSet = true;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Calendar)) {
            return false;
        }
        Calendar calendar = (Calendar)object;
        return this.getTimeInMillis() == calendar.getTimeInMillis() && this.lenient == calendar.lenient && this.firstDayOfWeek == calendar.firstDayOfWeek && this.minimalDaysInFirstWeek == calendar.minimalDaysInFirstWeek && this.zone.equals(calendar.zone);
    }

    public int hashCode() {
        return (this.lenient ? 1 : 0) | this.firstDayOfWeek << 1 | this.minimalDaysInFirstWeek << 4 | this.zone.hashCode() << 7;
    }

    public boolean before(Object object) {
        return object instanceof Calendar && this.getTimeInMillis() < ((Calendar)object).getTimeInMillis();
    }

    public boolean after(Object object) {
        return object instanceof Calendar && this.getTimeInMillis() > ((Calendar)object).getTimeInMillis();
    }

    public abstract void add(int var1, int var2);

    public abstract void roll(int var1, boolean var2);

    public void roll(int n, int n2) {
        while (n2 > 0) {
            this.roll(n, true);
            --n2;
        }
        while (n2 < 0) {
            this.roll(n, false);
            ++n2;
        }
    }

    public void setTimeZone(TimeZone timeZone) {
        this.zone = timeZone;
        this.areFieldsSet = false;
    }

    public TimeZone getTimeZone() {
        return this.zone;
    }

    public void setLenient(boolean bl) {
        this.lenient = bl;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public void setFirstDayOfWeek(int n) {
        this.firstDayOfWeek = n;
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setMinimalDaysInFirstWeek(int n) {
        this.minimalDaysInFirstWeek = n;
    }

    public int getMinimalDaysInFirstWeek() {
        return this.minimalDaysInFirstWeek;
    }

    public abstract int getMinimum(int var1);

    public abstract int getMaximum(int var1);

    public abstract int getGreatestMinimum(int var1);

    public abstract int getLeastMaximum(int var1);

    public int getActualMinimum(int n) {
        int n2;
        int n3 = this.getGreatestMinimum(n);
        if (n3 == (n2 = this.getMinimum(n))) {
            return n3;
        }
        Calendar calendar = (Calendar)this.clone();
        calendar.setLenient(true);
        int n4 = n3;
        do {
            calendar.set(n, n3);
            if (calendar.get(n) != n3) break;
            n4 = n3--;
        } while (n3 >= n2);
        return n4;
    }

    public int getActualMaximum(int n) {
        int n2;
        int n3 = this.getLeastMaximum(n);
        if (n3 == (n2 = this.getMaximum(n))) {
            return n3;
        }
        Calendar calendar = (Calendar)this.clone();
        calendar.setLenient(true);
        if (n == 3 || n == 4) {
            calendar.set(7, this.firstDayOfWeek);
        }
        int n4 = n3;
        do {
            calendar.set(n, n3);
            if (calendar.get(n) != n3) break;
            n4 = n3++;
        } while (n3 <= n2);
        return n4;
    }

    public Object clone() {
        try {
            Calendar calendar = (Calendar)super.clone();
            calendar.fields = new int[17];
            calendar.isSet = new boolean[17];
            calendar.stamp = new int[17];
            System.arraycopy(this.fields, 0, calendar.fields, 0, 17);
            System.arraycopy(this.isSet, 0, calendar.isSet, 0, 17);
            System.arraycopy(this.stamp, 0, calendar.stamp, 0, 17);
            calendar.zone = (TimeZone)this.zone.clone();
            return calendar;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[time=");
        stringBuffer.append(this.isTimeSet ? String.valueOf(this.time) : "?");
        stringBuffer.append(",areFieldsSet=");
        stringBuffer.append(this.areFieldsSet);
        stringBuffer.append(",areAllFieldsSet=");
        stringBuffer.append(this.areAllFieldsSet);
        stringBuffer.append(",lenient=");
        stringBuffer.append(this.lenient);
        stringBuffer.append(",zone=");
        stringBuffer.append(this.zone);
        stringBuffer.append(",firstDayOfWeek=");
        stringBuffer.append(this.firstDayOfWeek);
        stringBuffer.append(",minimalDaysInFirstWeek=");
        stringBuffer.append(this.minimalDaysInFirstWeek);
        int n = 0;
        while (n < 17) {
            stringBuffer.append(FIELD_NAME[n]);
            stringBuffer.append(this.isSet(n) ? String.valueOf(this.fields[n]) : "?");
            ++n;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private void setWeekCountData(Locale locale) {
        int[] nArray = (int[])cachedLocaleData.get(locale);
        if (nArray == null) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale);
            String[] stringArray = resourceBundle.getStringArray("DateTimeElements");
            nArray = new int[]{Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1])};
            cachedLocaleData.put(locale, nArray);
        }
        this.firstDayOfWeek = nArray[0];
        this.minimalDaysInFirstWeek = nArray[1];
    }

    private void updateTime() {
        this.computeTime();
        if (this.isLenient() || !this.areAllFieldsSet) {
            this.areFieldsSet = false;
        }
        this.isTimeSet = true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (!this.isTimeSet) {
            try {
                this.updateTime();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.stamp = new int[17];
        if (this.serialVersionOnStream >= 2) {
            this.isTimeSet = true;
            if (this.fields == null) {
                this.fields = new int[17];
            }
            if (this.isSet == null) {
                this.isSet = new boolean[17];
            }
        } else if (this.serialVersionOnStream == 0) {
            int n = 0;
            while (n < 17) {
                this.stamp[n] = this.isSet[n] ? 1 : 0;
                ++n;
            }
        }
        this.serialVersionOnStream = 1;
    }
}

