/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.LookupTable;

public class ShortLookupTable
extends LookupTable {
    short[][] data;

    public ShortLookupTable(int n, short[][] sArray) {
        super(n, sArray.length);
        this.numComponents = sArray.length;
        this.numEntries = sArray[0].length;
        this.data = new short[this.numComponents][];
        int n2 = 0;
        while (n2 < this.numComponents) {
            this.data[n2] = sArray[n2];
            ++n2;
        }
    }

    public ShortLookupTable(int n, short[] sArray) {
        super(n, sArray.length);
        this.numComponents = 1;
        this.numEntries = sArray.length;
        this.data = new short[1][];
        this.data[0] = sArray;
    }

    public final short[][] getTable() {
        return this.data;
    }

    public int[] lookupPixel(int[] nArray, int[] nArray2) {
        if (nArray2 == null) {
            nArray2 = new int[nArray.length];
        }
        if (this.numComponents == 1) {
            int n = 0;
            while (n < nArray.length) {
                int n2 = (nArray[n] & 0xFFFF) - this.offset;
                if (n2 < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + n + "]-offset is " + "less than zero");
                }
                nArray2[n] = this.data[0][n2];
                ++n;
            }
        } else {
            int n = 0;
            while (n < nArray.length) {
                int n3 = (nArray[n] & 0xFFFF) - this.offset;
                if (n3 < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + n + "]-offset is " + "less than zero");
                }
                nArray2[n] = this.data[n][n3];
                ++n;
            }
        }
        return nArray2;
    }

    public short[] lookupPixel(short[] sArray, short[] sArray2) {
        if (sArray2 == null) {
            sArray2 = new short[sArray.length];
        }
        if (this.numComponents == 1) {
            int n = 0;
            while (n < sArray.length) {
                int n2 = (sArray[n] & 0xFFFF) - this.offset;
                if (n2 < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + n + "]-offset is " + "less than zero");
                }
                sArray2[n] = this.data[0][n2];
                ++n;
            }
        } else {
            int n = 0;
            while (n < sArray.length) {
                int n3 = (sArray[n] & 0xFFFF) - this.offset;
                if (n3 < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + n + "]-offset is " + "less than zero");
                }
                sArray2[n] = this.data[n][n3];
                ++n;
            }
        }
        return sArray2;
    }
}

