/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.Toolkit;
import java.awt.datatransfer.MimeType;
import java.awt.datatransfer.MimeTypeParameterList;
import java.awt.datatransfer.MimeTypeParseException;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.awt.SunToolkit;

public class DataFlavor
implements Externalizable,
Cloneable {
    static final long serialVersionUID = 8367026044764648243L;
    static final Class ioInputStreamClass = class$java$io$InputStream == null ? (class$java$io$InputStream = DataFlavor.class$("java.io.InputStream")) : class$java$io$InputStream;
    public static final DataFlavor stringFlavor = DataFlavor.createConstant(class$java$lang$String == null ? (class$java$lang$String = DataFlavor.class$("java.lang.String")) : class$java$lang$String, "Unicode String");
    public static final DataFlavor plainTextFlavor = DataFlavor.createConstant("text/plain; charset=unicode; class=java.io.InputStream", "Plain Text");
    public static final String javaSerializedObjectMimeType = "application/x-java-serialized-object";
    public static final DataFlavor javaFileListFlavor = DataFlavor.createConstant("application/x-java-file-list;class=java.util.List", null);
    public static final String javaJVMLocalObjectMimeType = "application/x-java-jvm-local-objectref";
    public static final String javaRemoteObjectMimeType = "application/x-java-remote-object";
    transient int atom;
    MimeType mimeType;
    private static String[] knownEncodings = new String[]{"iso8859-1", "us-ascii"};
    private String humanPresentableName;
    private Class representationClass;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$java$util$List;

    protected static final Class tryToLoadClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        ClassLoader classLoader2 = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                return classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
            }
        });
        try {
            return Class.forName(string, true, classLoader2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (classLoader != null) {
                return Class.forName(string, true, classLoader);
            }
            throw new ClassNotFoundException(string);
        }
    }

    private static DataFlavor createConstant(Class clazz, String string) {
        try {
            return new DataFlavor(clazz, string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static DataFlavor createConstant(String string, String string2) {
        try {
            return new DataFlavor(string, string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DataFlavor() {
    }

    DataFlavor(DataFlavor dataFlavor) {
        this.mimeType = null;
        if (dataFlavor.mimeType != null) {
            try {
                this.mimeType = (MimeType)dataFlavor.mimeType.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        this.representationClass = dataFlavor.representationClass;
        this.humanPresentableName = dataFlavor.humanPresentableName;
        this.atom = dataFlavor.atom;
    }

    private DataFlavor(String string, String string2, MimeTypeParameterList mimeTypeParameterList, Class clazz, String string3) {
        if (mimeTypeParameterList == null) {
            mimeTypeParameterList = new MimeTypeParameterList();
        }
        mimeTypeParameterList.set("class", clazz.getName());
        if (string3 == null && (string3 = mimeTypeParameterList.get("humanPresentableName")) == null) {
            string3 = string + "/" + string2;
        }
        try {
            this.mimeType = new MimeType(string, string2, mimeTypeParameterList);
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            throw new IllegalArgumentException("MimeType Parse Exception: " + mimeTypeParseException.getMessage());
        }
        this.representationClass = clazz;
        this.humanPresentableName = string3;
        this.mimeType.removeParameter("humanPresentableName");
    }

    public DataFlavor(Class clazz, String string) {
        this("application", "x-java-serialized-object", null, clazz, string);
    }

    public DataFlavor(String string, String string2) {
        try {
            this.initialize(string, string2, this.getClass().getClassLoader());
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            throw new IllegalArgumentException("failed to parse:" + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("cant find specified class: " + classNotFoundException.getMessage());
        }
    }

    public DataFlavor(String string, String string2, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            this.initialize(string, string2, classLoader);
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            throw new IllegalArgumentException("failed to parse:" + string);
        }
    }

    public DataFlavor(String string) throws ClassNotFoundException {
        try {
            this.initialize(string, null, this.getClass().getClassLoader());
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            throw new IllegalArgumentException("failed to parse:" + string);
        }
    }

    private void initialize(String string, String string2, ClassLoader classLoader) throws MimeTypeParseException, ClassNotFoundException {
        this.mimeType = new MimeType(string);
        String string3 = this.getParameter("class");
        if (string3 == null) {
            if (javaSerializedObjectMimeType.equals(this.mimeType.getBaseType())) {
                throw new IllegalArgumentException("no representation class specified for:" + string);
            }
            this.representationClass = class$java$io$InputStream == null ? (class$java$io$InputStream = DataFlavor.class$("java.io.InputStream")) : class$java$io$InputStream;
        } else {
            this.representationClass = DataFlavor.tryToLoadClass(string3, classLoader);
        }
        this.mimeType.setParameter("class", this.representationClass.getName());
        if (string2 == null && (string2 = this.mimeType.getParameter("humanPresentableName")) == null) {
            string2 = this.mimeType.getPrimaryType() + "/" + this.mimeType.getSubType();
        }
        this.humanPresentableName = string2;
        this.mimeType.removeParameter("humanPresentableName");
    }

    private DataFlavor(MimeType mimeType, Class clazz, String string, int n) {
        this.mimeType = mimeType;
        this.representationClass = clazz;
        this.humanPresentableName = string;
        this.atom = n;
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string + "[" + this.paramString() + "]";
        return string;
    }

    private String paramString() {
        String string = "";
        string = string + "representationclass=";
        string = this.representationClass == null ? string + "null" : string + this.representationClass.getName();
        string = string + ";mimetype=";
        string = this.mimeType == null ? string + "null" : string + this.mimeType.getBaseType();
        return string;
    }

    public static final DataFlavor getTextPlainUnicodeFlavor() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Object var1_1 = null;
        String string = null;
        if (toolkit instanceof SunToolkit) {
            string = ((SunToolkit)toolkit).getDefaultUnicodeEncoding();
        }
        return new DataFlavor("text/plain; charset=" + string + "; class=java.io.InputStream", "Plain Text");
    }

    public static final DataFlavor selectBestTextFlavor(DataFlavor[] dataFlavorArray) {
        if (dataFlavorArray == null) {
            return null;
        }
        DataFlavor dataFlavor = null;
        int n = 0;
        while (dataFlavor == null && n < dataFlavorArray.length) {
            DataFlavor dataFlavor2 = dataFlavorArray[n];
            if (dataFlavor2.match(stringFlavor)) {
                dataFlavor = dataFlavor2;
            } else {
                String string = dataFlavor2.getPrimaryType();
                if (string != null && "text".equals(string)) {
                    String string2 = dataFlavor2.getParameter("charset");
                    if (string2 == null) {
                        dataFlavor = dataFlavor2;
                    } else if (DataFlavor.encodingIsSupported(string2)) {
                        dataFlavor = dataFlavor2;
                    }
                }
            }
            ++n;
        }
        return dataFlavor;
    }

    public Reader getReaderForText(Transferable transferable) throws UnsupportedFlavorException, IOException {
        Object object = transferable.getTransferData(this);
        if (object == null) {
            throw new IllegalArgumentException("getTransferData() returned null");
        }
        boolean bl = object instanceof String;
        boolean bl2 = object instanceof InputStream;
        boolean bl3 = object instanceof Reader;
        if (!(bl || bl2 || bl3)) {
            throw new IllegalArgumentException("transfer data is not InputStream or String or Reader");
        }
        String string = this.getParameter("charset");
        InputStream inputStream = null;
        if (bl2) {
            inputStream = (InputStream)object;
        } else if (bl) {
            inputStream = string == null ? new ByteArrayInputStream(((String)object).getBytes()) : new ByteArrayInputStream(((String)object).getBytes(string));
        }
        Reader reader = null;
        reader = bl3 ? (Reader)object : (string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string));
        return reader;
    }

    public String getMimeType() {
        return this.mimeType.toString();
    }

    public Class getRepresentationClass() {
        return this.representationClass;
    }

    public String getHumanPresentableName() {
        return this.humanPresentableName;
    }

    public String getPrimaryType() {
        return this.mimeType.getPrimaryType();
    }

    public String getSubType() {
        return this.mimeType.getSubType();
    }

    public String getParameter(String string) {
        return string.equals("humanPresentableName") ? this.humanPresentableName : this.mimeType.getParameter(string);
    }

    public void setHumanPresentableName(String string) {
        this.humanPresentableName = string;
    }

    public boolean equals(Object object) {
        return object instanceof DataFlavor && this.equals((DataFlavor)object);
    }

    public boolean equals(DataFlavor dataFlavor) {
        if (dataFlavor == null) {
            return false;
        }
        if (this == dataFlavor) {
            return true;
        }
        if (this.representationClass == null ? dataFlavor.getRepresentationClass() != null : !this.representationClass.equals(dataFlavor.getRepresentationClass())) {
            return false;
        }
        if (this.mimeType == null ? dataFlavor.mimeType != null : !this.mimeType.match(dataFlavor.mimeType)) {
            return false;
        }
        if ("text".equals(this.getPrimaryType())) {
            String string = this.getTextCharset();
            String string2 = dataFlavor.getTextCharset();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(String string) {
        if (string == null || this.mimeType == null) {
            return false;
        }
        return this.isMimeTypeEqual(string);
    }

    public int hashCode() {
        int n;
        String string;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.representationClass != null) {
            n2 = this.representationClass.hashCode();
        }
        if (this.mimeType != null && (string = this.mimeType.getPrimaryType()) != null) {
            String string2;
            n3 = string.hashCode();
            if ("text".equals(string) && (string2 = this.getTextCharset()) != null) {
                n4 = string2.hashCode();
            }
        }
        return (n = n2 + n3 + n4) != 0 ? n : 25431009;
    }

    public boolean match(DataFlavor dataFlavor) {
        if (dataFlavor == null) {
            return false;
        }
        if (this.mimeType == null || dataFlavor.mimeType == null) {
            return false;
        }
        String string = this.getPrimaryType();
        String string2 = dataFlavor.getPrimaryType();
        if (string == null || string2 == null || !string.equals(string2)) {
            return false;
        }
        String string3 = this.getSubType();
        String string4 = dataFlavor.getSubType();
        if (string3 == null || string4 == null || !string3.equals(string4)) {
            return false;
        }
        Class clazz = this.getRepresentationClass();
        Class clazz2 = dataFlavor.getRepresentationClass();
        if (clazz == null || clazz2 == null || !clazz.equals(clazz2)) {
            return false;
        }
        if (string.equals("text")) {
            String string5 = this.getTextCharset();
            String string6 = dataFlavor.getTextCharset();
            if (string5 == null || string6 == null || !string5.equals(string6)) {
                return false;
            }
        }
        return true;
    }

    public boolean isMimeTypeEqual(String string) {
        if (this.mimeType == null || string == null) {
            return false;
        }
        try {
            return this.mimeType.match(new MimeType(string));
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            return false;
        }
    }

    public final boolean isMimeTypeEqual(DataFlavor dataFlavor) {
        return this.isMimeTypeEqual(dataFlavor.mimeType);
    }

    private boolean isMimeTypeEqual(MimeType mimeType) {
        return this.mimeType.match(mimeType);
    }

    public boolean isMimeTypeSerializedObject() {
        return this.isMimeTypeEqual(javaSerializedObjectMimeType);
    }

    public final Class getDefaultRepresentationClass() {
        return ioInputStreamClass;
    }

    public final String getDefaultRepresentationClassAsString() {
        return this.getDefaultRepresentationClass().getName();
    }

    public boolean isRepresentationClassInputStream() {
        return ioInputStreamClass.isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassSerializable() {
        return (class$java$io$Serializable == null ? (class$java$io$Serializable = DataFlavor.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassRemote() {
        return (class$java$rmi$Remote == null ? (class$java$rmi$Remote = DataFlavor.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(this.representationClass);
    }

    public boolean isFlavorSerializedObjectType() {
        return this.isRepresentationClassSerializable() && this.isMimeTypeEqual(javaSerializedObjectMimeType);
    }

    public boolean isFlavorRemoteObjectType() {
        return this.isRepresentationClassRemote() && this.isRepresentationClassSerializable() && this.isMimeTypeEqual(javaRemoteObjectMimeType);
    }

    public boolean isFlavorJavaFileListType() {
        if (this.mimeType == null || this.representationClass == null) {
            return false;
        }
        return (class$java$util$List == null ? (class$java$util$List = DataFlavor.class$("java.util.List")) : class$java$util$List).isAssignableFrom(this.representationClass) && this.mimeType.match(DataFlavor.javaFileListFlavor.mimeType);
    }

    public synchronized void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.mimeType.setParameter("humanPresentableName", this.humanPresentableName);
        objectOutput.writeObject(this.mimeType);
        this.mimeType.removeParameter("humanPresentableName");
    }

    public synchronized void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.mimeType = (MimeType)objectInput.readObject();
        this.humanPresentableName = this.mimeType.getParameter("humanPresentableName");
        this.mimeType.removeParameter("humanPresentableName");
        String string = this.mimeType.getParameter("class");
        if (string == null) {
            throw new IOException("no class parameter specified in: " + this.mimeType);
        }
        this.representationClass = DataFlavor.tryToLoadClass(string, this.getClass().getClassLoader());
    }

    public Object clone() throws CloneNotSupportedException {
        DataFlavor dataFlavor = new DataFlavor(this);
        return dataFlavor;
    }

    protected String normalizeMimeTypeParameter(String string, String string2) {
        return string2;
    }

    protected String normalizeMimeType(String string) {
        return string;
    }

    private String getTextCharset() {
        Toolkit toolkit;
        String string = null;
        if ("text".equals(this.getPrimaryType()) && (string = this.getParameter("charset")) == null && (toolkit = Toolkit.getDefaultToolkit()) instanceof SunToolkit) {
            string = ((SunToolkit)toolkit).getDefaultCharacterEncoding();
        }
        return string;
    }

    private static boolean encodingIsSupported(String string) {
        boolean bl = false;
        int n = 0;
        n = 0;
        while (!bl && n < knownEncodings.length) {
            if (knownEncodings[n].equals(string)) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            try {
                "abc".getBytes(string);
                bl = true;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

