/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.protocol.jdk12.http;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import sun.plugin.AppletViewer;
import sun.plugin.CacheHandler;
import sun.plugin.protocol.CookieHandler;
import sun.plugin.protocol.PluginProxyHandler;
import sun.plugin.protocol.ProxyInfo;
import sun.plugin.protocol.jdk12.http.Handler;
import sun.plugin.protocol.jdk12.http.HttpClient;

public class HttpURLConnection
extends sun.net.www.protocol.http.HttpURLConnection {
    protected String proxy = null;
    protected int proxyPort = -1;
    boolean failedOnce = false;
    static CookieHandler handler = null;
    private InputStream cacheStream = null;
    private static ResourceBundle rb;

    public HttpURLConnection(URL uRL, Handler handler) throws IOException {
        super(uRL, handler);
    }

    public HttpURLConnection(URL uRL, String string, int n) throws IOException {
        super(uRL, string, n);
        this.proxy = string;
        this.proxyPort = n;
    }

    public static void setCookieHandler(CookieHandler cookieHandler) {
        handler = cookieHandler;
    }

    protected boolean fromClassLoader() {
        Exception exception = new Exception();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        String string = byteArrayOutputStream.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!string2.startsWith("sun.applet.AppletClassLoader") && !string2.startsWith("sun.applet.AppletResourceLoader") && !string2.startsWith("sun.plugin.security.PluginClassLoader")) continue;
            return true;
        }
        return false;
    }

    protected boolean rightExt() {
        String string = this.url.getFile();
        return string.endsWith(".jar") | string.endsWith(".class");
    }

    void privBlock() throws Exception {
        this.http = "http".equals(this.url.getProtocol()) && !this.failedOnce ? HttpClient.New(this.url, this.proxy, this.proxyPort) : this.getProxiedClient(this.url, this.proxy, this.proxyPort);
        this.ps = (PrintStream)this.http.getOutputStream();
    }

    public synchronized void connect() throws IOException {
        Object object;
        Object object2;
        if (this.connected) {
            return;
        }
        if (this.proxy == null) {
            object2 = null;
            object = PluginProxyHandler.getDefaultProxyHandler();
            if (object != null && (object2 = object.getProxyInfo(this.url)) != null) {
                this.proxy = ((ProxyInfo)object2).getProxy();
                this.proxyPort = ((ProxyInfo)object2).getPort();
            }
        }
        if (AppletViewer.isTracingEnabled()) {
            object2 = HttpURLConnection.getMessage("opening_url") + this.url + " ";
            if (this.proxy == null) {
                object2 = (String)object2 + HttpURLConnection.getMessage("no_proxy");
            } else {
                object2 = (String)object2 + HttpURLConnection.getMessage("proxy_equals") + this.proxy;
                if (this.proxyPort != -1) {
                    object2 = (String)object2 + ":" + this.proxyPort;
                }
            }
            AppletViewer.debugTrace(object2);
        }
        if ((object2 = System.getSecurityManager()) != null) {
            ((SecurityManager)object2).checkConnect(this.url.getHost(), this.url.getPort());
        }
        if (handler != null && this.getRequestProperty("cookie") == null && (object = handler.getCookieInfo(this.url)) != null) {
            this.setRequestProperty("cookie", (String)object);
        }
        try {
            AccessController.doPrivileged(new PrivilegedBlockAction(this));
        }
        catch (PrivilegedActionException privilegedActionException) {
            IOException iOException = (IOException)privilegedActionException.getException();
            throw iOException;
        }
        this.setUseCaches(this.getUseCaches() && this.rightExt());
        this.connected = true;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.useCaches) {
            try {
                if (this.cacheStream != null) {
                    return this.cacheStream;
                }
                this.cacheStream = (InputStream)AccessController.doPrivileged(new FileCreator(this));
                if (this.cacheStream != null) {
                    return this.cacheStream;
                }
                this.useCaches = false;
            }
            catch (PrivilegedActionException privilegedActionException) {
                System.out.println("IO Exception, using remote copy");
                this.useCaches = false;
            }
            catch (SecurityException securityException) {
                System.out.println("Security exception, using remote copy");
                this.useCaches = false;
            }
        }
        return super.getInputStream();
    }

    protected sun.net.www.http.HttpClient getNewClient(URL uRL) throws IOException {
        this.failedOnce = true;
        return this.getProxiedClient(uRL, this.proxy, this.proxyPort);
    }

    protected sun.net.www.http.HttpClient getProxiedClient(URL uRL, String string, int n) throws IOException {
        return new HttpClient(uRL, string, n);
    }

    public static String getMessage(String string) {
        try {
            if (rb == null) {
                rb = ResourceBundle.getBundle("sun.plugin.resources.Activator");
            }
            return rb.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    class PrivilegedBlockAction
    implements PrivilegedExceptionAction {
        HttpURLConnection conn;

        PrivilegedBlockAction(HttpURLConnection httpURLConnection2) {
            this.conn = httpURLConnection2;
        }

        public Object run() throws Exception {
            this.conn.privBlock();
            return null;
        }
    }

    class FileCreator
    implements PrivilegedExceptionAction {
        HttpURLConnection conn;

        FileCreator(HttpURLConnection httpURLConnection2) {
            this.conn = httpURLConnection2;
        }

        public Object run() throws Exception {
            String string = CacheHandler.getCacheFile(this.conn.getURL());
            if (string != null) {
                return new BufferedInputStream(new FileInputStream(string));
            }
            return null;
        }
    }
}

