/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.io;

import com.sun.corba.se.internal.io.LoadLibraryAction;
import com.sun.corba.se.internal.util.JDKBridge;
import java.security.AccessController;

public class LibraryManager {
    private static boolean attempted = false;
    private static int majorVersion = 1;
    private static int minorVersion = 10;

    private static native int getMajorVersion();

    private static native int getMinorVersion();

    public static boolean load() {
        String string;
        try {
            if (LibraryManager.getMajorVersion() == majorVersion && LibraryManager.getMinorVersion() == minorVersion) {
                attempted = true;
                return true;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        try {
            string = "ioser";
            if (JDKBridge.is12VM()) {
                string = "ioser12";
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        try {
            string = "ioser12";
            try {
                AccessController.doPrivileged(new LoadLibraryAction(string));
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (!attempted) {
                    System.out.println("ERROR! Shared library " + string + " could not be found.");
                }
                throw unsatisfiedLinkError;
            }
            if (!(attempted || LibraryManager.getMajorVersion() == majorVersion && LibraryManager.getMinorVersion() == minorVersion)) {
                System.out.println("WARNING : The " + string + " library is not the correct version.");
                System.out.println("          Expected v" + majorVersion + "." + minorVersion + " but loaded v" + LibraryManager.getMajorVersion() + "." + LibraryManager.getMinorVersion() + "\n");
                System.out.println("          *** YOU ARE ADVISED TO USE EXPECTED VERSION ***");
            }
            attempted = true;
            return true;
        }
        catch (Error error) {
            attempted = true;
            return false;
        }
    }

    private static void enableOverride(String string, Object object) {
        try {
            LibraryManager.setEnableOverride(Class.forName(string), object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    private static native boolean setEnableOverride(Class var0, Object var1);
}

