/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import sunw.demo.classfile.Attribute;
import sunw.demo.classfile.ClassFile;
import sunw.demo.classfile.Code;
import sunw.demo.classfile.UTF8Constant;

final class MethodDesc {
    static final short ACC_PUBLIC = 1;
    static final short ACC_PRIVATE = 2;
    static final short ACC_PROTECTED = 4;
    static final short ACC_STATIC = 8;
    static final short ACC_FINAL = 16;
    static final short ACC_SYNCHRONIZED = 32;
    static final short ACC_NATIVE = 256;
    static final short ACC_ABSTRACT = 1024;
    private UTF8Constant name;
    private UTF8Constant descriptor;
    private short accessFlags;
    private ClassFile classFile;
    private Attribute[] attributes;

    MethodDesc(String string, String string2, short s, ClassFile classFile, Attribute[] attributeArray) {
        this.name = new UTF8Constant(string, classFile);
        this.descriptor = new UTF8Constant(string2, classFile);
        this.accessFlags = s;
        this.classFile = classFile;
        this.attributes = attributeArray;
    }

    MethodDesc(String string, String string2, short s, ClassFile classFile, Code code) {
        this.name = new UTF8Constant(string, classFile);
        this.descriptor = new UTF8Constant(string2, classFile);
        this.accessFlags = s;
        this.classFile = classFile;
        Attribute[] attributeArray = new Attribute[]{code};
        this.attributes = attributeArray;
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.accessFlags);
        dataOutputStream.writeShort(this.name.getConstantPoolIndex());
        dataOutputStream.writeShort(this.descriptor.getConstantPoolIndex());
        if (this.attributes != null && this.attributes.length > 0) {
            dataOutputStream.writeShort(this.attributes.length);
            int n = 0;
            while (n < this.attributes.length) {
                this.attributes[n].write(dataOutputStream);
                ++n;
            }
        } else {
            dataOutputStream.writeShort(0);
        }
    }
}

