/*
 * Decompiled with CFR 0.152.
 */
package Typing;

import Typing.CompString;
import Typing.MyTime;
import Typing.ResultDialog;
import Typing.TypingPractice;
import Typing.UpDown;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Random;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.AbstractBorder;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.SoftBevelBorder;

public class ExercisePane
extends JPanel {
    JTextArea article;
    JTextArea keyin;
    UpDown upDown;
    JButton load;
    JButton start;
    JButton toContinue;
    JButton pause;
    JButton stop;
    JLabel keyStoke;
    JLabel subject;
    JLabel totalWords;
    JLabel currentWords;
    JLabel ctrlStatus;
    JLabel timeStatus;
    TypingPractice mainApp;
    Connection connect;
    Timer countTime = null;
    MyTime timer;
    CountWords countWords = null;
    ArrayList aList = null;
    ResultDialog resultDialog = null;
    int rightWords = 0;
    int errorWords = 0;
    int totalKeyinWords = 0;
    float speed = 0.0f;
    int hitRate = 0;
    long fTime = 0L;
    long lTime = 0L;

    public ExercisePane(Connection connection, TypingPractice typingPractice) {
        this.connect = connection;
        this.mainApp = typingPractice;
        this.setLayout(new BorderLayout(2, 0));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EtchedBorder(1));
        Box box = Box.createVerticalBox();
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1, 0, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        this.article = new JTextArea(9, 50);
        this.article.setMargin(new Insets(0, 2, 0, 0));
        this.article.setEditable(false);
        this.article.setFocusable(false);
        this.article.setLineWrap(true);
        this.article.setWrapStyleWord(true);
        this.article.setBackground(new Color(128, 192, 192, 255));
        Font font = new Font("Serif", 1, 17);
        this.article.setFont(font);
        JSeparator jSeparator = new JSeparator(0);
        jSeparator.setMaximumSize(new Dimension(Integer.MAX_VALUE, jSeparator.getPreferredSize().height));
        this.keyin = new JTextArea(9, 50);
        this.keyin.setMargin(new Insets(0, 2, 0, 0));
        this.keyin.setFont(font);
        this.keyin.setLineWrap(true);
        this.keyin.setWrapStyleWord(true);
        this.keyin.setEditable(false);
        this.keyin.setBackground(new Color(102, 193, 122, 255));
        AbstractBorder abstractBorder = BorderFactory.createCompoundBorder(new BevelBorder(1), new EtchedBorder(0, Color.white, Color.black));
        jPanel3.add(new JScrollPane(this.article));
        jPanel3.add(Box.createVerticalStrut(4));
        jPanel3.add(new JScrollPane(this.keyin));
        this.add((Component)jPanel3, "Center");
        Dimension dimension = new Dimension(95, 95);
        JPanel jPanel4 = new JPanel();
        jPanel4.setPreferredSize(new Dimension(120, 75));
        jPanel4.setMaximumSize(new Dimension(120, 75));
        jPanel4.setMinimumSize(new Dimension(120, 75));
        this.upDown = new UpDown(0, 20);
        this.upDown.setToolTipText("Set exam time.(minutes)");
        this.upDown.setTextFieldFont(new Font("Serif", 1, 15));
        jPanel4.add(this.upDown);
        abstractBorder = BorderFactory.createTitledBorder("Exam time");
        jPanel4.setBorder(abstractBorder);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        Dimension dimension2 = new Dimension(95, 95);
        Border border = BorderFactory.createRaisedBevelBorder();
        EventHandler eventHandler = new EventHandler();
        this.load = new JButton("Load Article", this.createImageIcon("load.gif"));
        this.load.setMnemonic('L');
        font = this.load.getFont();
        font = font.deriveFont(0, 11.0f);
        this.load.setFont(font);
        this.load.setHorizontalTextPosition(0);
        this.load.setVerticalTextPosition(3);
        this.load.setPreferredSize(dimension);
        this.load.setMaximumSize(dimension2);
        this.load.setAlignmentX(0.5f);
        this.load.setToolTipText("Random load article");
        this.load.addActionListener(eventHandler);
        jPanel5.add(this.load);
        jPanel5.add(Box.createVerticalStrut(3));
        this.start = new JButton("Start exam", this.createImageIcon("keyboard.gif"));
        this.start.setMnemonic('S');
        this.start.setFont(font);
        this.start.setHorizontalTextPosition(0);
        this.start.setVerticalTextPosition(3);
        this.start.setPreferredSize(dimension);
        this.start.setMaximumSize(dimension2);
        this.start.setAlignmentX(0.5f);
        this.start.setToolTipText("Start exam");
        this.start.addActionListener(eventHandler);
        jPanel5.add(this.start);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        abstractBorder = BorderFactory.createTitledBorder("Control button");
        jPanel6.setBorder(abstractBorder);
        dimension = new Dimension(65, 65);
        dimension2 = new Dimension(65, 65);
        this.toContinue = new JButton("Resume", this.createImageIcon("continue.gif"));
        this.toContinue.setMnemonic('R');
        this.toContinue.setAlignmentX(0.5f);
        this.toContinue.setFont(font);
        this.toContinue.setPreferredSize(dimension);
        this.toContinue.setMaximumSize(dimension2);
        this.toContinue.setMinimumSize(dimension2);
        this.toContinue.setHorizontalTextPosition(0);
        this.toContinue.setVerticalTextPosition(3);
        this.toContinue.setToolTipText("Resume");
        this.toContinue.addActionListener(eventHandler);
        this.toContinue.setEnabled(false);
        jPanel6.add(this.toContinue);
        jPanel6.add(Box.createRigidArea(new Dimension(100, 0)));
        this.pause = new JButton("Pause", this.createImageIcon("pause.gif"));
        this.pause.setMnemonic('P');
        this.pause.setAlignmentX(0.5f);
        this.pause.setFont(font);
        this.pause.setPreferredSize(dimension);
        this.pause.setMaximumSize(dimension2);
        this.pause.setMinimumSize(dimension2);
        this.pause.setHorizontalTextPosition(0);
        this.pause.setVerticalTextPosition(3);
        this.pause.setToolTipText("Pause");
        this.pause.addActionListener(eventHandler);
        this.pause.setEnabled(false);
        jPanel6.add(this.pause);
        this.stop = new JButton("Stop", this.createImageIcon("stop.gif"));
        this.stop.setMnemonic('T');
        this.stop.setAlignmentX(0.5f);
        this.stop.setFont(font);
        this.stop.setPreferredSize(dimension);
        this.stop.setMaximumSize(dimension2);
        this.stop.setMinimumSize(dimension2);
        this.stop.setHorizontalTextPosition(0);
        this.stop.setVerticalTextPosition(3);
        this.stop.setToolTipText("Stop");
        this.stop.setEnabled(false);
        this.stop.addActionListener(eventHandler);
        jPanel6.add(this.stop);
        jPanel6.add(Box.createVerticalStrut(4));
        box.add(jPanel4);
        box.add(Box.createVerticalStrut(7));
        box.add(jPanel5);
        box.add(Box.createVerticalStrut(7));
        box.add(jPanel6);
        jPanel.add((Component)box, "Center");
        this.add((Component)jPanel, "East");
        JPanel jPanel7 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel7.setBorder(new EtchedBorder(1));
        border = new SoftBevelBorder(1);
        this.keyStoke = new JLabel();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 1, 2, 1);
        gridBagConstraints.fill = 1;
        jPanel7.add((Component)this.keyStoke, gridBagConstraints);
        this.subject = new JLabel();
        this.subject.setForeground(Color.black);
        this.subject.setPreferredSize(new Dimension(120, 20));
        this.subject.setMinimumSize(new Dimension(120, 20));
        this.subject.setBorder(border);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)this.subject, gridBagConstraints);
        this.totalWords = new JLabel();
        this.totalWords.setPreferredSize(new Dimension(120, 20));
        this.totalWords.setMinimumSize(new Dimension(120, 20));
        this.totalWords.setBorder(border);
        jPanel7.add((Component)this.totalWords, gridBagConstraints);
        this.currentWords = new JLabel();
        this.currentWords.setPreferredSize(new Dimension(180, 20));
        this.currentWords.setMinimumSize(new Dimension(180, 20));
        this.currentWords.setBorder(border);
        jPanel7.add((Component)this.currentWords, gridBagConstraints);
        this.ctrlStatus = new JLabel();
        this.ctrlStatus.setForeground(Color.red);
        this.ctrlStatus.setPreferredSize(new Dimension(70, 20));
        this.ctrlStatus.setMinimumSize(new Dimension(70, 20));
        this.ctrlStatus.setBorder(border);
        jPanel7.add((Component)this.ctrlStatus, gridBagConstraints);
        this.timeStatus = new JLabel();
        this.timeStatus.setForeground(Color.blue);
        this.timeStatus.setPreferredSize(new Dimension(140, 20));
        this.timeStatus.setMinimumSize(new Dimension(140, 20));
        this.timeStatus.setBorder(border);
        gridBagConstraints.gridwidth = 0;
        jPanel7.add((Component)this.timeStatus, gridBagConstraints);
        this.add((Component)jPanel7, "South");
    }

    private void clearFields() {
        this.article.setText("");
        this.keyin.setText("");
        this.upDown.setText("");
        this.keyStoke.setText("");
        this.subject.setText("");
        this.totalWords.setText("");
        this.currentWords.setText("");
        this.ctrlStatus.setText("");
        this.timeStatus.setText("");
    }

    private void setEnableCtrlButton(boolean bl) {
        this.toContinue.setEnabled(bl);
        this.pause.setEnabled(bl);
        this.stop.setEnabled(bl);
    }

    private void statisticsResult(float f) {
        boolean bl = true;
        boolean bl2 = true;
        String string = null;
        String string2 = null;
        this.rightWords = 0;
        this.errorWords = 0;
        this.speed = 0.0f;
        this.hitRate = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(this.article.getText());
        StringTokenizer stringTokenizer2 = new StringTokenizer(this.keyin.getText());
        this.totalKeyinWords = stringTokenizer2.countTokens();
        this.aList = new ArrayList();
        CompString compString = null;
        while (bl || bl2) {
            if (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            } else {
                string = null;
                bl = false;
            }
            if (stringTokenizer2.hasMoreTokens()) {
                string2 = stringTokenizer2.nextToken();
                if (string != null && string.equals(string2)) {
                    compString = new CompString(string2, false);
                    ++this.rightWords;
                    this.aList.add(compString);
                    continue;
                }
                compString = new CompString(string2, true);
                ++this.errorWords;
                this.aList.add(compString);
                continue;
            }
            string2 = null;
            bl2 = false;
        }
        if (!(f * 100.0f > 0.0f)) {
            f = 0.01f;
        }
        this.speed = (float)Math.round((float)this.rightWords / f * 100.0f) / 100.0f;
        if (this.totalKeyinWords != 0) {
            this.hitRate = (int)((float)this.rightWords / (float)this.totalKeyinWords * 100.0f);
        }
    }

    private ImageIcon createImageIcon(String string) {
        String string2 = "images/" + string;
        return new ImageIcon(this.getClass().getResource(string2));
    }

    static /* synthetic */ void access$400(ExercisePane exercisePane) {
        exercisePane.clearFields();
    }

    static /* synthetic */ void access$500(ExercisePane exercisePane, boolean bl) {
        exercisePane.setEnableCtrlButton(bl);
    }

    private class CountWords
    extends Thread {
        StringTokenizer tokens = null;
        boolean keepRunning = true;

        public void run() {
            try {
                while (this.keepRunning) {
                    this.tokens = new StringTokenizer(ExercisePane.this.keyin.getText());
                    ExercisePane.this.currentWords.setText("Current typing " + this.tokens.countTokens() + " words");
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public void pleaseStop() {
            this.keepRunning = false;
            this.interrupt();
        }
    }

    private class ActionTime
    implements ActionListener {
        private ActionTime() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExercisePane.this.timer.add(13, 1);
            ExercisePane.this.timeStatus.setText("Elapse time " + ExercisePane.this.timer.displayTime());
            if (Integer.parseInt(ExercisePane.this.upDown.getText()) == ExercisePane.this.timer.get(12)) {
                ExercisePane.this.countWords.pleaseStop();
                ExercisePane.this.countTime.stop();
                ExercisePane.this.ctrlStatus.setText("Ending");
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(ExercisePane.this, "Time it up !!", "Warning", 2);
                ExercisePane.this.lTime = ExercisePane.this.timer.getTimeInSecond();
                ExercisePane.this.statisticsResult((float)(ExercisePane.this.lTime - ExercisePane.this.fTime) / 60.0f);
                ExercisePane.this.resultDialog = new ResultDialog(ExercisePane.this.mainApp, ExercisePane.this.aList, ExercisePane.this.speed, ExercisePane.this.totalKeyinWords, ExercisePane.this.rightWords, ExercisePane.this.errorWords, ExercisePane.this.hitRate, ExercisePane.this.article.getSize(new Dimension()));
                ExercisePane.this.resultDialog.show();
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ ActionTime this$1;
                    {
                        this.this$1 = actionTime;
                    }

                    public void run() {
                        ExercisePane.access$400(ActionTime.access$600(this.this$1));
                        ActionTime.access$600((ActionTime)this.this$1).upDown.setEnabled(true);
                        ActionTime.access$600((ActionTime)this.this$1).upDown.clear();
                        ActionTime.access$600((ActionTime)this.this$1).load.setEnabled(true);
                        ActionTime.access$600((ActionTime)this.this$1).start.setEnabled(true);
                        ActionTime.access$600((ActionTime)this.this$1).keyin.setEditable(false);
                        ExercisePane.access$500(ActionTime.access$600(this.this$1), false);
                        ActionTime.access$600((ActionTime)this.this$1).upDown.requestFocus();
                    }
                });
                ExercisePane.this.resultDialog = null;
                ExercisePane.this.timer = null;
                ExercisePane.this.countWords = null;
            }
        }

        static /* synthetic */ ExercisePane access$600(ActionTime actionTime) {
            return actionTime.ExercisePane.this;
        }
    }

    private class EventHandler
    implements ActionListener {
        Toolkit toolkit = Toolkit.getDefaultToolkit();

        private EventHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ExercisePane.this.load) {
                if (ExercisePane.this.upDown.getText().equals("")) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(ExercisePane.this, "Please setting exam time.", "Warning", 2);
                    ExercisePane.this.upDown.requestFocus();
                    return;
                }
                try {
                    int n = 0;
                    StringTokenizer stringTokenizer = null;
                    Random random = new Random();
                    Statement statement = ExercisePane.this.connect.createStatement(1005, 1007);
                    ResultSet resultSet = statement.executeQuery("SELECT * FROM topic");
                    resultSet.last();
                    n = resultSet.getRow();
                    if (n == 0) {
                        this.toolkit.beep();
                        JOptionPane.showMessageDialog(ExercisePane.this, "Database no data", "Warning", 2);
                        return;
                    }
                    n = Math.abs(random.nextInt()) % n + 1;
                    resultSet.absolute(n);
                    String string = resultSet.getString(2);
                    stringTokenizer = new StringTokenizer(string);
                    ExercisePane.this.article.setText(string);
                    ExercisePane.this.keyStoke.setText("For Ending, press Alt+T");
                    ExercisePane.this.subject.setText("Subject no : " + resultSet.getString(1));
                    ExercisePane.this.totalWords.setText("All : " + stringTokenizer.countTokens() + " words");
                    statement.close();
                }
                catch (SQLException sQLException) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(ExercisePane.this, "Database error occurred:", "ERROR", 0);
                }
            } else if (actionEvent.getSource() == ExercisePane.this.start) {
                if (ExercisePane.this.upDown.getText().equals("")) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(ExercisePane.this, "Please setting exam time .", "Warning", 2);
                    ExercisePane.this.upDown.requestFocus();
                    return;
                }
                try {
                    int n = Integer.parseInt(ExercisePane.this.upDown.getText());
                    if (n <= 0) {
                        this.toolkit.beep();
                        JOptionPane.showMessageDialog(ExercisePane.this, "Must time large than zero .", "Error", 0);
                        ExercisePane.this.upDown.requestFocus();
                        return;
                    }
                }
                catch (Exception exception) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(ExercisePane.this, "Please enter riht number .", "Error", 0);
                    ExercisePane.this.upDown.requestFocus();
                    return;
                }
                if (ExercisePane.this.article.getText().equals("")) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(ExercisePane.this, "Please loading article .", "Warning", 2);
                    ExercisePane.this.load.requestFocus();
                    return;
                }
                ExercisePane.this.keyin.setEditable(true);
                ExercisePane.this.keyin.requestFocus();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ((EventHandler)this).ExercisePane.this.upDown.setEnabled(false);
                        ((EventHandler)this).ExercisePane.this.load.setEnabled(false);
                        ((EventHandler)this).ExercisePane.this.start.setEnabled(false);
                        ((EventHandler)this).ExercisePane.this.ctrlStatus.setText("Running");
                        ((EventHandler)this).ExercisePane.this.pause.setEnabled(true);
                        ((EventHandler)this).ExercisePane.this.stop.setEnabled(true);
                    }
                });
                ExercisePane.this.countWords = new CountWords();
                ExercisePane.this.countWords.start();
                ExercisePane.this.timer = new MyTime(0, 0, 0);
                ExercisePane.this.timeStatus.setText("Elapse time 00 : 00");
                ExercisePane.this.fTime = ExercisePane.this.timer.getTimeInSecond();
                ExercisePane.this.countTime = new Timer(1000, new ActionTime());
                ExercisePane.this.countTime.start();
            } else if (actionEvent.getSource() == ExercisePane.this.toContinue) {
                ExercisePane.this.countWords = new CountWords();
                ExercisePane.this.countWords.setPriority(Thread.currentThread().getPriority() - 2);
                ExercisePane.this.keyin.setEditable(true);
                ExercisePane.this.keyin.requestFocus();
                ExercisePane.this.countTime.restart();
                ExercisePane.this.countWords.start();
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ EventHandler this$1;
                    {
                        this.this$1 = eventHandler;
                    }

                    public void run() {
                        EventHandler.access$100((EventHandler)this.this$1).toContinue.setEnabled(false);
                        EventHandler.access$100((EventHandler)this.this$1).pause.setEnabled(true);
                        EventHandler.access$100((EventHandler)this.this$1).ctrlStatus.setText("Running");
                    }
                });
            } else if (actionEvent.getSource() == ExercisePane.this.pause) {
                ExercisePane.this.countTime.stop();
                ExercisePane.this.pause.setEnabled(false);
                ExercisePane.this.countWords.pleaseStop();
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ EventHandler this$1;
                    {
                        this.this$1 = eventHandler;
                    }

                    public void run() {
                        EventHandler.access$100((EventHandler)this.this$1).toContinue.setEnabled(true);
                        EventHandler.access$100((EventHandler)this.this$1).ctrlStatus.setText("Pause");
                        EventHandler.access$100((EventHandler)this.this$1).keyin.setEditable(false);
                    }
                });
            } else if (actionEvent.getSource() == ExercisePane.this.stop) {
                ExercisePane.this.countWords.pleaseStop();
                ExercisePane.this.countTime.stop();
                ExercisePane.this.ctrlStatus.setText("Ending");
                ExercisePane.this.lTime = ExercisePane.this.timer.getTimeInSecond();
                ExercisePane.this.statisticsResult((float)(ExercisePane.this.lTime - ExercisePane.this.fTime) / 60.0f);
                ExercisePane.this.resultDialog = new ResultDialog(ExercisePane.this.mainApp, ExercisePane.this.aList, ExercisePane.this.speed, ExercisePane.this.totalKeyinWords, ExercisePane.this.rightWords, ExercisePane.this.errorWords, ExercisePane.this.hitRate, ExercisePane.this.article.getSize(new Dimension()));
                ExercisePane.this.resultDialog.show();
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ EventHandler this$1;
                    {
                        this.this$1 = eventHandler;
                    }

                    public void run() {
                        ExercisePane.access$400(EventHandler.access$100(this.this$1));
                        EventHandler.access$100((EventHandler)this.this$1).upDown.setEnabled(true);
                        EventHandler.access$100((EventHandler)this.this$1).upDown.requestFocus();
                        EventHandler.access$100((EventHandler)this.this$1).upDown.clear();
                        EventHandler.access$100((EventHandler)this.this$1).load.setEnabled(true);
                        EventHandler.access$100((EventHandler)this.this$1).start.setEnabled(true);
                        EventHandler.access$100((EventHandler)this.this$1).keyin.setEditable(false);
                        ExercisePane.access$500(EventHandler.access$100(this.this$1), false);
                    }
                });
                ExercisePane.this.resultDialog = null;
                ExercisePane.this.countWords = null;
                ExercisePane.this.timer = null;
            }
        }
    }
}

