/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.ScrollPane;

class GSolidWindow
extends Dialog {
    public static final int RIGHT_INSET = 50;
    private GFrame frame;
    private GSolid solid;
    private GXYGrid xyGrid;
    private GSolidCanvas canvas;
    private static int initSize;

    public GSolidWindow(GFrame gFrame, GProblem gProblem, GSolid gSolid, double d, int n, boolean bl, boolean bl2) {
        super((Frame)gFrame, false);
        this.frame = gFrame;
        this.solid = gSolid;
        this.setTitle("Solid " + gSolid.getLabel());
        this.setInitSize();
        this.layBounds(n, d, bl);
        this.xyGrid = new GXYGrid();
        this.canvas = new GSolidCanvas(this.frame, gProblem, this, gSolid, this.xyGrid);
        this.updateContent(null);
        this.setScroller();
        this.addWindowListener(gProblem);
        this.addComponentListener(gProblem);
        if (bl2) {
            this.show();
        }
    }

    public static int getInitSize() {
        return initSize;
    }

    public void setInitSize() {
        Rectangle rectangle = this.frame.getSolidsArea();
        initSize = Math.min(rectangle.width - 50, rectangle.height - 50);
    }

    public void adjustBounds(boolean bl) {
        Rectangle rectangle = this.frame.getSolidsArea();
        if (bl) {
            ((Component)this).setBounds(rectangle);
        } else {
            Rectangle rectangle2 = this.getBounds();
            if (rectangle2.width > rectangle.width) {
                rectangle2.width = rectangle.width;
            }
            if (rectangle2.height > rectangle.height) {
                rectangle2.height = rectangle.height;
            }
            if (rectangle2.x < rectangle.x) {
                rectangle2.x = rectangle.x;
            }
            if (rectangle2.x + rectangle2.width > rectangle.x + rectangle.width) {
                rectangle2.x = rectangle.x + rectangle.width - rectangle2.width;
            }
            if (rectangle2.y < rectangle.y) {
                rectangle2.y = rectangle.y;
            }
            if (rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
                rectangle2.y = rectangle.y + rectangle.height - rectangle2.height;
            }
            ((Component)this).setBounds(rectangle2);
        }
        this.repaint();
    }

    public void layBounds(int n, double d, boolean bl) {
        Rectangle rectangle = this.frame.getSolidsArea();
        if (bl) {
            ((Component)this).setBounds(rectangle);
            this.setResizable(false);
            return;
        }
        int n2 = initSize - n;
        int n3 = initSize - n;
        GRectangle gRectangle = this.solid.uvBounds;
        if (d > 0.0) {
            n2 = Math.min(n2, (int)(d * (gRectangle.right - gRectangle.left) + 60.0));
            n3 = Math.min(n3, (int)(d * (gRectangle.top - gRectangle.bottom) + 60.0));
        }
        ((Component)this).setBounds(rectangle.x + n, rectangle.y + n, n2, n3);
    }

    public GSolid getSolid() {
        return this.solid;
    }

    public GXYGrid getXYGrid() {
        return this.xyGrid;
    }

    public GSolidCanvas getCanvas() {
        return this.canvas;
    }

    public void updateContent(GSolid gSolid) {
        if (gSolid != null) {
            this.solid = gSolid;
            this.canvas.setSolid(this.solid);
        }
        this.xyGrid.project(this.solid);
        this.canvas.repaint();
    }

    protected void setScroller() {
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.add(this.canvas);
        scrollPane.getVAdjustable().setUnitIncrement(10);
        scrollPane.getHAdjustable().setUnitIncrement(10);
        this.setLayout(new GridLayout(1, 1));
        this.add(scrollPane);
    }
}

