/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.Serializable;

public class GSolid
extends GShape
implements Serializable {
    public static final int TRANSPARENT = 0;
    public static final int POLYCHROME = 1;
    public static final int MONOCHROME = 2;
    public static final int TRANSFORM = 0;
    public static final int ADDVERTEX = 1;
    public static final int MAX_LABELSIZE = 3;
    public static final Color VERTEX_COLOR = Color.red;
    public static final Color EDGE_COLOR = Color.black;
    public static final Color DRAW_COLOR = Color.white;
    public static final Color SELECTCOLOR_TR = new Color(150, 50, 255);
    public static final Color SELECTCOLOR_OP = new Color(255, 150, 0);
    public static final Color LABEL_BACKGROUND = Color.lightGray;
    public static final GPoint3D LIGHT_VECTOR = new GPoint3D(-1.0, 3.0, 1.0);
    public static final String FACETPROMPT = "Facet Prompt";
    public static final int REVOLVE_STEP = 2;
    private static GFrame frame;
    private GProblem problem;
    private String label;
    private boolean labeled;
    private int viewMode;
    public GPalette palette;
    public GProjSystem initProjSystem;
    public transient GProjSystem projSystem;
    private transient double xyzDiameter;
    private transient GPoint3D center;
    private transient GPoint3D middle;
    public transient GRectangle uvBounds;
    private transient int cutCount;
    private transient GSolid transformBak;
    private transient GSolid addVertexBak;

    public GSolid(GFrame gFrame, GProblem gProblem, GShape gShape, String string) {
        frame = gFrame;
        this.problem = gProblem;
        this.initProjSystem = GProblem.projSystem.copy();
        if (gShape != null) {
            this.vertexList = gShape.vertexList;
            this.facetList = gShape.facetList;
            this.enforce();
        } else {
            this.projSystem = this.initProjSystem.copy();
            this.vertexList = new GVertexList();
            this.facetList = new GFacetList();
            this.center = new GPoint3D(0.0, 0.0, 0.0);
            this.middle = new GPoint3D(0.0, 0.0, 0.0);
            this.xyzDiameter = 1.0;
            this.uvBounds = new GRectangle();
        }
        this.label = string;
        this.cutCount = 0;
        this.labeled = true;
        this.viewMode = 0;
        this.palette = new GPalette(1);
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public boolean isLabeled() {
        return this.labeled;
    }

    public void setLabeled(boolean bl) {
        this.labeled = bl;
    }

    public int getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(int n) {
        this.viewMode = n;
        if (n != 1 && n != 2) {
            this.facetList.clearSelection(false, true);
        }
    }

    public boolean isRipe() {
        return this.facetList.getDim() > 3;
    }

    public double getXYZDiameter() {
        return this.xyzDiameter;
    }

    public boolean isTransformBacked() {
        return this.transformBak != null;
    }

    public boolean isAddVertexBacked() {
        return this.addVertexBak != null;
    }

    public GSolid getTransformBak() {
        this.transformBak.cutCount = this.cutCount;
        return this.transformBak;
    }

    public GSolid getAddVertexBak() {
        this.addVertexBak.cutCount = this.cutCount;
        return this.addVertexBak;
    }

    public void backupTransform() {
        GSolid gSolid = this.copy("");
        gSolid.transformBak = this.transformBak;
        gSolid.addVertexBak = this.addVertexBak;
        this.transformBak = gSolid;
        this.addVertexBak = null;
    }

    public void backupAddVertex() {
        GSolid gSolid = this.copy("");
        gSolid.addVertexBak = this.addVertexBak;
        gSolid.transformBak = this.transformBak;
        this.addVertexBak = gSolid;
        this.transformBak = null;
    }

    public void setCutCount(int n) {
        this.cutCount = n;
    }

    public String toString() {
        GVertexNode gVertexNode = this.vertexList.getHead();
        if (gVertexNode == null) {
            return "";
        }
        String string = new String();
        while (gVertexNode != null) {
            GVertex gVertex = gVertexNode.getVertex();
            if (!gVertex.isProper()) break;
            string = String.valueOf(string) + gVertex.getLabel();
            gVertexNode = gVertexNode.getNext();
        }
        return string;
    }

    public GSolid copy(String string) {
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        GVertexList gVertexList = new GVertexList();
        GVertexNode gVertexNode = this.vertexList.getHead();
        while (gVertexNode != null) {
            serializable3 = gVertexNode.getVertex();
            serializable2 = new GVertex(new GPoint3D(((GVertex)serializable3).xyzCrds), ((GVertex)serializable3).getLabel(), ((GVertex)serializable3).isProper());
            ((GVertex)serializable2).setPeer((GVertex)serializable3);
            ((GVertex)serializable3).setPeer((GVertex)serializable2);
            gVertexList.addToTail((GVertex)serializable2);
            gVertexNode = gVertexNode.getNext();
        }
        serializable3 = new GFacetList();
        serializable2 = this.facetList.getHead();
        while (serializable2 != null) {
            Serializable serializable4;
            serializable = ((GFacetNode)serializable2).getFacet();
            GEdgeList gEdgeList = new GEdgeList();
            GEdgeNode gEdgeNode = ((GFacet)serializable).edgeList.getHead();
            while (gEdgeNode != null) {
                serializable4 = gEdgeNode.getEdge();
                GVertexList gVertexList2 = new GVertexList();
                GVertexNode gVertexNode2 = serializable4.vertexList.getHead();
                while (gVertexNode2 != null) {
                    gVertexList2.addToTail(gVertexNode2.getVertex().getPeer());
                    gVertexNode2 = gVertexNode2.getNext();
                }
                GEdge gEdge = new GEdge(gVertexList2, null);
                gEdgeList.addToTail(gEdge);
                gEdgeNode = gEdgeNode.getNext();
            }
            serializable4 = new GFacet(gEdgeList, ((GFacet)serializable).getColor());
            ((GFacetList)serializable3).addToTail((GFacet)serializable4);
            serializable2 = ((GFacetNode)serializable2).getNext();
        }
        ((GFacetList)serializable3).buildEdgeWingsTwins();
        ((GFacetList)serializable3).buildEdgeStars();
        serializable = new GSolid(frame, this.problem, null, string);
        ((GShape)serializable).facetList = serializable3;
        ((GShape)serializable).vertexList = gVertexList;
        ((GSolid)serializable).center = new GPoint3D(this.center);
        ((GSolid)serializable).middle = new GPoint3D(this.middle);
        ((GSolid)serializable).xyzDiameter = this.xyzDiameter;
        ((GSolid)serializable).initProjSystem = this.initProjSystem.copy();
        ((GSolid)serializable).projSystem = this.projSystem.copy();
        ((GSolid)serializable).project();
        ((GSolid)serializable).labeled = this.labeled;
        ((GSolid)serializable).viewMode = this.viewMode;
        ((GSolid)serializable).palette = new GPalette(this.palette.getBasicColor());
        ((GSolid)serializable).cutCount = this.cutCount;
        return serializable;
    }

    public void enforce() {
        this.projSystem = this.initProjSystem.copy();
        this.computeCenter();
        this.facetList.buildEdgeWingsTwins();
        this.facetList.buildEdgeStars();
        this.facetList.initTempEdges();
        this.project();
    }

    public GPoint3D computeCenter() {
        if (this.vertexList.getDim() == 0) {
            return null;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = Double.POSITIVE_INFINITY;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = Double.POSITIVE_INFINITY;
        double d7 = Double.NEGATIVE_INFINITY;
        double d8 = Double.NEGATIVE_INFINITY;
        double d9 = Double.NEGATIVE_INFINITY;
        int n = 0;
        GVertexNode gVertexNode = this.vertexList.getHead();
        while (gVertexNode != null && gVertexNode.getVertex().isProper()) {
            GPoint3D gPoint3D = gVertexNode.getVertex().xyzCrds;
            d += gPoint3D.X;
            d2 += gPoint3D.Y;
            d3 += gPoint3D.Z;
            d6 = Math.min(d6, gPoint3D.X);
            d5 = Math.min(d5, gPoint3D.Y);
            d4 = Math.min(d4, gPoint3D.Z);
            d9 = Math.max(d9, gPoint3D.X);
            d8 = Math.max(d8, gPoint3D.Y);
            d7 = Math.max(d7, gPoint3D.Z);
            ++n;
            gVertexNode = gVertexNode.getNext();
        }
        this.center = new GPoint3D(d / (double)n, d2 / (double)n, d3 / (double)n);
        this.xyzDiameter = Math.sqrt((d9 - d6) * (d9 - d6) + (d8 - d5) * (d8 - d5) + (d7 - d4) * (d7 - d4));
        this.middle = new GPoint3D((d6 + d9) / 2.0, (d5 + d8) / 2.0, (d4 + d7) / 2.0);
        this.initProjSystem.setCenter(this.middle);
        this.projSystem.setCenter(this.middle);
        return this.center;
    }

    public GShape toShape() {
        GShape gShape = new GShape();
        gShape.vertexList = this.vertexList;
        gShape.facetList = this.facetList;
        return gShape;
    }

    public GPoint3D getCenter() {
        return this.center;
    }

    public double computeVolume() {
        GFacetNode gFacetNode = this.facetList.getHead();
        double d = 0.0;
        while (gFacetNode != null) {
            GFacet gFacet = gFacetNode.getFacet();
            d += gFacet.computeArea() * GMath.distance(this.center, gFacet);
            gFacetNode = gFacetNode.getNext();
        }
        return d / 3.0;
    }

    public void project() {
        this.uvBounds = new GRectangle();
        GVertexNode gVertexNode = this.vertexList.getHead();
        while (gVertexNode != null) {
            GPoint3D gPoint3D = gVertexNode.getVertex().project(this.projSystem);
            this.uvBounds = new GRectangle(Math.min(this.uvBounds.left, gPoint3D.X), Math.max(this.uvBounds.right, gPoint3D.X), Math.min(this.uvBounds.bottom, gPoint3D.Y), Math.max(this.uvBounds.top, gPoint3D.Y));
            gVertexNode = gVertexNode.getNext();
        }
    }

    public void revolve(int n) {
        GPoint3D gPoint3D = GProblem.projSystem.getJ();
        GPoint3D gPoint3D2 = GProblem.projSystem.getK();
        switch (n) {
            case 39: {
                this.projSystem.revolve(2, gPoint3D2);
                break;
            }
            case 37: {
                this.projSystem.revolve(-2, gPoint3D2);
                break;
            }
            case 40: {
                this.projSystem.revolve(2, gPoint3D);
                break;
            }
            case 38: {
                this.projSystem.revolve(-2, gPoint3D);
            }
        }
        this.project();
    }

    public boolean hasInitAttitude() {
        return this.projSystem.equals(this.initProjSystem);
    }

    public void initAttitude() {
        this.projSystem = this.initProjSystem.copy();
    }

    public void setAttAsInitial() {
        this.initProjSystem = this.projSystem.copy();
    }

    protected GPoint3D uvToSurface(GPoint3D gPoint3D) {
        return null;
    }

    public Object addVertex(GPoint3D gPoint3D, String string) {
        GVertex gVertex = this.badNewVertex(gPoint3D);
        if (gVertex != null) {
            return "Vertex exists in Solid " + this.label + " : " + gVertex.getLabel();
        }
        String string2 = this.badNewLabel(string);
        if (string2 != null) {
            return string2;
        }
        this.backupAddVertex();
        GLabelList gLabelList = this.vertexList.toLabelList();
        gVertex = new GVertex(gPoint3D, string, true);
        if (this.vertexList.getDim() == 0) {
            this.vertexList.addToTail(gVertex);
            this.computeCenter();
        } else if (this.vertexList.getDim() == 1) {
            this.vertexList.getHead().getVertex();
            this.vertexList.addToTail(gVertex);
            this.computeCenter();
        } else if (this.vertexList.getDim() == 2) {
            GVertex gVertex2;
            GVertex gVertex3 = this.vertexList.getHead().getVertex();
            GEdge gEdge = new GEdge(gVertex3, gVertex2 = this.vertexList.getTail().getVertex());
            GEdge gEdge2 = gEdge.engross(gVertex);
            if (gEdge2 != null) {
                this.vertexList.flush();
                this.vertexList.addToTail(gEdge2.getHead());
                this.vertexList.addToTail(gEdge2.getTail());
            } else {
                this.vertexList.addToTail(gVertex);
                this.facetList.addToTail(this.buildFacet(gVertex, gEdge));
            }
            this.computeCenter();
        } else if (!this.isRipe()) {
            GFacet gFacet = this.facetList.getHead().getFacet();
            GFacet gFacet2 = gFacet.engross(gVertex, false);
            if (gFacet2 == gFacet) {
                return "Solid " + this.label + " already contains " + string;
            }
            if (gFacet2 != null) {
                this.facetList.flush();
                this.facetList.addToTail(gFacet2);
                this.vertexList = this.facetList.getVertexList();
            } else {
                this.vertexList.addToTail(gVertex);
                GEdgeNode gEdgeNode = gFacet.edgeList.getHead();
                while (gEdgeNode != null) {
                    GEdge gEdge = gEdgeNode.getEdge();
                    this.facetList.addToTail(this.buildFacet(gVertex, gEdge));
                    gEdgeNode = gEdgeNode.getNext();
                }
                this.computeCenter();
                this.orient();
            }
        } else {
            GFacet gFacet;
            GFacetList gFacetList = new GFacetList();
            GFacetList gFacetList2 = new GFacetList();
            GFacetList gFacetList3 = new GFacetList();
            GFacetNode gFacetNode = this.facetList.getHead();
            while (gFacetNode != null) {
                gFacet = gFacetNode.getFacet();
                switch (gFacet.getAttitude(gPoint3D)) {
                    case 1: {
                        gFacetList3.addToTail(gFacet);
                        break;
                    }
                    case 0: {
                        gFacetList2.addToTail(gFacet);
                        break;
                    }
                    case -1: {
                        gFacetList.addToTail(gFacet);
                    }
                }
                gFacetNode = gFacetNode.getNext();
            }
            if (gFacetList3.getHead() == null) {
                return "Solid " + this.label + " already contains " + string;
            }
            this.facetList.flush();
            gFacetNode = gFacetList2.getHead();
            while (gFacetNode != null) {
                this.facetList.addToTail(gFacetNode.getFacet().engross(gVertex, true));
                gFacetNode = gFacetNode.getNext();
            }
            gFacetNode = gFacetList.getHead();
            while (gFacetNode != null) {
                gFacet = gFacetNode.getFacet();
                this.facetList.addToTail(gFacet);
                GEdgeNode gEdgeNode = gFacet.edgeList.getHead();
                while (gEdgeNode != null) {
                    GEdge gEdge = gEdgeNode.getEdge();
                    if (gFacetList3.seek(gEdge.wing2)) {
                        this.facetList.addToTail(this.buildFacet(gVertex, gEdge));
                    }
                    gEdgeNode = gEdgeNode.getNext();
                }
                gFacetNode = gFacetNode.getNext();
            }
            this.vertexList = this.facetList.getVertexList();
            this.computeCenter();
            this.orient();
        }
        this.facetList.buildEdgeWingsTwins();
        this.facetList.buildEdgeStars();
        this.project();
        return gLabelList.subtract(this.vertexList);
    }

    public void orient() {
        if (!this.isRipe()) {
            return;
        }
        GFacetNode gFacetNode = this.facetList.getHead();
        while (gFacetNode != null) {
            GFacet gFacet = gFacetNode.getFacet();
            gFacet.orient(this.center, -1);
            gFacetNode = gFacetNode.getNext();
        }
    }

    protected GFacet buildFacet(GVertex gVertex, GEdge gEdge) {
        if (gEdge.engross(gVertex) != null) {
            return null;
        }
        GEdgeList gEdgeList = new GEdgeList();
        GVertex gVertex2 = gEdge.getHead();
        GVertex gVertex3 = gEdge.getTail();
        gEdgeList.addToTail(new GEdge(gVertex3, gVertex2));
        gEdgeList.addToTail(new GEdge(gVertex2, gVertex));
        gEdgeList.addToTail(new GEdge(gVertex, gVertex3));
        return new GFacet(gEdgeList, this.palette.newColor());
    }

    protected GVertex badNewVertex(GPoint3D gPoint3D) {
        GVertex gVertex = this.vertexList.seek(gPoint3D, this.xyzDiameter);
        if (gVertex != null) {
            return gVertex;
        }
        return null;
    }

    protected String badNewLabel(String string) {
        if (this.vertexList.seek(string) != null) {
            return "Solid " + this.label + " : Label " + string + " in use";
        }
        if (string.length() > 3 || string.charAt(0) < 'A' || string.charAt(0) > 'Z' || string.length() > 1 && (string.charAt(1) < '1' || string.charAt(1) > '9') || string.length() > 2 && (string.charAt(2) < '1' || string.charAt(2) > '9')) {
            return "Accepted label formats: A, B1, C24";
        }
        return null;
    }

    public void paint(GSolidCanvas gSolidCanvas) {
        Serializable serializable;
        GFacet gFacet;
        GFacetNode gFacetNode;
        if (this.vertexList.getDim() == 0) {
            return;
        }
        if (this.facetList.getDim() == 0) {
            GVertexNode gVertexNode = this.vertexList.getHead();
            while (gVertexNode != null) {
                GVertex gVertex = gVertexNode.getVertex();
                gSolidCanvas.paint(gVertex, VERTEX_COLOR);
                if (this.labeled) {
                    gSolidCanvas.fitLabel(gVertex, null);
                }
                gVertexNode = gVertexNode.getNext();
            }
            return;
        }
        switch (this.viewMode) {
            case 1: {
                gFacetNode = this.facetList.getHead();
                while (gFacetNode != null) {
                    gFacet = gFacetNode.getFacet();
                    if (!this.isRipe() || gFacet.getVisibility() == 1) {
                        if (gFacet.isSelected()) {
                            gSolidCanvas.paint(gFacet, this.getSelectColor());
                        } else {
                            gSolidCanvas.paint(gFacet);
                        }
                    }
                    gFacetNode = gFacetNode.getNext();
                }
                break;
            }
            case 2: {
                gFacetNode = this.facetList.getHead();
                while (gFacetNode != null) {
                    gFacet = gFacetNode.getFacet();
                    if (!this.isRipe() || gFacet.getVisibility() == 1) {
                        if (gFacet.isSelected()) {
                            gSolidCanvas.paint(gFacet, this.getSelectColor());
                        } else {
                            serializable = gFacet.getUVWNormal();
                            double d = GMath.angle(LIGHT_VECTOR, (GPoint3D)serializable);
                            if (!this.isRipe()) {
                                d = Math.min(d, Math.PI - d);
                            }
                            double d2 = 1.0 - 2.0 * d / Math.PI;
                            gSolidCanvas.paint(gFacet, this.palette.getHue(d2));
                        }
                    }
                    gFacetNode = gFacetNode.getNext();
                }
                break;
            }
        }
        this.facetList.unmarkAllEdges();
        gFacetNode = this.facetList.getHead();
        while (gFacetNode != null) {
            gFacet = gFacetNode.getFacet();
            serializable = gFacet.edgeList.getHead();
            while (serializable != null) {
                GEdge gEdge = ((GEdgeNode)serializable).getEdge();
                if (!gEdge.isMarked()) {
                    if (gFacet.getVisibility() == 1 || !this.isRipe()) {
                        if (gEdge.isSelected()) {
                            gSolidCanvas.paint(gEdge, this.getSelectColor(), 1);
                            gEdge.setMarked(true);
                        } else if (this.viewMode == 0) {
                            gSolidCanvas.paint(gEdge, EDGE_COLOR, 0);
                            gEdge.setMarked(true);
                        } else if (gEdge.wing2 == null) {
                            gSolidCanvas.paint(gEdge, DRAW_COLOR, 0);
                            gEdge.setMarked(true);
                        }
                    } else if (this.viewMode == 0 && gFacet.getVisibility() == -1) {
                        if (gEdge.isSelected()) {
                            gSolidCanvas.paint(gEdge, this.getSelectColor(), 1);
                            gEdge.setMarked(true);
                        } else if (gEdge.wing2 == null || gEdge.wing2.getVisibility() == -1) {
                            gSolidCanvas.paint(gEdge, EDGE_COLOR, 2);
                            gEdge.setMarked(true);
                        }
                    }
                }
                serializable = ((GEdgeNode)serializable).getNext();
            }
            serializable = gFacet.tempEdges.getHead();
            while (serializable != null) {
                GEdge gEdge = ((GEdgeNode)serializable).getEdge();
                if (this.viewMode == 0 || gFacet.getVisibility() == 1) {
                    gSolidCanvas.paint(gEdge, this.getSelectColor(), 1);
                }
                serializable = ((GEdgeNode)serializable).getNext();
            }
            gFacetNode = gFacetNode.getNext();
        }
        this.unmarkAllVertices();
        this.facetList.unmarkAllEdges();
        gFacetNode = this.facetList.getHead();
        while (gFacetNode != null) {
            gFacet = gFacetNode.getFacet();
            if (this.viewMode == 0 || gFacet.getVisibility() == 1 || !this.isRipe()) {
                serializable = gFacet.edgeList.getHead();
                while (serializable != null) {
                    GEdge gEdge = ((GEdgeNode)serializable).getEdge();
                    if (!gEdge.isMarked()) {
                        GVertexNode gVertexNode = gEdge.vertexList.getHead();
                        while (gVertexNode != null) {
                            GVertex gVertex = gVertexNode.getVertex();
                            if (!gVertex.isMarked()) {
                                if (gVertex.isSelected()) {
                                    gSolidCanvas.paint(gVertex, this.getSelectColor());
                                } else if (this.viewMode == 0) {
                                    gSolidCanvas.paint(gVertex, VERTEX_COLOR);
                                } else if (!gVertex.isProper()) {
                                    gSolidCanvas.paint(gVertex, DRAW_COLOR);
                                }
                                if (this.labeled) {
                                    gSolidCanvas.fitLabel(gVertex, this.getLabelBackground());
                                }
                                gVertex.setMarked(true);
                            }
                            gVertexNode = gVertexNode.getNext();
                        }
                        gEdge.setMarked(true);
                    }
                    serializable = ((GEdgeNode)serializable).getNext();
                }
            }
            gFacetNode = gFacetNode.getNext();
        }
    }

    public void stretch(GPoint3D gPoint3D) {
        if (this.vertexList.getDim() == 0) {
            return;
        }
        this.backupTransform();
        this.vertexList.stretch(gPoint3D);
        this.computeCenter();
        this.project();
    }

    public void skew(GPoint3D gPoint3D) {
        GVertexNode gVertexNode = this.vertexList.getHead();
        if (gVertexNode == null) {
            return;
        }
        this.backupTransform();
        while (gVertexNode != null) {
            gVertexNode.getVertex().skew(gPoint3D);
            gVertexNode = gVertexNode.getNext();
        }
        this.computeCenter();
        this.project();
    }

    public GPoint3D getZExtent() {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        GVertexNode gVertexNode = this.vertexList.getHead();
        while (gVertexNode != null && gVertexNode.getVertex().isProper()) {
            GVertex gVertex = gVertexNode.getVertex();
            d = Math.min(d, gVertex.xyzCrds.Z);
            d2 = Math.max(d2, gVertex.xyzCrds.Z);
            gVertexNode = gVertexNode.getNext();
        }
        return new GPoint3D(d, d2, 0.0);
    }

    public void clearSelection(boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            this.vertexList.clearSelection();
        }
        this.facetList.clearSelection(bl2, bl3);
    }

    public Object select(GPoint3D gPoint3D, double d, boolean bl) {
        Serializable serializable;
        GEdge gEdge;
        Serializable serializable2;
        GFacet gFacet;
        this.unmarkAllVertices();
        this.facetList.unmarkAllEdges();
        GFacetNode gFacetNode = this.facetList.getHead();
        while (gFacetNode != null) {
            gFacet = gFacetNode.getFacet();
            if (this.viewMode == 0 || gFacet.getVisibility() == 1) {
                serializable2 = gFacetNode.getFacet().edgeList.getHead();
                while (serializable2 != null) {
                    gEdge = serializable2.getEdge();
                    if (!gEdge.isMarked()) {
                        serializable = gEdge.vertexList.getHead();
                        while (serializable != null) {
                            GVertex gVertex = serializable.getVertex();
                            if (!gVertex.isMarked()) {
                                if (GMath.adhere(gPoint3D, gVertex.xyzCrds, this.projSystem, d)) {
                                    boolean bl2 = gVertex.isSelected();
                                    if (!bl) {
                                        this.clearSelection(true, true, true);
                                    }
                                    gVertex.setSelected(!bl2);
                                    return gVertex;
                                }
                                gVertex.setMarked(true);
                            }
                            serializable = serializable.getNext();
                        }
                        gEdge.setMarked(true);
                    }
                    serializable2 = serializable2.getNext();
                }
            }
            gFacetNode = gFacetNode.getNext();
        }
        this.facetList.unmarkAllEdges();
        gFacetNode = this.facetList.getHead();
        while (gFacetNode != null) {
            gFacet = gFacetNode.getFacet();
            if (this.viewMode == 0 || gFacet.getVisibility() == 1) {
                serializable2 = gFacet.edgeList.getHead();
                while (serializable2 != null) {
                    gEdge = serializable2.getEdge();
                    if (!gEdge.isMarked()) {
                        serializable = GMath.adhere(gPoint3D, gEdge.toSegment(), this.projSystem, d);
                        if (serializable != null) {
                            boolean bl3 = gEdge.isSelected();
                            if (!bl) {
                                this.clearSelection(true, true, true);
                            }
                            gEdge.setSelected(!bl3);
                            return gEdge;
                        }
                        gEdge.setMarked(true);
                    }
                    serializable2 = serializable2.getNext();
                }
            }
            gFacetNode = gFacetNode.getNext();
        }
        if (this.viewMode == 1 || this.viewMode == 2) {
            gFacetNode = this.facetList.getHead();
            while (gFacetNode != null) {
                gFacet = gFacetNode.getFacet();
                if (gFacet.getVisibility() == 1 && (serializable2 = GMath.adhere(gPoint3D, gFacetNode.getFacet(), this.projSystem)) != null) {
                    boolean bl4 = gFacet.isSelected();
                    if (!bl) {
                        this.clearSelection(true, true, true);
                    }
                    gFacet.setSelected(!bl4);
                    return gFacet;
                }
                gFacetNode = gFacetNode.getNext();
            }
        }
        return null;
    }

    public Color getSelectColor() {
        if (this.viewMode == 0) {
            return SELECTCOLOR_TR;
        }
        return SELECTCOLOR_OP;
    }

    public Color getLabelBackground() {
        if (this.viewMode == 0) {
            return null;
        }
        return LABEL_BACKGROUND;
    }

    public GFacetList getSelectedFacets() {
        GFacetList gFacetList = new GFacetList();
        GFacetNode gFacetNode = this.facetList.getHead();
        while (gFacetNode != null) {
            GFacet gFacet = gFacetNode.getFacet();
            if (gFacet.isSelected()) {
                gFacetList.addToTail(gFacet);
            }
            gFacetNode = gFacetNode.getNext();
        }
        return gFacetList;
    }

    public GEdgeList getSelectedEdges() {
        this.facetList.unmarkAllEdges();
        GEdgeList gEdgeList = new GEdgeList();
        GFacetNode gFacetNode = this.facetList.getHead();
        while (gFacetNode != null) {
            GFacet gFacet = gFacetNode.getFacet();
            GEdgeNode gEdgeNode = gFacet.edgeList.getHead();
            while (gEdgeNode != null) {
                GEdge gEdge = gEdgeNode.getEdge();
                if (!gEdge.isMarked()) {
                    if (gEdge.isSelected()) {
                        gEdgeList.addToTail(gEdge);
                    }
                    gEdge.setMarked(true);
                }
                gEdgeNode = gEdgeNode.getNext();
            }
            gFacetNode = gFacetNode.getNext();
        }
        return gEdgeList;
    }

    public GVertexList getSelectedVertices() {
        this.unmarkAllVertices();
        GVertexList gVertexList = new GVertexList();
        GVertexNode gVertexNode = this.vertexList.getHead();
        while (gVertexNode != null) {
            GVertex gVertex = gVertexNode.getVertex();
            if (!gVertex.isMarked()) {
                if (gVertex.isSelected()) {
                    gVertexList.addToTail(gVertex);
                }
                gVertex.setMarked(true);
            }
            gVertexNode = gVertexNode.getNext();
        }
        return gVertexList;
    }

    public void unmarkAllVertices() {
        GVertexNode gVertexNode = this.vertexList.getHead();
        while (gVertexNode != null) {
            gVertexNode.getVertex().setMarked(false);
            gVertexNode = gVertexNode.getNext();
        }
    }

    public Object measureDistance(String[] stringArray, boolean bl) {
        GVertex gVertex = this.vertexList.seek(stringArray[0]);
        if (gVertex == null) {
            return "No point labeled " + stringArray[0] + " found";
        }
        GVertex gVertex2 = this.vertexList.seek(stringArray[1]);
        if (gVertex2 == null) {
            return "No point labeled " + stringArray[1] + " found";
        }
        GFacetNode gFacetNode = this.facetList.getHead();
        while (gFacetNode != null) {
            GFacet gFacet = gFacetNode.getFacet();
            double d = gFacet.measureDistance(gVertex, gVertex2, bl);
            if (d >= 0.0) {
                return new Double(d);
            }
            gFacetNode = gFacetNode.getNext();
        }
        return "Points " + stringArray[0] + "," + stringArray[1] + " not on the same facet";
    }

    public Object measureAngle(String[] stringArray, boolean bl) {
        GVertex[] gVertexArray = new GVertex[3];
        int n = 0;
        while (n < 3) {
            gVertexArray[n] = this.vertexList.seek(stringArray[n]);
            if (gVertexArray[n] == null) {
                return "No point labeled " + stringArray[n] + " found";
            }
            ++n;
        }
        GFacetNode gFacetNode = this.facetList.getHead();
        while (gFacetNode != null) {
            GFacet gFacet = gFacetNode.getFacet();
            double d = gFacet.measureAngle(gVertexArray, bl);
            if (d >= 0.0) {
                return new Double(d);
            }
            gFacetNode = gFacetNode.getNext();
        }
        return "Points " + stringArray[0] + "," + stringArray[1] + "," + stringArray[2] + " not on the same facet";
    }

    public String drawLine(String[] stringArray) {
        GVertex gVertex = this.vertexList.seek(stringArray[0]);
        if (gVertex == null) {
            return "No point labeled " + stringArray[0] + " found";
        }
        GVertex gVertex2 = this.vertexList.seek(stringArray[1]);
        if (gVertex2 == null) {
            return "No point labeled " + stringArray[1] + " found";
        }
        GFacetNode gFacetNode = this.facetList.getHead();
        while (gFacetNode != null) {
            GFacet gFacet = gFacetNode.getFacet();
            String string = gFacet.drawLine(gVertex, gVertex2);
            if (string != null) {
                if (string.equals("ok")) {
                    this.facetList.buildEdgeStars();
                    this.clearSelection(true, true, true);
                    return null;
                }
                return string;
            }
            gFacetNode = gFacetNode.getNext();
        }
        return "Points " + stringArray[0] + "," + stringArray[1] + " not on the same facet";
    }

    public String drawMidpoint(String[] stringArray) {
        String string = this.badNewLabel(stringArray[2]);
        if (string != null) {
            return string;
        }
        GVertex gVertex = this.vertexList.seek(stringArray[0]);
        if (gVertex == null) {
            return "No point labeled " + stringArray[0] + " found";
        }
        GVertex gVertex2 = this.vertexList.seek(stringArray[1]);
        if (gVertex2 == null) {
            return "No point labeled " + stringArray[1] + " found";
        }
        GFacetNode gFacetNode = this.facetList.getHead();
        while (gFacetNode != null) {
            GFacet gFacet = gFacetNode.getFacet();
            Object object = gFacet.drawMidpoint(gVertex, gVertex2, stringArray[2]);
            if (object instanceof GVertex) {
                GVertex gVertex3 = (GVertex)object;
                this.vertexList.addToTail(gVertex3);
                gVertex3.project(this.projSystem);
                this.facetList.buildEdgeStars();
                this.clearSelection(true, true, true);
                return null;
            }
            if (object instanceof String) {
                return (String)object;
            }
            gFacetNode = gFacetNode.getNext();
        }
        return "No line joins " + stringArray[0] + "," + stringArray[1] + " in Solid " + this.label;
    }

    public String drawIntersection(String[] stringArray) {
        String string = this.badNewLabel(stringArray[4]);
        if (string != null) {
            return string;
        }
        GVertex[] gVertexArray = new GVertex[4];
        int n = 0;
        while (n < 4) {
            gVertexArray[n] = this.vertexList.seek(stringArray[n]);
            if (gVertexArray[n] == null) {
                return "No point labeled " + stringArray[n] + " found";
            }
            ++n;
        }
        GFacetNode gFacetNode = this.facetList.getHead();
        while (gFacetNode != null) {
            Object object = gFacetNode.getFacet().drawIntersection(gVertexArray, stringArray[4]);
            if (object instanceof GVertex) {
                GVertex gVertex = (GVertex)object;
                this.vertexList.addToTail(gVertex);
                gVertex.project(this.projSystem);
                this.facetList.buildEdgeStars();
                this.clearSelection(true, true, true);
                return null;
            }
            if (object instanceof String) {
                return (String)object;
            }
            gFacetNode = gFacetNode.getNext();
        }
        return "Lines " + stringArray[0] + stringArray[1] + ", " + stringArray[2] + stringArray[3] + " not on the same facet";
    }

    public String erase(String[] stringArray) {
        Serializable serializable;
        Serializable serializable2;
        GVertex gVertex = null;
        GVertex gVertex2 = null;
        GVertex gVertex3 = null;
        if (!stringArray[0].equals("") && !stringArray[1].equals("")) {
            gVertex = this.vertexList.seek(stringArray[0]);
            if (gVertex == null) {
                return "No point labeled " + stringArray[0] + " found";
            }
            gVertex2 = this.vertexList.seek(stringArray[1]);
            if (gVertex2 == null) {
                return "No point labeled " + stringArray[1] + " found";
            }
        }
        if (!stringArray[2].equals("")) {
            gVertex3 = this.vertexList.seek(stringArray[2]);
            if (gVertex3 == null) {
                return "No point labeled " + stringArray[2] + " found";
            }
            if (gVertex3.isProper()) {
                return "Cannot erase " + stringArray[2] + " : is vertex";
            }
        }
        if (gVertex3 == gVertex || gVertex3 == gVertex2) {
            gVertex3 = null;
        }
        GEdge gEdge = null;
        GEdgeList gEdgeList = new GEdgeList();
        GFacetNode gFacetNode = this.facetList.getHead();
        while (gFacetNode != null) {
            serializable2 = gFacetNode.getFacet();
            serializable = ((GFacet)serializable2).edgeList.getHead();
            while (serializable != null) {
                GEdge gEdge2 = ((GEdgeNode)serializable).getEdge();
                if (gVertex3 == gEdge2.getHead() || gVertex3 == gEdge2.getTail()) {
                    return "Cannot erase " + stringArray[2] + " : is end of " + gEdge2.getHead().getLabel() + gEdge2.getTail().getLabel();
                }
                if (gEdge2.vertexList.seek(gVertex3) != null) {
                    gEdgeList.addToTail(gEdge2);
                }
                if (gEdge2.vertexList.seek(gVertex) != null && gEdge2.vertexList.seek(gVertex2) != null) {
                    if (gEdge2.twin != null) {
                        return "Cannot erase " + stringArray[0] + stringArray[1] + " : is edge";
                    }
                    gEdge = gEdge2;
                }
                serializable = ((GEdgeNode)serializable).getNext();
            }
            gFacetNode = gFacetNode.getNext();
        }
        if (gVertex != null && gVertex2 != null && gEdge == null) {
            return "No line labeled " + stringArray[0] + stringArray[1] + " found";
        }
        if (gVertex3 != null) {
            serializable2 = gEdgeList.getHead();
            while (serializable2 != null) {
                ((GEdgeNode)serializable2).getEdge().vertexList.remove(gVertex3);
                serializable2 = ((GEdgeNode)serializable2).getNext();
            }
            this.vertexList.remove(gVertex3);
        }
        if (gEdge != null) {
            serializable2 = gEdge.wing1;
            serializable = ((GFacet)serializable2).cutOffEdge(gEdge, gVertex, gVertex2).getHead();
            while (serializable != null) {
                this.vertexList.remove(((GVertexNode)serializable).getVertex());
                serializable = ((GVertexNode)serializable).getNext();
            }
        }
        this.facetList.buildEdgeStars();
        this.clearSelection(true, true, true);
        return null;
    }

    public void eraseAll() {
        this.vertexList = this.vertexList.removeParaVerts();
        this.facetList.removeParaEdgesVerts();
    }

    public String drawBisector(String[] stringArray) {
        GVertex[] gVertexArray = new GVertex[3];
        int n = 0;
        while (n < 3) {
            gVertexArray[n] = this.vertexList.seek(stringArray[n]);
            if (gVertexArray[n] == null) {
                return "No point labeled " + stringArray[n] + " found";
            }
            ++n;
        }
        String string = this.problem.supplyLabel();
        if (string == null) {
            return "Out of labels";
        }
        GFacetNode gFacetNode = this.facetList.getHead();
        while (gFacetNode != null) {
            GFacet gFacet = gFacetNode.getFacet();
            Object object = gFacet.drawBisector(gVertexArray, string);
            if (object instanceof String && !"ok".equals(object)) {
                return (String)object;
            }
            if (object instanceof GVertex) {
                GVertex gVertex = (GVertex)object;
                this.vertexList.addToTail(gVertex);
                gVertex.project(this.projSystem);
            }
            if (object instanceof GVertex || "ok".equals(object)) {
                this.facetList.buildEdgeStars();
                this.clearSelection(true, true, true);
                return null;
            }
            gFacetNode = gFacetNode.getNext();
        }
        return "Lines " + stringArray[0] + stringArray[1] + ", " + stringArray[0] + stringArray[2] + " not on the same facet";
    }

    public String drawPerpendicular(String[] stringArray, String string) {
        Object object;
        GVertex[] gVertexArray = new GVertex[3];
        int n = 0;
        while (n < 3) {
            gVertexArray[n] = this.vertexList.seek(stringArray[n]);
            if (gVertexArray[n] == null) {
                return "No point labeled " + stringArray[n] + " found";
            }
            ++n;
        }
        GLabelList gLabelList = this.problem.supplyLabels(2);
        if (gLabelList.getDim() < 2) {
            return "Out of labels";
        }
        String[] stringArray2 = new String[]{gLabelList.getHead().getLabel(), gLabelList.getHead().getNext().getLabel()};
        GFacetNode gFacetNode = this.facetList.getHead();
        while (gFacetNode != null) {
            object = gFacetNode.getFacet();
            if (string == null || string.equals(((GFacet)object).toString())) {
                Object object2 = ((GFacet)object).drawPerpendicular(gVertexArray, stringArray2, string != null);
                if (object2 instanceof String && !object2.equals("ok")) {
                    return (String)object2;
                }
                if (object2 instanceof GVertexList) {
                    GVertexNode gVertexNode = ((GVertexList)object2).getHead();
                    while (gVertexNode != null) {
                        GVertex gVertex = gVertexNode.getVertex();
                        this.vertexList.addToTail(gVertexNode.getVertex());
                        gVertex.project(this.projSystem);
                        gVertexNode = gVertexNode.getNext();
                    }
                }
                if (object2 instanceof GVertexList || "ok".equals(object2)) {
                    this.facetList.buildEdgeStars();
                    this.clearSelection(true, true, true);
                    return null;
                }
            }
            gFacetNode = gFacetNode.getNext();
        }
        object = string != null ? "facet " + string : "the same facet";
        return "Point " + stringArray[0] + ", line " + stringArray[1] + stringArray[2] + " not on " + (String)object;
    }

    public Object cutThrough(String[] stringArray, boolean bl) {
        GVertex[] gVertexArray = new GVertex[3];
        int n = 0;
        while (n < 3) {
            gVertexArray[n] = this.vertexList.seek(stringArray[n]);
            if (gVertexArray[n] == null) {
                return "No point labeled " + stringArray[n] + " found";
            }
            ++n;
        }
        if (this.facetList.seek(gVertexArray[0], gVertexArray[1], gVertexArray[2]) != null) {
            return "The three points are on the same facet";
        }
        int n2 = this.facetList.getNrEdges();
        GLabelList gLabelList = this.problem.supplyLabels(n2);
        if (gLabelList.getDim() < n2) {
            return "Not enough labels left";
        }
        GSolid[] gSolidArray = new GSolid[2];
        String string = String.valueOf(this.cutCount * 2 + 1);
        gSolidArray[0] = this.copy(String.valueOf(this.label) + ":" + string);
        gSolidArray[0].cutCount = 0;
        string = String.valueOf(this.cutCount * 2 + 2);
        gSolidArray[1] = this.copy(String.valueOf(this.label) + ":" + string);
        gSolidArray[1].cutCount = 0;
        GVertex gVertex = gSolidArray[0].vertexList.seek(stringArray[0]);
        GPoint3D gPoint3D = GMath.vectorP(GMath.subtract(gVertexArray[1].xyzCrds, gVertex.xyzCrds), GMath.subtract(gVertexArray[2].xyzCrds, gVertex.xyzCrds));
        gSolidArray[0] = gSolidArray[0].cutOff(gVertex, gPoint3D, gLabelList);
        gVertex = gSolidArray[1].vertexList.seek(stringArray[0]);
        gPoint3D = GMath.subtract(new GPoint3D(0.0, 0.0, 0.0), gPoint3D);
        gSolidArray[1] = gSolidArray[1].cutOff(gVertex, gPoint3D, gLabelList);
        if (!bl) {
            gSolidArray[0].eraseAll();
            gSolidArray[1].eraseAll();
        }
        this.clearSelection(true, true, true);
        ++this.cutCount;
        return gSolidArray;
    }

    protected GSolid cutOff(GVertex gVertex, GPoint3D gPoint3D, GLabelList gLabelList) {
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        Serializable serializable4;
        gLabelList.unmarkAll();
        GFacet gFacet = null;
        if (!gVertex.isProper()) {
            serializable4 = this.facetList.seek(gVertex);
            gFacet = ((GEdge)serializable4).wing1;
            gVertex = ((GEdge)serializable4).wing1.getIntercept(gVertex, gPoint3D, gLabelList);
        }
        this.facetList.unmarkAllFacets();
        serializable4 = new GFacetList();
        GEdgeList gEdgeList = new GEdgeList();
        GVertex gVertex2 = gVertex;
        GVertex gVertex3 = gVertex;
        GVertex gVertex4 = null;
        while (gVertex4 != gVertex2) {
            serializable3 = null;
            if (gVertex.isProper()) {
                serializable2 = gVertex.edgeStar.getHead();
                while (serializable2 != null) {
                    serializable = ((GEdgeNode)serializable2).getEdge();
                    if (((GEdge)serializable).twin != null) {
                        serializable3 = ((GEdge)serializable).wing1;
                        gVertex4 = ((GFacet)serializable3).getIntercept(gVertex, gPoint3D, gLabelList);
                        if (gVertex4 == null) {
                            serializable3 = ((GEdge)serializable).wing2;
                            gVertex4 = ((GFacet)serializable3).getIntercept(gVertex, gPoint3D, gLabelList);
                        }
                        if (gVertex4 != null && gVertex4 != gVertex3) break;
                    }
                    serializable2 = ((GEdgeNode)serializable2).getNext();
                }
                serializable = gVertex.edgeStar.seek(gVertex4);
                if (serializable != null && ((GEdge)serializable).twin != null) {
                    gEdgeList.addToTail(((GEdge)serializable).copy());
                    gVertex3 = gVertex;
                    gVertex = gVertex4;
                    continue;
                }
            } else {
                serializable3 = gFacet;
                gVertex4 = ((GFacet)serializable3).getIntercept(gVertex, gPoint3D, gLabelList);
            }
            if (((GEdge)(serializable = ((GFacet)(serializable2 = ((GFacet)serializable3).cutOff(gVertex, gVertex4, gPoint3D, gLabelList))).getMarkedEdge().copy())).getHead() != gVertex) {
                ((GEdge)serializable).reverse();
            }
            gEdgeList.addToTail((GEdge)serializable);
            ((GFacetList)serializable4).addToTail((GFacet)serializable2);
            gFacet = ((GFacet)serializable3).getMarkedEdge().wing2;
            gVertex3 = gVertex;
            gVertex = gVertex4;
            ((GFacet)serializable3).setMarked(true);
        }
        serializable3 = gEdgeList.getHead();
        while (serializable3 != null) {
            ((GEdgeNode)serializable3).getEdge().getHead().setProper(true);
            serializable3 = ((GEdgeNode)serializable3).getNext();
        }
        serializable2 = this.facetList.getHead();
        while (serializable2 != null) {
            serializable = ((GFacetNode)serializable2).getFacet();
            if (!((GFacet)serializable).isMarked() && ((GFacet)serializable).getAttitude(gVertex.xyzCrds, gPoint3D) == 1) {
                ((GFacetList)serializable4).addToTail((GFacet)serializable);
            }
            serializable2 = ((GFacetNode)serializable2).getNext();
        }
        serializable = new GFacet(gEdgeList, this.palette.newColor());
        ((GFacetList)serializable4).addToTail((GFacet)serializable);
        this.facetList = serializable4;
        this.vertexList = this.facetList.getVertexList();
        this.computeCenter();
        this.orient();
        this.facetList.buildEdgeWingsTwins();
        this.facetList.buildEdgeStars();
        this.project();
        return this;
    }

    public Object join(GSolid gSolid, String string, String string2) {
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        GFacet gFacet;
        GSolid gSolid2 = this.copy("");
        GSolid gSolid3 = gSolid.copy("");
        GFacet gFacet2 = gSolid2.facetList.seek(string);
        GEdgeList[] gEdgeListArray = gFacet2.isSimilar(gFacet = gSolid3.facetList.seek(string2), true);
        if (gEdgeListArray == null) {
            if (gFacet2.isSimilar(gFacet, false) == null) {
                return "Facets " + string + " , " + string2 + " not similar";
            }
            return "Joining physically impossible";
        }
        GEdgeNode gEdgeNode = gEdgeListArray[0].getHead();
        GEdge gEdge = gEdgeNode.getEdge();
        double d = gEdge.getLength();
        GEdge gEdge2 = gEdgeNode.getNext().getEdge();
        double[][] dArray = GMath.orthize(gEdge, gEdge2);
        GPoint3D gPoint3D = gEdge.getHead().xyzCrds;
        GEdgeNode gEdgeNode2 = gEdgeListArray[1].getHead();
        gEdge = gEdgeNode2.getEdge();
        double d2 = gEdge.getLength();
        gEdge2 = gEdgeNode2.getNext().getEdge();
        double[][] dArray2 = GMath.orthize(gEdge, gEdge2);
        GPoint3D gPoint3D2 = gEdge.getHead().xyzCrds;
        double d3 = 100.0 * d / d2;
        gSolid3.vertexList.stretch(new GPoint3D(d3, d3, d3));
        gSolid3.vertexList.move(dArray, dArray2, gPoint3D, gPoint3D2);
        boolean bl = false;
        GLabelList gLabelList = this.problem.supplyLabels(gSolid3.vertexList.getDim());
        GLabelNode gLabelNode = gLabelList.getHead();
        GVertexNode gVertexNode = gSolid3.vertexList.getHead();
        while (gVertexNode != null) {
            serializable3 = gVertexNode.getVertex();
            GVertex gVertex = gSolid2.vertexList.seek(((GVertex)serializable3).getLabel());
            if (gVertex != null && !GMath.isAt((GVertex)serializable3, gVertex.xyzCrds, gEdge.getLength())) {
                if (!bl) {
                    new GAlertDialog(frame, "warn.gif", "Labels Overlap", "Labels overlap. Joint solid will be re-labeled");
                    bl = true;
                }
                if (gLabelNode == null) {
                    return "Out of labels";
                }
                ((GVertex)serializable3).setLabel(gLabelNode.getLabel());
                gLabelNode = gLabelNode.getNext();
            }
            gVertexNode = gVertexNode.getNext();
        }
        serializable3 = new GFacetList();
        gSolid2.facetList.unmarkAllFacets();
        gSolid3.facetList.unmarkAllFacets();
        gEdgeNode = gEdgeListArray[0].getHead();
        gEdgeNode2 = gEdgeListArray[1].getHead();
        int n = 0;
        while (n < gEdgeListArray[0].getDim()) {
            gEdge = gEdgeNode.getEdge();
            serializable2 = gEdge.wing2;
            serializable = ((GFacet)serializable2).getXYZNormal();
            gEdge2 = gEdgeNode2.getEdge();
            GFacet gFacet3 = gEdge2.wing2;
            GPoint3D gPoint3D3 = gFacet3.getXYZNormal();
            double d4 = GMath.mixtP((GPoint3D)serializable, gPoint3D3, gEdge.toVector());
            if (d4 > 1.0E-5) {
                return "Joint solid not convex";
            }
            if (d4 > -1.0E-5) {
                ((GFacetList)serializable3).addToTail(((GFacet)serializable2).merge(gFacet3, gEdge.twin, gEdge2.twin));
                ((GFacet)serializable2).setMarked(true);
                gFacet3.setMarked(true);
            } else {
                ((GFacet)serializable2).join(gFacet3, gEdge.twin, gEdge2.twin);
            }
            gEdgeNode = gEdgeNode.getNext();
            gEdgeNode2 = gEdgeNode2.getNext();
            ++n;
        }
        serializable2 = gSolid2.facetList.getHead();
        while (serializable2 != null) {
            serializable = ((GFacetNode)serializable2).getFacet();
            if (!((GFacet)serializable).isMarked() && serializable != gFacet2) {
                ((GFacetList)serializable3).addToTail((GFacet)serializable);
            }
            serializable2 = ((GFacetNode)serializable2).getNext();
        }
        serializable2 = gSolid3.facetList.getHead();
        while (serializable2 != null) {
            serializable = ((GFacetNode)serializable2).getFacet();
            if (!((GFacet)serializable).isMarked() && serializable != gFacet) {
                ((GFacetList)serializable3).addToTail((GFacet)serializable);
            }
            serializable2 = ((GFacetNode)serializable2).getNext();
        }
        gSolid2.facetList = serializable3;
        gSolid2.vertexList = ((GFacetList)serializable3).getVertexList();
        gSolid2.computeCenter();
        gSolid2.orient();
        ((GFacetList)serializable3).buildEdgeWingsTwins();
        ((GFacetList)serializable3).buildEdgeStars();
        gSolid2.project();
        return gSolid2;
    }

    public String layDistance(String[] stringArray, double d) {
        GVertex[] gVertexArray = new GVertex[3];
        int n = 0;
        while (n < 3) {
            gVertexArray[n] = this.vertexList.seek(stringArray[n]);
            if (gVertexArray[n] == null) {
                return "No point labeled " + stringArray[n] + " found";
            }
            ++n;
        }
        GLabelList gLabelList = this.problem.supplyLabels(2);
        if (gLabelList.getDim() < 2) {
            return "Out of labels";
        }
        String[] stringArray2 = new String[]{gLabelList.getHead().getLabel(), gLabelList.getHead().getNext().getLabel()};
        GFacetNode gFacetNode = this.facetList.getHead();
        while (gFacetNode != null) {
            GFacet gFacet = gFacetNode.getFacet();
            Object object = gFacet.layDistance(gVertexArray, d, stringArray2);
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof GVertexList) {
                GVertexNode gVertexNode = ((GVertexList)object).getHead();
                while (gVertexNode != null) {
                    GVertex gVertex = gVertexNode.getVertex();
                    this.vertexList.addToTail(gVertexNode.getVertex());
                    gVertex.project(this.projSystem);
                    gVertexNode = gVertexNode.getNext();
                }
                this.facetList.buildEdgeStars();
                this.clearSelection(true, true, true);
                return null;
            }
            gFacetNode = gFacetNode.getNext();
        }
        return "Point " + stringArray[0] + ", line " + stringArray[1] + stringArray[2] + " not on the same facet";
    }

    public String layAngle(String[] stringArray, double d, String string) {
        GVertex[] gVertexArray = new GVertex[2];
        int n = 0;
        while (n < 2) {
            gVertexArray[n] = this.vertexList.seek(stringArray[n]);
            if (gVertexArray[n] == null) {
                return "No point labeled " + stringArray[n] + " found";
            }
            ++n;
        }
        GLabelList gLabelList = this.problem.supplyLabels(2);
        if (gLabelList.getDim() < 2) {
            return "Out of labels";
        }
        String[] stringArray2 = new String[]{gLabelList.getHead().getLabel(), gLabelList.getHead().getNext().getLabel()};
        GFacetNode gFacetNode = this.facetList.getHead();
        while (gFacetNode != null) {
            GFacet gFacet = gFacetNode.getFacet();
            if (string == null || string.equals(gFacet.toString())) {
                Object object = gFacet.layAngle(gVertexArray, d, stringArray2, string != null);
                if (object instanceof String && !object.equals("ok")) {
                    return (String)object;
                }
                if (object instanceof GVertexList) {
                    GVertexNode gVertexNode = ((GVertexList)object).getHead();
                    while (gVertexNode != null) {
                        GVertex gVertex = gVertexNode.getVertex();
                        this.vertexList.addToTail(gVertexNode.getVertex());
                        gVertex.project(this.projSystem);
                        gVertexNode = gVertexNode.getNext();
                    }
                    this.facetList.buildEdgeStars();
                    this.clearSelection(true, true, true);
                    return null;
                }
                if (object instanceof GVertexList || "ok".equals(object)) {
                    this.facetList.buildEdgeStars();
                    this.clearSelection(true, true, true);
                    return null;
                }
            }
            gFacetNode = gFacetNode.getNext();
        }
        if (string != null) {
            return "Line " + stringArray[0] + stringArray[1] + " not on facet " + string;
        }
        return null;
    }

    public String changeVertexLabel(GVertex gVertex, String string) {
        String string2 = this.badNewLabel(string);
        if (string2 != null) {
            return string2;
        }
        gVertex.setLabel(string);
        return null;
    }

    public Object checkPath(String string, GPoint3DList gPoint3DList) {
        if (string.length() == 0) {
            return gPoint3DList;
        }
        String string2 = null;
        if (string.charAt(0) < 'A' || string.charAt(0) > 'Z') {
            return string.substring(0, 1);
        }
        if (string.length() == 1 || string.charAt(1) >= 'A' && string.charAt(1) <= 'Z') {
            string2 = string.substring(0, 1);
        } else {
            if (string.charAt(1) < '0' || string.charAt(1) > '9') {
                return string.substring(0, 2);
            }
            if (string.length() == 2 || string.charAt(2) >= 'A' && string.charAt(2) <= 'Z') {
                string2 = string.substring(0, 2);
            } else {
                if (string.charAt(2) < '0' || string.charAt(1) > '9') {
                    return string.substring(0, 3);
                }
                string2 = string.substring(0, 3);
            }
        }
        GVertex gVertex = this.vertexList.seek(string2);
        if (gVertex == null) {
            return string2;
        }
        gPoint3DList.addToTail(gVertex.xyzCrds);
        string = string.substring(string2.length());
        return this.checkPath(string, gPoint3DList);
    }
}

