/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class GPoint3DList
implements Serializable {
    private GPoint3DNode head;
    private GPoint3DNode tail;
    private int dim = 0;

    public void print() {
        GPoint3DNode gPoint3DNode = this.head;
        while (gPoint3DNode != null) {
            gPoint3DNode.getPoint3D().print();
            gPoint3DNode = gPoint3DNode.getNext();
        }
    }

    public void addToTail(GPoint3D gPoint3D) {
        GPoint3DNode gPoint3DNode = new GPoint3DNode(gPoint3D);
        if (this.head == null) {
            this.head = this.tail = gPoint3DNode;
        } else {
            this.tail.setNext(gPoint3DNode);
            gPoint3DNode.setPrev(this.tail);
            this.tail = gPoint3DNode;
        }
        ++this.dim;
    }

    public GPoint3DList concat(GPoint3DList gPoint3DList) {
        GPoint3DList gPoint3DList2 = new GPoint3DList();
        GPoint3DNode gPoint3DNode = this.head;
        while (gPoint3DNode != null) {
            gPoint3DList2.addToTail(gPoint3DNode.getPoint3D());
            gPoint3DNode = gPoint3DNode.getNext();
        }
        gPoint3DNode = gPoint3DList.getHead();
        while (gPoint3DNode != null) {
            gPoint3DList2.addToTail(gPoint3DNode.getPoint3D());
            gPoint3DNode = gPoint3DNode.getNext();
        }
        return gPoint3DList2;
    }

    public GPoint3DNode getHead() {
        return this.head;
    }

    public GPoint3DNode getTail() {
        return this.tail;
    }

    public int getDim() {
        return this.dim;
    }

    public GPoint3DNode seek(GPoint3D gPoint3D) {
        if (this.head == null) {
            return null;
        }
        GPoint3DNode gPoint3DNode = this.head;
        do {
            GPoint3D gPoint3D2;
            if (!(gPoint3D2 = gPoint3DNode.getPoint3D()).equals(gPoint3D)) continue;
            return gPoint3DNode;
        } while ((gPoint3DNode = gPoint3DNode.getNext()) != null);
        return null;
    }

    public void flush() {
        this.tail = null;
        this.head = null;
        this.dim = 0;
    }

    public void clearSelection() {
        if (this.dim == 0) {
            return;
        }
        GPoint3DNode gPoint3DNode = this.head;
        while (gPoint3DNode != null) {
            gPoint3DNode.getPoint3D().setSelected(false);
            gPoint3DNode = gPoint3DNode.getNext();
        }
    }
}

