package ishitai.oopad;

import java.awt.*;
import java.awt.event.*;

/**
 * EditorGui.java
 *
 *
 * Created: Thu Sep 02 1999
 *
 * @author Richard Harris
 * @version 1.0
 * changes
 * 3.5.00 no longer return ref to frame
 */
public class EditorGui extends Frame
	implements IEditorGui{

   public TextArea txaMain = new TextArea();
   public TextField txfStatus = new TextField();

   private Panel pnlMain = new Panel();
   private EditorMenu menubar = null;

   EditorGui(String title, EditorMenu menu){
      super(title);
      menubar = menu;
      _init();
   }

	/**
	 * Connects the Module's WindowListener to the Frame
	 * and returns references to the TextArea, status line,
	 * and outer frame.
	 *
	 * @param o The module that needs the gui references
	 * @param wl The AppCloser to be hooked to the Frame
	 * @return An array of Components
	 */
   public Component[] addListeners(Object o, WindowListener wl){
      //this should be module
      addWindowListener(wl);
      txaMain.addTextListener((TextListener)o);
      txfStatus.addActionListener((ActionListener)o);
      Component[] components = {txaMain, txfStatus};
      return components;
   }

   private void _init(){
      setLayout(new BorderLayout());
      setMenuBar(menubar);
      add("Center", pnlMain);
      pnlMain.setLayout(new BorderLayout());
      txaMain.setFont(new Font("serif", Font.PLAIN, 12));
      pnlMain.add("Center", txaMain);
      txfStatus.setFont(new Font("serif", Font.PLAIN, 12));
      pnlMain.add("South", txfStatus);
      txfStatus.setEditable(false);
      setSize(500, 600);

      //center the frame on the screen
      Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
      Dimension frameSize = this.getSize();
      if (frameSize.height > screenSize.height)
			frameSize.height = screenSize.height;
      if (frameSize.width > screenSize.width)
			frameSize.width = screenSize.width;
      this.setLocation((screenSize.width - frameSize.width) / 2,
		       ((screenSize.height - frameSize.height) / 2) - 
		       (screenSize.height / 15));
      
      show();
   }
}
