/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Random;

class L {
    static final String[] I = new String[]{"ABS", "java.lang.Math.abs", "ACOS", "java.lang.Math.acos", "ASIN", "java.lang.Math.asin", "ATAN", "java.lang.Math.atan", "ATAN2", "java.lang.Math.atan2", "CEILING", "java.lang.Math.ceil", "COS", "java.lang.Math.cos", "COT", "org.hsqldb.Library.cot", "DEGREES", "java.lang.Math.toDegrees", "EXP", "java.lang.Math.exp", "FLOOR", "java.lang.Math.floor", "LOG", "java.lang.Math.log", "LOG10", "org.hsqldb.Library.log10", "MOD", "org.hsqldb.Library.mod", "PI", "org.hsqldb.Library.pi", "POWER", "java.lang.Math.pow", "RADIANS", "java.lang.Math.toRadians", "RAND", "java.lang.Math.random", "ROUND", "org.hsqldb.Library.round", "SIGN", "org.hsqldb.Library.sign", "SIN", "java.lang.Math.sin", "SQRT", "java.lang.Math.sqrt", "TAN", "java.lang.Math.tan", "TRUNCATE", "org.hsqldb.Library.truncate", "BITAND", "org.hsqldb.Library.bitand", "BITOR", "org.hsqldb.Library.bitor", "ROUNDMAGIC", "org.hsqldb.Library.roundMagic"};
    static final String[] Z = new String[]{"ASCII", "org.hsqldb.Library.ascii", "CHAR", "org.hsqldb.Library.character", "CONCAT", "org.hsqldb.Library.concat", "DIFFERENCE", "org.hsqldb.Library.difference", "INSERT", "org.hsqldb.Library.insert", "LCASE", "org.hsqldb.Library.lcase", "LEFT", "org.hsqldb.Library.left", "LENGTH", "org.hsqldb.Library.length", "LOCATE", "org.hsqldb.Library.locate", "LTRIM", "org.hsqldb.Library.ltrim", "REPEAT", "org.hsqldb.Library.repeat", "REPLACE", "org.hsqldb.Library.replace", "RIGHT", "org.hsqldb.Library.right", "RTRIM", "org.hsqldb.Library.rtrim", "SOUNDEX", "org.hsqldb.Library.soundex", "SPACE", "org.hsqldb.Library.space", "SUBSTR", "org.hsql.Library.substring", "SUBSTRING", "org.hsqldb.Library.substring", "UCASE", "org.hsqldb.Library.ucase", "LOWER", "org.hsqldb.Library.lcase", "UPPER", "org.hsqldb.Library.ucase"};
    static final String[] C = new String[]{"CURDATE", "org.hsqldb.Library.curdate", "CURTIME", "org.hsqldb.Library.curtime", "DAYNAME", "org.hsqldb.Library.dayname", "DAYOFMONTH", "org.hsqldb.Library.dayofmonth", "DAYOFWEEK", "org.hsqldb.Library.dayofweek", "DAYOFYEAR", "org.hsqldb.Library.dayofyear", "HOUR", "org.hsqldb.Library.hour", "MINUTE", "org.hsqldb.Library.minute", "MONTH", "org.hsqldb.Library.month", "MONTHNAME", "org.hsqldb.Library.monthname", "NOW", "org.hsqldb.Library.now", "QUARTER", "org.hsqldb.Library.quarter", "SECOND", "org.hsqldb.Library.second", "WEEK", "org.hsqldb.Library.week", "YEAR", "org.hsqldb.Library.year"};
    static final String[] B = new String[]{"DATABASE", "org.hsqldb.Library.database", "USER", "org.hsqldb.Library.user", "IDENTITY", "org.hsqldb.Library.identity"};
    static Random append = new Random();
    static double ceil = 0.4342944819032518;

    L() {
    }

    static final void I(Hashtable hashtable) {
        L.append(hashtable, I);
        L.append(hashtable, Z);
        L.append(hashtable, C);
        L.append(hashtable, B);
    }

    private static void append(Hashtable hashtable, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            hashtable.put(stringArray[n], stringArray[n + 1]);
            n += 2;
        }
    }

    public static final double rand(Integer n) {
        if (n != null) {
            append.setSeed(n.intValue());
        }
        return append.nextDouble();
    }

    public static final double log10(double d) {
        return L.roundMagic(Math.log(d) * ceil);
    }

    public static final double roundMagic(double d) {
        if (d < 1.0E-13 && d > -1.0E-13) {
            return 0.0;
        }
        if (d > 1.0E12 || d < -1.0E12) {
            return d;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(d);
        int n = stringBuffer.length();
        if (n < 16) {
            return d;
        }
        char c = stringBuffer.charAt(n - 1);
        char c2 = stringBuffer.charAt(n - 2);
        char c3 = stringBuffer.charAt(n - 3);
        char c4 = stringBuffer.charAt(n - 4);
        if (c2 == '0' && c3 == '0' && c4 == '0' && c != '.') {
            stringBuffer.setCharAt(n - 1, '0');
        } else if (c2 == '9' && c3 == '9' && c4 == '9' && c != '.') {
            stringBuffer.setCharAt(n - 1, '9');
            stringBuffer.append('9');
            stringBuffer.append('9');
        }
        return new Double(stringBuffer.toString());
    }

    public static final double cot(double d) {
        return 1.0 / Math.tan(d);
    }

    public static final int mod(int n, int n2) {
        return n % n2;
    }

    public static final double pi() {
        return Math.PI;
    }

    public static final double round(double d, int n) {
        double d2 = Math.pow(10.0, n);
        return (double)Math.round(d * d2) / d2;
    }

    public static final int sign(double d) {
        return d < 0.0 ? -1 : (d > 0.0 ? 1 : 0);
    }

    public static final double truncate(double d, int n) {
        double d2 = Math.pow(10.0, n);
        double d3 = d * d2;
        return (d < 0.0 ? Math.ceil(d3) : Math.floor(d3)) / d2;
    }

    public static final int bitand(int n, int n2) {
        return n & n2;
    }

    public static final int bitor(int n, int n2) {
        return n | n2;
    }

    public static final Integer ascii(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return new Integer(string.charAt(0));
    }

    public static final String character(int n) {
        return "" + (char)n;
    }

    public static final String concat(String string, String string2) {
        if (string == null) {
            if (string2 == null) {
                return null;
            }
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        return string + string2;
    }

    public static final int difference(String string, String string2) {
        if (string == null || string2 == null) {
            return 0;
        }
        string = L.soundex(string);
        string2 = L.soundex(string2);
        int n = string.length();
        int n2 = string2.length();
        int n3 = 0;
        int n4 = 0;
        while (n4 < 4) {
            if (n4 >= n || n4 >= n2 || string.charAt(n4) != string2.charAt(n4)) {
                ++n3;
            }
            ++n4;
        }
        return n3;
    }

    public static final String insert(String string, int n, int n2, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        int n3 = string.length();
        int n4 = string2.length();
        if (--n < 0 || n2 <= 0 || n4 == 0 || n > n3) {
            return string;
        }
        if (n + n2 > n3) {
            n2 = n3 - n;
        }
        return string.substring(0, n) + string2 + string.substring(n + n2);
    }

    public static final String lcase(String string) {
        return string == null ? null : string.toLowerCase();
    }

    public static final String left(String string, int n) {
        return string == null ? null : string.substring(0, n < 0 ? 0 : (n < string.length() ? n : string.length()));
    }

    public static final int length(String string) {
        return string == null || string.length() < 1 ? 0 : string.length();
    }

    public static final int locate(String string, String string2, Integer n) {
        if (string2 == null || string == null) {
            return 0;
        }
        int n2 = n == null ? 0 : n - 1;
        return string2.indexOf(string, n2 < 0 ? 0 : n2) + 1;
    }

    public static final String ltrim(String string) {
        if (string == null) {
            return string;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n && string.charAt(n2) <= ' ') {
            ++n2;
        }
        return n2 == 0 ? string : string.substring(n2);
    }

    public static final String repeat(String string, int n) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n-- > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static final String replace(String string, String string2, String string3) {
        if (string == null || string2 == null) {
            return string;
        }
        if (string3 == null) {
            string3 = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string2.length();
        while (true) {
            int n3;
            if ((n3 = string.indexOf(string2, n)) == -1) break;
            stringBuffer.append(string.substring(n, n3 - n));
            stringBuffer.append(string3);
            n = n3 + n2;
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static final String right(String string, int n) {
        if (string == null) {
            return null;
        }
        n = string.length() - n;
        return string.substring(n < 0 ? 0 : (n < string.length() ? n : string.length()));
    }

    public static final String rtrim(String string) {
        if (string == null) {
            return string;
        }
        int n = string.length() - 1;
        while (n >= 0 && string.charAt(n) <= ' ') {
            --n;
        }
        return n == string.length() ? string : string.substring(0, n + 1);
    }

    public static final String soundex(String string) {
        if (string == null) {
            return string;
        }
        string = string.toUpperCase();
        int n = string.length();
        char[] cArray = new char[4];
        cArray[0] = string.charAt(0);
        int n2 = 1;
        int n3 = 1;
        while (n3 < n && n2 < 4) {
            char c = string.charAt(n3);
            if ("BFPV".indexOf(c) != -1) {
                cArray[n2++] = 49;
            } else if ("CGJKQSXZ".indexOf(c) != -1) {
                cArray[n2++] = 50;
            } else if (c == 'D' || c == 'T') {
                cArray[n2++] = 51;
            } else if (c == 'L') {
                cArray[n2++] = 52;
            } else if (c == 'M' || c == 'N') {
                cArray[n2++] = 53;
            } else if (c == 'R') {
                cArray[n2++] = 54;
            }
            ++n3;
        }
        return new String(cArray, 0, n2);
    }

    public static final String space(int n) {
        if (n < 0) {
            return null;
        }
        char[] cArray = new char[n];
        while (n > 0) {
            cArray[--n] = 32;
        }
        return new String(cArray);
    }

    public static final String substring(String string, int n, Integer n2) {
        if (string == null) {
            return null;
        }
        int n3 = string.length();
        int n4 = n = --n > n3 ? n3 : n;
        if (n2 == null) {
            return string.substring(n);
        }
        int n5 = n2;
        return string.substring(n, n + n5 > n3 ? n3 : n5);
    }

    public static final String ucase(String string) {
        return string == null ? null : string.toUpperCase();
    }

    public static final java.sql.Date curdate() {
        return new java.sql.Date(System.currentTimeMillis());
    }

    public static final Time curtime() {
        return new Time(System.currentTimeMillis());
    }

    public static final String dayname(java.sql.Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE");
        return simpleDateFormat.format(date).toString();
    }

    private static int ceil(Date date, int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return gregorianCalendar.get(n);
    }

    public static final int dayofmonth(java.sql.Date date) {
        return L.ceil(date, 5);
    }

    public static final int dayofweek(java.sql.Date date) {
        return L.ceil(date, 7);
    }

    public static final int dayofyear(java.sql.Date date) {
        return L.ceil(date, 6);
    }

    public static final int hour(Time time) {
        return L.ceil(time, 10);
    }

    public static final int minute(Time time) {
        return L.ceil(time, 12);
    }

    public static final int month(java.sql.Date date) {
        return L.ceil(date, 2);
    }

    public static final String monthname(java.sql.Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM");
        return simpleDateFormat.format(date).toString();
    }

    public static final Timestamp now() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static final int quarter(java.sql.Date date) {
        return L.ceil(date, 2) / 3 + 1;
    }

    public static final int second(java.sql.Date date) {
        return L.ceil(date, 13);
    }

    public static final int week(java.sql.Date date) {
        return L.ceil(date, 3);
    }

    public static final int year(java.sql.Date date) {
        return L.ceil(date, 1);
    }

    public static final String database(Connection connection) {
        Statement statement = connection.createStatement();
        String string = "SELECT Value FROM SYSTEM_CONNECTIONINFO WHERE KEY='DATABASE'";
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.next();
        return resultSet.getString(1);
    }

    public static final String user(Connection connection) {
        Statement statement = connection.createStatement();
        String string = "SELECT Value FROM SYSTEM_CONNECTIONINFO WHERE KEY='USER'";
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.next();
        return resultSet.getString(1);
    }

    public static final int identity(Connection connection) {
        Statement statement = connection.createStatement();
        String string = "SELECT VALUE FROM SYSTEM_CONNECTIONINFO WHERE KEY='IDENTITY'";
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.next();
        return resultSet.getInt(1);
    }
}

