<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
xmlns:msxsl="urn:schemas-microsoft-com:xslt"
exclude-result-prefixes="msxsl">


  <!-- f2xml custom transformation.                                   -->

  <!-- Email  : help@boulderwall.com                                  -->
  <!-- Web    : http://www.boulderwall.com                            -->
  <!-- Name   : duplicates.xsl                                        -->
  <!-- Purpose: Transform XML filelist into an HTML listing of        -->
  <!--          duplicated files. ie that have the same name and size.-->

  <xsl:output method="html"/>

  <xsl:template match="/">
    <xsl:comment>
    Created by duplicates.xsl. Input XML created by f2xml from www.boulderwall.com 
    </xsl:comment>
    <html>
      <body>
        <center>
          <h2>Duplicate file list (name and size) for<br/>
            <font color="blue">
              <xsl:value-of select="filetree/folder/@name"/>
            </font>
          </h2>
          <h4>created by f2xml via duplicates.xsl<br/>
            <font size="-1">
              <a href="http://www.boulderwall.com">www.boulderwall.com</a>
            </font>
          </h4>
        </center>

        <xsl:if test="//file[@name='BOULDERWALL.com']">
          <h4>NOTE: XML output is from an unlicensed version of f2xml. Some files may be missing or named BOULDERWALL.com</h4>
        </xsl:if>
        <xsl:variable name="files" select="//file"/>

        <ol>
          <xsl:for-each select="msxsl:node-set($files)">
            <xsl:if test="@name = following::file/@name and
                          size = following::file/size and
                          not(@name = preceding::file/@name)">
              <li>
                <xsl:variable name="name" select="@name"/>
                <xsl:value-of select="$name"/>
                <xsl:variable name="size" select="size"/>
                <xsl:text>, size </xsl:text>
                <xsl:value-of select="$size"/>
                <xsl:text> bytes</xsl:text>
                <ul>
                  <xsl:for-each select="$files[@name=$name and $size=size]">
                    <li><xsl:value-of select="fullpath"/></li>
                  </xsl:for-each>
                </ul>
              </li>
            </xsl:if>
          </xsl:for-each>
        </ol>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="text()"/>

</xsl:stylesheet>
