unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, RVStyle, RVScroll, RichView, RVEdit, CRVFData, RVTable;

const WM_SETCARETPOS = WM_USER+10;

type
  TForm1 = class(TForm)
    RichViewEdit1: TRichViewEdit;
    RVStyle1: TRVStyle;
    Image1: TImage;
    Image2: TImage;
    Image3: TImage;
    procedure RichViewEdit1DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure RichViewEdit1DragDrop(Sender, Source: TObject; X,
      Y: Integer);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    Dragging: Boolean;
    procedure WMSetCaretPos(var Msg: TMessage); message WM_SETCARETPOS;
  public
    { Public declarations }
    procedure MoveCaretTo(X,Y: Integer);
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.RichViewEdit1DragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  Accept := Source is TImage;
  // We cannot create/destroy inplace editors for cells just
  // in OnDragOver, so we position caret in OnWMSetCaretPos
  // We same technique should be used for OnMouseMove
  if Accept then
    PostMessage(Handle, WM_SETCARETPOS, X,Y);
end;

procedure TForm1.WMSetCaretPos(var Msg: TMessage);
begin
  MoveCaretTo(Msg.WParam, Msg.LParam);
end;

procedure TForm1.MoveCaretTo(X, Y: Integer);
var RVData: TCustomRVFormattedData;
    ItemNo, Offs: Integer;
begin
  inc(X, RichViewEdit1.HScrollPos);
  inc(Y, RichViewEdit1.VScrollPos*RichViewEdit1.VSmallStep);
  RichViewEdit1.GetItemAt(X,Y,RVData,ItemNo,Offs, False);
  RVData := RVData.Edit as TCustomRVFormattedData;
  if ItemNo<0 then
    exit;
  RVData.SetSelectionBounds(ItemNo, Offs, ItemNo, Offs);
  RVData.Invalidate;
end;

procedure TForm1.RichViewEdit1DragDrop(Sender, Source: TObject; X,
  Y: Integer);
var bmp: TBitmap;
begin
  // Dragging is finished. Inserting picture.
  MoveCaretTo(X, Y);
  bmp := TBitmap.Create;
  bmp.Assign(TImage(Source).Picture.Bitmap);
  RichViewEdit1.InsertPicture('', bmp, rvvaBaseLine);
end;

procedure TForm1.FormCreate(Sender: TObject);
var i: Integer;
    table: TRVTableItemInfo;
begin
  RichViewEdit1.Clear;
  RichViewEdit1.AddNL('This demo shows dragging TImage to TRichViewEdit using VCL drag&drop procedures.',2,0);
  RichViewEdit1.AddNL('TRichViewEdit has its own drag&drop implementation: '+
    'you can drag inside TRichViewEdit, '+
    'from TRichViewEdit to another window/application, '+
    'from another window/application to TRichViewEdit.',2,0);
  for i := 0 to 5 do
    RichViewEdit1.AddNL('Drag images from the right and drop them here',0,0);

  table := TRVTableItemInfo.CreateEx(1,2, RichViewEdit1.RVData);
  table.CellBorderWidth := 1;
  table.BorderWidth := 1;
  table.Cells[0,0].Clear;
  table.Cells[0,0].AddNL('Drag images from the right and drop them here',0,0);
  table.Cells[0,1].Clear;
  table.Cells[0,1].AddNL('Drag images from the right and drop them here',0,0);
  RichViewEdit1.AddItem('', table);

  for i := 0 to 50 do
    RichViewEdit1.AddNL('Drag images from the right and drop them here',0,0);
  RichViewEdit1.Format;
end;

end.
