unit demoform;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  skuprintplaintext, StdCtrls, Buttons, ExtCtrls;

type
  TTPDemoForm = class(TForm)
    StaticText1: TStaticText;
    OpenDialog: TOpenDialog;
    btPrint: TButton;
    PrintDialog: TPrintDialog;
    StaticText2: TStaticText;
    comments: TMemo;
    StaticText3: TStaticText;
    btClose: TBitBtn;
    GroupBox1: TGroupBox;
    btLinewrap: TRadioButton;
    btNoWrap: TRadioButton;
    btWordwrap: TRadioButton;
    Label1: TLabel;
    btPrintWithComments: TButton;
    printText: TSKUPrintPlainText;
    btPreview: TButton;
    btPreview2: TButton;
    procedure btPrintClick(Sender: TObject);
    procedure btCloseClick(Sender: TObject);
    procedure btNoWrapClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btPrintWithCommentsClick(Sender: TObject);
  private
    procedure initRadios;
  end;

var
  TPDemoForm: TTPDemoForm;

implementation

{$R *.DFM}

const
  //IMPORTANT: These comments are inserted in the comment memo on FormCreate. Why
  //didn't we set them up with the Object Inspector "Lines" editor for the memo?
  //That editor is defective in that it divides the whole para into separate lines
  //with hard carriage returns. Hence, the print out won't print it as a real para
  //wrapped to the margins. Try that and you will see what I mean.
  commentStr:string =
   'Important comments: Please note that the resulting preview is based on the current '+
   'printer. In this demo, we decided to let the user select the printer for preview as '+
   'well. But, you may choose not to do that in your own application. But, you will have '+
   'to make it clear to the user that the preview is based on the current printer, and you '+
   'will have to provide a Printer Setup menu item to allow the user to set up a current '+
   'printer. It just depends on your design.';


//*******************************************
procedure TTPDemoForm.btCloseClick(Sender: TObject);
begin
  close;
end;

//*******************************************
procedure TTPDemoForm.FormCreate(Sender: TObject);
begin
  initRadios;
  comments.Text := commentStr;
end;

//*******************************************
procedure TTPDemoForm.initRadios;
begin
  case printtext.wrapMode of
    pptNoWrap: btNoWrap.checked := true;
    pptLineWrap: btLineWrap.checked := true;
    pptWordWrap: btWordWrap.checked := true;
  end;
end;

//*******************************************
procedure TTPDemoForm.btNoWrapClick(Sender: TObject);
begin
  if btNoWrap.checked then
    printtext.wrapMode := pptNoWrap
  else
  if btLineWrap.checked then
    printtext.wrapMode := pptLineWrap
  else
  if btWordWrap.checked then
    printtext.wrapMode := pptWordWrap;
end;

//*******************************************
procedure TTPDemoForm.btPrintClick(Sender: TObject);
begin
  if not opendialog.execute then
    exit;
  if not PrintDialog.Execute then
    exit;
  printtext.HeaderRight := DateToStr(Date) + ' ' + TimeToStr(Time);
  printtext.Title := opendialog.filename;
  printtext.footer := extractfilename(opendialog.filename);
  printtext.startPage := PrintDialog.fromPage;
  printtext.endPage := PrintDialog.toPage;
  //printtext.pagePrefix := 'PAGE'; //uncomment for page prefix test
  //The following nested try structure is
  //most convenient for using TSKUPrintPlainText
  try
    try
      printtext.isPreview := sender=btPreview;
      printtext.openPrinter;
      printtext.printAFile(opendialog.filename);
    except
      on E:exception do
      begin
        //Exception occurs in three cases:
        // 1. Genuine errors: hadErrors is true
        // 2. Printing cancelled: printCancelled is true
        // 3. 'To' page specified is finished. This is
        //    just to get out of printing and is normal.
        //    So hadErrors is false.
        //Usually, we want to give message only on had
        //Errors
        if printtext.hadErrors then
          showMessage(E.Message);
      end;
    end; //inner try
  finally
    printtext.closeprinter;
    if (sender = btPreview) and
      (not printtext.hadErrors) and (not printtext.printCancelled)
    then
      printtext.showPreview;
  end;
end;

//*******************************************
procedure TTPDemoForm.btPrintWithCommentsClick(Sender: TObject);
var
  i: integer;
  svMode: TSKUPptWrapMode;
  slist: TStringList;
begin
  //This is an advanced example
  if not opendialog.execute then
    exit;
  if not PrintDialog.Execute then
    exit;
  printtext.HeaderRight := DateToStr(Date) + ' ' + TimeToStr(Time);
  printtext.Title := opendialog.filename;
  printtext.footer := extractfilename(opendialog.filename);
  printtext.startPage := PrintDialog.fromPage;
  printtext.endPage := PrintDialog.toPage;
  //The following nested try structure is
  //most convenient for using TSKUPrintPlainText
  //Note how we preserve the original wrapMode
  //and restoure it
  svMode := printtext.wrapMode;
  slist := TStringlist.create; //for dealing with memo
  try
    try
      if sender=btPreview2 then
        printtext.isPreview := true;
      printtext.openPrinter;

      //print the comments if there
      if comments.lines.count > 0 then
      begin
        //We want to print comments word-wrapped
        printtext.wrapMode := pptWordWrap;
        //If we use the lines of TMemo, it will
        //give wrapped lines as per its own width.
        //What we want are the true paras with hard
        //carriage returns only. Hence, we use a
        //different technique.
        //If you don't understand what I mean above,
        //use the comments.lines and you will know
        //what I mean.
        slist.text := comments.text;
        for i:= 0 to slist.count-1 do
          printtext.printALine(slist[i]);
        printtext.skiplines(2);
        //restore the original wrap mode
        printtext.wrapMode := svMode;
      end;

      printtext.printAFile(opendialog.filename);
    except
      on E:exception do
      begin
        //Exception occurs in three cases:
        // 1. Genuine errors: hadErrors is true
        // 2. Printing cancelled: printCancelled is true
        // 3. 'To' page specified is finished. This is
        //    just to get out of printing and is normal.
        //    So hadErrors is false.
        //Usually, we want to give message only on had
        //Errors
        if printtext.hadErrors then
          showMessage(E.Message);
      end;
    end; //inner try
  finally
    printtext.wrapMode := svMode;
    printtext.closeprinter;
    slist.free;
    if (sender = btPreview2) and
      (not printtext.hadErrors) and (not printtext.printCancelled)
    then
      printtext.showPreview;
  end;
end;

end.
