unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DBTables, Db, Grids, DBGrids, StdCtrls, ExtCtrls, CachedQuery;

type
  TForm1 = class(TForm)
    Database: TDatabase;
    Panel1: TPanel;
    Label1: TLabel;
    Panel2: TPanel;
    Panel3: TPanel;
    DBGrid1: TDBGrid;
    DBGrid2: TDBGrid;
    Query1: TQuery;
    DataSource1: TDataSource;
    UpdateSQL1: TUpdateSQL;
    CachedQuery1: TCachedQuery;
    DataSource2: TDataSource;
    UpdateSQL2: TUpdateSQL;
    qryCreateTables: TQuery;
    Query1colID1: TAutoIncField;
    Query1colID2: TIntegerField;
    CachedQuery1colID1: TAutoIncField;
    CachedQuery1colID2: TIntegerField;
    CachedQuery1uStatus: TIntegerField;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    CheckBox1: TCheckBox;
    Panel4: TPanel;
    Memo1: TMemo;
    Memo2: TMemo;
    Button5: TButton;
    CheckBox2: TCheckBox;
    Panel5: TPanel;
    Panel6: TPanel;
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure CachedQuery1AfterSave(Sender: TObject);
    procedure CachedQuery1BeforeSave(DataSet: TDataSet);
    procedure Button5Click(Sender: TObject);
    procedure CachedQuery1Modified(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses Unit2, Unit3, Unit4;

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  with TForm2.Create(Self) do begin
    Edit1.Text := Database.Params.Values['SERVER NAME'];
    Edit2.Text := Database.Params.Values['DATABASE NAME'];
    Edit3.Text := Database.Params.Values['USER NAME'];
    Edit4.Text := Database.Params.Values['PASSWORD'];
    while not Database.Connected do begin
      if ShowModal=mrOk then begin
        Database.Params.Values['SERVER NAME']   := Edit1.Text;
        Database.Params.Values['DATABASE NAME'] := Edit2.Text;
        Database.Params.Values['USER NAME']     := Edit3.Text;
        Database.Params.Values['PASSWORD']      := Edit4.Text;
        try
          frmWait := TfrmWait.Create(Self);
          frmWait.Show;
          frmWait.Repaint;
          try
            Database.Connected := True;
          finally
            frmWait.Free;
          end;
        except
          Application.MessageBox('Can''t connect to your MS SQL Server', 'Error in parameters', MB_OK+MB_ICONQUESTION);
        end;
      end
      else begin
        Free;
        Application.Terminate;
      end;
    end;

    qryCreateTables.ExecSQL;
    Query1.Open;
    CachedQuery1.Open;
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Query1.Close;
  Query1.Open;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  CachedQuery1.ReOpen;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  if Query1.Active then begin
    Query1.CheckBrowseMode;
    if Query1.UpdatesPending then begin
      Database.StartTransaction;
      try
        Query1.ApplyUpdates;
        Database.Commit;
        Query1.CommitUpdates;
      except
        Database.Rollback;
      end;
    end;
  end;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  CachedQuery1.SaveUpdates(CheckBox1.Checked);
//  I URGENT ADVISE YOU REOPEN YOUR CachedQuery AND ANY Borland's query, AFTER YOU SAVED
//  YOUR DATASET.
  if CachedQuery1.LastSaveResult=SaveYes then
    CachedQuery1.ReOpen;
end;

procedure TForm1.CachedQuery1AfterSave(Sender: TObject);
begin
  if CheckBox2.Checked then
    ShowMessage('AfterSave');
end;

procedure TForm1.CachedQuery1BeforeSave(DataSet: TDataSet);
begin
  if CheckBox2.Checked then
    ShowMessage('BeforeSave');
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  with TfrmAbout.Create(Self) do begin
    ShowModal;
    Free;
  end;
end;

procedure TForm1.CachedQuery1Modified(Sender: TObject);
begin
  if CheckBox2.Checked then
    ShowMessage('OnModified');
end;

end.
