unit Simple;
{Example of use of b_Smple wrapper unit for BTRIEVE files.
Written by Paul Lurix (c) 1995. If you are a non registered client,
you may use or alter this demo only for evaluation purposes.
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs,  StdCtrls, Buttons, ExtCtrls, Menus;

type
  TSmpl_Ex = class(TForm)
    MainMenu1: TMainMenu;
    About1: TMenuItem;
    Exit1: TMenuItem;
    Test1: TMenuItem;
    Panel1: TPanel;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    CompCode: TEdit;
    CompName: TEdit;
    CompAddr: TEdit;
    CompCity: TEdit;
    CompState: TEdit;
    CompZip: TEdit;
    CompContact: TEdit;
    pnlOptions: TPanel;
    CmdFirst: TButton;
    CmdNext: TButton;
    cmdPrev: TButton;
    CmdLast: TButton;
    CmdDel: TButton;
    cmdAdd: TButton;
    cmdEdit: TButton;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;

    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Test1Click(Sender: TObject);
    procedure CmdFirstClick(Sender: TObject);
    procedure DisplayRecord(Sender: TObject);
    procedure SaveRecord(Sender: TObject);
    procedure CmdNextClick(Sender: TObject);
    procedure cmdPrevClick(Sender: TObject);
    procedure CmdLastClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure cmdAddClick(Sender: TObject);
    procedure cmdEditClick(Sender: TObject);
    procedure CmdDelClick(Sender: TObject);
    procedure About1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Smpl_Ex: TSmpl_Ex;
  IsAdd : Boolean;

IMPLEMENTATION
uses

  b_smple,        { Always include for calls to BTRIEVE }
  CompUnit,       { Unit for Company.BTR definition     }

  frmAbout;
{$R *.DFM}


procedure TSmpl_Ex.DisplayRecord(Sender: TObject);
begin
  IsAdd := false;
  CompCode.Text := Comp.Code;
  CompName.Text := Comp.Name;
  CompAddr.Text := Comp.Address1;
  CompCity.Text := Comp.City;
  CompState.Text := Comp.State;
  CompZip.Text := Comp.Zip;
  CompContact.Text := Comp.Contact;
end;

procedure TSmpl_Ex.SaveRecord(Sender: TObject);
begin
  FillChar(Comp, SizeOf(Comp), #0);
  Comp.Code := CompCode.Text;
  Comp.Name := CompName.Text;
  Comp.Address1 := CompAddr.Text;
  Comp.City := CompCity.Text;
  Comp.State := CompState.Text;
  Comp.Zip := CompZip.Text;
  Comp.Contact := CompContact.Text;
end;

procedure TSmpl_Ex.Button2Click(Sender: TObject);
begin
  Compb.bSmple_Op(B_Reset, Read_Only);
  close;
end;

procedure TSmpl_Ex.Button1Click(Sender: TObject);
begin
  Compb.bSmple_Op(B_get_first, 0);
  While (Compb.status = 0) do
    begin
      Compb.bSmple_Op(B_Get_Next, 0);
    end;
end;

procedure TSmpl_Ex.Exit1Click(Sender: TObject);
begin
 CompB.bSmple_Op(b_Reset,0);
 Close;
end;

procedure TSmpl_Ex.Test1Click(Sender: TObject);

begin
  FillChar(Comp, SizeOf(Comp), #0);
  CompProc;
  CompB.Path_Buf := ExtractFileDir(application.exename);
  Compb.bSmple_Op(B_Set_Dir, 0);
  if Compb.status <> 0 then
  begin
    COmpb.bDisplay_err(Compb.status);
  end;

  Compb.bSmple_Op(B_Open, Normal);
  if Compb.status <> 0 then
  begin
    COmpb.bDisplay_err(Compb.status);
  end;
  Compb.bSmple_Op(B_get_first, 0);
  pnlOptions.Visible := true;
  panel1.visible := true;
  CmdFirst.Setfocus;
end;

procedure TSmpl_Ex.CmdFirstClick(Sender: TObject);
begin
  CompCode.Readonly := true;
  Compb.bSmple_Op(B_get_first, 0);
  if Compb.Status = 0 then DisplayRecord(Sender);
end;

procedure TSmpl_Ex.CmdNextClick(Sender: TObject);
begin
  CompCode.Readonly := true;

  Compb.bSmple_Op(B_get_Next, 0);
  case CompB.Status of
    0 : DisplayRecord(Sender);

  Eof_Err :
    begin
      Compb.bSmple_Op(B_get_Last, 0);
      DisplayRecord(Sender);
    end;

  end;
end;


procedure TSmpl_Ex.cmdPrevClick(Sender: TObject);
begin
  CompCode.Readonly := true;
  Compb.bSmple_Op(B_get_Prev, 0);
  case CompB.Status of
    0 : DisplayRecord(Sender);
  Eof_Err :
    begin
      Compb.bSmple_Op(B_get_First, 0);
      DisplayRecord(Sender);
    end;
  end;

end;

procedure TSmpl_Ex.CmdLastClick(Sender: TObject);
begin
  CompCode.Readonly := true;
  Compb.bSmple_Op(B_get_Last, 0);
  if CompB.Status = 0 then DisplayRecord(Sender);
end;

procedure TSmpl_Ex.BitBtn1Click(Sender: TObject);
begin
   if not isAdd then
     begin
       SaveRecord(Sender);
       Compb.bSmple_Op(B_Update, 0);
     end
    else
     begin
       FillChar(Comp_Key_0.Code, SizeOf(Comp_Key_0.Code), #0);
       Comp_Key_0.code := CompCode.Text;
       Compb.bSmple_Op(B_Get_Eq, 0);
       if Compb.Status = Key_not_Found then
         begin
           FillChar(Comp, SizeOf(Comp), #0);
           SaveRecord(Sender);
           Compb.bSmple_op(B_insert, 0);
         end;
     end;
   BitBtn1.Visible := false;
   BitBtn2.Visible := false;
   pnlOptions.visible := true;


end;

procedure TSmpl_Ex.BitBtn2Click(Sender: TObject);
begin
   BitBtn1.Visible := false;
   BitBtn2.Visible := false;
   pnlOptions.visible := true;

end;

procedure TSmpl_Ex.cmdAddClick(Sender: TObject);
begin
  FillChar(Comp, SizeOf(Comp), #0);
  BitBtn1.Visible := true;
  BitBtn2.Visible := true;
  PnlOptions.Visible := false;
  CompCode.ReadOnly := false;
  DisplayRecord(Sender);
  IsAdd := true;
end;

procedure TSmpl_Ex.cmdEditClick(Sender: TObject);
begin
  BitBtn1.Visible := true;
  BitBtn2.Visible := true;
  PnlOptions.Visible := false;
  DisplayRecord(Sender);
end;

procedure TSmpl_Ex.CmdDelClick(Sender: TObject);
var
  ButDel : Integer;

begin
  ButDel := Application.MessageBox('Certain to Delete ?', 'DELETE Record', mb_OKCancel);
  if ButDel = IDOK then
    begin
      Compb.bSmple_Op(B_Delete, 0);
      if Compb.Status = 0 then
        begin
          Compb.bSmple_Op(B_Get_Prev, 0);
          if Compb.Status <> 0 then Compb.bSmple_Op(B_Get_First, 0);
          DisplayRecord(Sender);
        end;
    end;
end;

procedure TSmpl_Ex.About1Click(Sender: TObject);
begin
   AboutBox := tAboutBox.create(application);
   AboutBox.showmodal;
   AboutBox.free;
end;

end.
